/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cnf;

import org.chocosolver.solver.constraints.nary.cnf.ILogical;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.util.tools.ArrayUtils;

public final class LogOp
implements ILogical {
    protected Type type;
    protected Operator operator;
    protected ILogical[] children;
    protected BoolVar[] varsAsArray;

    protected LogOp(Operator operator, Type type, ILogical ... children) {
        this.type = type;
        this.operator = operator;
        this.children = children == null ? new ILogical[0] : children;
    }

    public static LogOp and(ILogical ... op) {
        return new LogOp(Operator.AND, Type.POSITIVE, op);
    }

    public static LogOp ifOnlyIf(ILogical a2, ILogical b2) {
        return LogOp.and(LogOp.implies(a2, b2), LogOp.implies(b2, a2));
    }

    public static LogOp ifThenElse(ILogical a2, ILogical b2, ILogical c2) {
        try {
            ILogical na = LogOp.negate(a2);
            return LogOp.or(LogOp.and(a2, b2), LogOp.and(na, c2));
        }
        catch (CloneNotSupportedException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static LogOp implies(ILogical a2, ILogical b2) {
        try {
            ILogical na = LogOp.negate(a2);
            return LogOp.or(na, b2);
        }
        catch (CloneNotSupportedException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static LogOp reified(BoolVar b2, ILogical tree) {
        try {
            BoolVar nb = b2.not();
            ILogical ntree = LogOp.negate(tree);
            return LogOp.or(LogOp.and(b2, tree), LogOp.and(nb, ntree));
        }
        catch (CloneNotSupportedException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static LogOp or(ILogical ... op) {
        return new LogOp(Operator.OR, Type.POSITIVE, op);
    }

    public static LogOp nand(ILogical ... op) {
        return new LogOp(Operator.AND, Type.NEGATIVE, op);
    }

    public static LogOp nor(ILogical ... op) {
        return new LogOp(Operator.OR, Type.NEGATIVE, op);
    }

    public static LogOp xor(ILogical a2, ILogical b2) {
        try {
            ILogical na = LogOp.negate(a2);
            ILogical nb = LogOp.negate(b2);
            return LogOp.or(LogOp.and(a2, nb), LogOp.and(b2, na));
        }
        catch (CloneNotSupportedException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private static ILogical negate(ILogical l) throws CloneNotSupportedException {
        if (l.isLit()) {
            return ((BoolVar)l).not();
        }
        LogOp n = (LogOp)l;
        LogOp na = n.clone();
        na.type = Type.flip(LogOp.and((ILogical[])new ILogical[0]).type);
        return na;
    }

    public boolean is(Operator op) {
        return op.equals((Object)this.operator);
    }

    @Override
    public boolean isNot() {
        return this.type.equals((Object)Type.NEGATIVE);
    }

    @Override
    public boolean isLit() {
        return false;
    }

    @Override
    public void setNot(boolean isNot) {
        throw new UnsupportedOperationException();
    }

    protected int getNbChildren() {
        return this.children.length;
    }

    protected boolean hasOrChild() {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].isLit() || !((LogOp)this.children[i]).is(Operator.OR)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAndChild() {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].isLit() || !((LogOp)this.children[i]).is(Operator.AND)) continue;
            return true;
        }
        return false;
    }

    public void addChild(ILogical child) {
        ILogical[] tmp = this.children;
        this.children = new ILogical[tmp.length + 1];
        System.arraycopy(tmp, 0, this.children, 0, tmp.length);
        this.children[tmp.length] = child;
        this.varsAsArray = null;
    }

    public void removeChild(ILogical child) {
        int i;
        for (i = 0; i < this.children.length && this.children[i] != child; ++i) {
        }
        if (i == this.children.length) {
            return;
        }
        ILogical[] tmp = this.children;
        this.children = new ILogical[tmp.length - 1];
        System.arraycopy(tmp, 0, this.children, 0, i);
        System.arraycopy(tmp, i + 1, this.children, i, tmp.length - i - 1);
        this.varsAsArray = null;
    }

    public ILogical[] getChildren() {
        return this.children;
    }

    public ILogical getAndChild() {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].isLit() || !((LogOp)this.children[i]).is(Operator.AND)) continue;
            return this.children[i];
        }
        return null;
    }

    public ILogical getChildBut(ILogical child) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == child) continue;
            return this.children[i];
        }
        return null;
    }

    public void flip() {
        this.type = Type.flip(this.type);
        this.operator = Operator.flip(this.operator);
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].isLit()) {
                this.children[i] = ((BoolVar)this.children[i]).not();
                continue;
            }
            ((LogOp)this.children[i]).deny();
        }
    }

    public void deny() {
        this.operator = Operator.flip(this.operator);
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].isLit()) {
                this.children[i] = ((BoolVar)this.children[i]).not();
                continue;
            }
            ((LogOp)this.children[i]).deny();
        }
    }

    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append('(');
        String op = (Type.POSITIVE.equals((Object)this.type) ? "" : "n") + (Operator.AND.equals((Object)this.operator) ? "and " : "or ");
        for (int i = 0; i < this.children.length; ++i) {
            ILogical child = this.children[i];
            if (child.isLit()) {
                st.append(((BoolVar)child).getName());
            } else {
                st.append(child);
            }
            st.append(" ").append(op);
        }
        st.replace(st.length() - (op.length() + 1), st.length(), "");
        st.append(')');
        return st.toString();
    }

    public LogOp clone() throws CloneNotSupportedException {
        LogOp logOp = (LogOp)super.clone();
        logOp.type = this.type;
        logOp.operator = this.operator;
        logOp.children = new ILogical[this.children.length];
        for (int c2 = 0; c2 < this.children.length; ++c2) {
            logOp.children[c2] = this.children[c2].isLit() ? this.children[c2] : ((LogOp)this.children[c2]).clone();
        }
        return logOp;
    }

    public BoolVar[] flattenBoolVar() {
        this.buildVarsArray();
        return this.varsAsArray;
    }

    public void cleanFlattenBoolVar() {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].isLit()) continue;
            ((LogOp)this.children[i]).cleanFlattenBoolVar();
        }
        this.varsAsArray = null;
    }

    private void buildVarsArray() {
        BoolVar[][] childrenVars = new BoolVar[this.children.length][];
        for (int i = 0; i < this.children.length; ++i) {
            childrenVars[i] = this.children[i].isLit() ? new BoolVar[]{(BoolVar)this.children[i]} : ((LogOp)this.children[i]).flattenBoolVar();
        }
        this.varsAsArray = ArrayUtils.flatten(childrenVars);
    }

    public static enum Type {
        POSITIVE,
        NEGATIVE;


        public static Type flip(Type type) {
            if (POSITIVE.equals((Object)type)) {
                return NEGATIVE;
            }
            return POSITIVE;
        }
    }

    public static enum Operator {
        OR,
        AND;


        public static Operator flip(Operator operator) {
            if (OR.equals((Object)operator)) {
                return AND;
            }
            return OR;
        }
    }
}

