/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.degree;

import gnu.trove.stack.array.TIntArrayStack;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IncidentSet;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.Orientation;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.PairProcedure;

public class PropNodeDegreeAtMostIncr
extends Propagator<GraphVar<?>> {
    private final GraphVar<?> g;
    private final int[] degrees;
    private final IncidentSet target;
    private final IGraphDeltaMonitor gdm;
    private final PairProcedure proc;
    private final IntProcedure nodeProc;
    private final TIntArrayStack stack = new TIntArrayStack();

    public PropNodeDegreeAtMostIncr(DirectedGraphVar graph, Orientation setType, int degree) {
        this(graph, setType, PropNodeDegreeAtMostIncr.buildArray(degree, graph.getNbMaxNodes()));
    }

    public PropNodeDegreeAtMostIncr(DirectedGraphVar graph, Orientation setType, int[] degrees2) {
        super((Variable[])new DirectedGraphVar[]{graph}, (Priority)PropagatorPriority.BINARY, true);
        this.g = graph;
        this.gdm = this.g.monitorDelta(this);
        this.degrees = degrees2;
        switch (setType) {
            case SUCCESSORS: {
                this.target = new IncidentSet.SuccessorsSet();
                this.proc = (i, j) -> this.stack.push(i);
                break;
            }
            case PREDECESSORS: {
                this.target = new IncidentSet.PredecessorsSet();
                this.proc = (i, j) -> this.stack.push(j);
                break;
            }
            default: {
                throw new UnsupportedOperationException("wrong parameter: use either PREDECESSORS or SUCCESSORS");
            }
        }
        this.nodeProc = this.stack::push;
    }

    public PropNodeDegreeAtMostIncr(UndirectedGraphVar graph, int degree) {
        this(graph, PropNodeDegreeAtMostIncr.buildArray(degree, graph.getNbMaxNodes()));
    }

    public PropNodeDegreeAtMostIncr(UndirectedGraphVar graph, int[] degrees2) {
        super((Variable[])new UndirectedGraphVar[]{graph}, (Priority)PropagatorPriority.BINARY, true);
        this.target = new IncidentSet.SuccessorsSet();
        this.g = graph;
        this.gdm = this.g.monitorDelta(this);
        this.degrees = degrees2;
        this.proc = (i, j) -> {
            this.stack.push(i);
            this.stack.push(j);
        };
        this.nodeProc = this.stack::push;
    }

    private static int[] buildArray(int degree, int n) {
        int[] degrees2 = new int[n];
        for (int i = 0; i < n; ++i) {
            degrees2[i] = degree;
        }
        return degrees2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            ISet act = this.g.getPotentialNodes();
            ISetIterator iSetIterator = act.iterator();
            while (iSetIterator.hasNext()) {
                int node = (Integer)iSetIterator.next();
                this.stack.push(node);
            }
            this.gdm.startMonitoring();
        }
        try {
            while (this.stack.size() > 0) {
                this.checkAtMost(this.stack.pop());
            }
        }
        finally {
            this.stack.clear();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.forEachNode(this.nodeProc, GraphEventType.REMOVE_NODE);
        this.gdm.forEachEdge(this.proc, GraphEventType.ADD_EDGE);
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return GraphEventType.ADD_EDGE.getMask() + GraphEventType.REMOVE_NODE.getMask();
    }

    @Override
    public ESat isEntailed() {
        ISet act = this.g.getMandatoryNodes();
        ISetIterator iSetIterator = act.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.target.getPotentialSet(this.g, i).size() <= this.degrees[i]) continue;
            return ESat.FALSE;
        }
        if (!this.g.isInstantiated()) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    private void checkAtMost(int i) throws ContradictionException {
        ISet pot = this.target.getPotentialSet(this.g, i);
        ISet ker = this.target.getMandatorySet(this.g, i);
        int kerSize = ker.size();
        if (kerSize > this.degrees[i]) {
            int s2;
            ISetIterator iSetIterator = this.g.getPotentialPredecessorOf(i).iterator();
            while (iSetIterator.hasNext()) {
                s2 = (Integer)iSetIterator.next();
                this.stack.push(s2);
            }
            iSetIterator = this.g.getPotentialSuccessorsOf(i).iterator();
            while (iSetIterator.hasNext()) {
                s2 = (Integer)iSetIterator.next();
                this.stack.push(s2);
            }
            this.g.removeNode(i, this);
        } else if (kerSize == this.degrees[i] && pot.size() > kerSize) {
            ISetIterator iSetIterator = pot.iterator();
            while (iSetIterator.hasNext()) {
                int s3 = (Integer)iSetIterator.next();
                if (ker.contains(s3)) continue;
                this.target.remove(this.g, i, s3, this);
                this.stack.push(s3);
            }
        }
    }
}

