/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.synthesis;

import java.awt.Point;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.wavelet.synthesis.InvWT;
import jj2000.j2k.wavelet.synthesis.MultiResImgData;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public abstract class InvWTAdapter
implements InvWT {
    protected DecoderSpecs decSpec;
    protected MultiResImgData mressrc;
    protected int reslvl;
    protected int maxImgRes;

    protected InvWTAdapter(MultiResImgData src, DecoderSpecs decSpec) {
        this.mressrc = src;
        this.decSpec = decSpec;
        this.maxImgRes = decSpec.dls.getMin();
    }

    public void setImgResLevel(int rl) {
        if (rl < 0) {
            throw new IllegalArgumentException("Resolution level index cannot be negative.");
        }
        this.reslvl = rl;
    }

    public int getTileWidth() {
        int tIdx = this.getTileIdx();
        int rl = 10000;
        int nc = this.mressrc.getNumComps();
        for (int c2 = 0; c2 < nc; ++c2) {
            int mrl = this.mressrc.getSynSubbandTree((int)tIdx, (int)c2).resLvl;
            if (mrl >= rl) continue;
            rl = mrl;
        }
        return this.mressrc.getTileWidth(rl);
    }

    public int getTileHeight() {
        int tIdx = this.getTileIdx();
        int rl = 10000;
        int nc = this.mressrc.getNumComps();
        for (int c2 = 0; c2 < nc; ++c2) {
            int mrl = this.mressrc.getSynSubbandTree((int)tIdx, (int)c2).resLvl;
            if (mrl >= rl) continue;
            rl = mrl;
        }
        return this.mressrc.getTileHeight(rl);
    }

    public int getNomTileWidth() {
        return this.mressrc.getNomTileWidth();
    }

    public int getNomTileHeight() {
        return this.mressrc.getNomTileHeight();
    }

    public int getImgWidth() {
        return this.mressrc.getImgWidth(this.reslvl);
    }

    public int getImgHeight() {
        return this.mressrc.getImgHeight(this.reslvl);
    }

    public int getNumComps() {
        return this.mressrc.getNumComps();
    }

    public int getCompSubsX(int c2) {
        return this.mressrc.getCompSubsX(c2);
    }

    public int getCompSubsY(int c2) {
        return this.mressrc.getCompSubsY(c2);
    }

    public int getTileCompWidth(int t, int c2) {
        int rl = this.mressrc.getSynSubbandTree((int)t, (int)c2).resLvl;
        return this.mressrc.getTileCompWidth(t, c2, rl);
    }

    public int getTileCompHeight(int t, int c2) {
        int rl = this.mressrc.getSynSubbandTree((int)t, (int)c2).resLvl;
        return this.mressrc.getTileCompHeight(t, c2, rl);
    }

    public int getCompImgWidth(int c2) {
        int rl = this.decSpec.dls.getMinInComp(c2);
        return this.mressrc.getCompImgWidth(c2, rl);
    }

    public int getCompImgHeight(int c2) {
        int rl = this.decSpec.dls.getMinInComp(c2);
        return this.mressrc.getCompImgHeight(c2, rl);
    }

    public void setTile(int x, int y) {
        this.mressrc.setTile(x, y);
    }

    public void nextTile() {
        this.mressrc.nextTile();
    }

    public Point getTile(Point co) {
        return this.mressrc.getTile(co);
    }

    public int getTileIdx() {
        return this.mressrc.getTileIdx();
    }

    public int getCompULX(int c2) {
        int tIdx = this.getTileIdx();
        int rl = this.mressrc.getSynSubbandTree((int)tIdx, (int)c2).resLvl;
        return this.mressrc.getResULX(c2, rl);
    }

    public int getCompULY(int c2) {
        int tIdx = this.getTileIdx();
        int rl = this.mressrc.getSynSubbandTree((int)tIdx, (int)c2).resLvl;
        return this.mressrc.getResULY(c2, rl);
    }

    public int getImgULX() {
        return this.mressrc.getImgULX(this.reslvl);
    }

    public int getImgULY() {
        return this.mressrc.getImgULY(this.reslvl);
    }

    public int getTilePartULX() {
        return this.mressrc.getTilePartULX();
    }

    public int getTilePartULY() {
        return this.mressrc.getTilePartULY();
    }

    public Point getNumTiles(Point co) {
        return this.mressrc.getNumTiles(co);
    }

    public int getNumTiles() {
        return this.mressrc.getNumTiles();
    }

    public SubbandSyn getSynSubbandTree(int t, int c2) {
        return this.mressrc.getSynSubbandTree(t, c2);
    }
}

