/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.forwcomptransf;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.util.StringTokenizer;
import jj2000.j2k.image.CompTransfSpec;
import jj2000.j2k.wavelet.FilterTypes;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilterSpec;

public class ForwCompTransfSpec
extends CompTransfSpec
implements FilterTypes {
    private String defaultValue = null;

    public ForwCompTransfSpec(int nt, int nc, byte type, AnWTFilterSpec wfs, J2KImageWriteParamJava wp, String values) {
        super(nt, nc, type);
        int t;
        String param = values;
        this.specified = values;
        if (values == null) {
            int c2;
            AnWTFilter[][] anfilt;
            if (nc < 3) {
                this.setDefault("none");
                return;
            }
            if (wp.getLossless()) {
                this.setDefault("rct");
                return;
            }
            int[] filtType = new int[this.nComp];
            for (int c3 = 0; c3 < 3; ++c3) {
                anfilt = (AnWTFilter[][])wfs.getCompDef(c3);
                filtType[c3] = anfilt[0][0].getFilterType();
            }
            boolean reject = false;
            for (c2 = 1; c2 < 3; ++c2) {
                if (filtType[c2] == filtType[0]) continue;
                reject = true;
            }
            if (reject) {
                this.setDefault("none");
            } else {
                anfilt = (AnWTFilter[][])wfs.getCompDef(0);
                if (anfilt[0][0].getFilterType() == 0) {
                    this.setDefault("ict");
                } else {
                    this.setDefault("rct");
                }
            }
            for (int t2 = 0; t2 < nt; ++t2) {
                AnWTFilter[][] anfilt2;
                int[] filtType2 = new int[this.nComp];
                for (c2 = 0; c2 < 3; ++c2) {
                    anfilt2 = (AnWTFilter[][])wfs.getTileCompVal(t2, c2);
                    filtType2[c2] = anfilt2[0][0].getFilterType();
                }
                boolean reject2 = false;
                for (int c4 = 1; c4 < this.nComp; ++c4) {
                    if (filtType2[c4] == filtType2[0]) continue;
                    reject2 = true;
                }
                if (reject2) {
                    this.setTileDef(t2, "none");
                    continue;
                }
                anfilt2 = (AnWTFilter[][])wfs.getTileCompVal(t2, 0);
                if (anfilt2[0][0].getFilterType() == 0) {
                    this.setTileDef(t2, "ict");
                    continue;
                }
                this.setTileDef(t2, "rct");
            }
            return;
        }
        if (param.equalsIgnoreCase("true")) {
            param = "on";
        }
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        block17: while (stk.hasMoreTokens()) {
            int i;
            String word = stk.nextToken();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = ForwCompTransfSpec.parseIdx(word, this.nTiles);
                    if (curSpecType == 1) {
                        curSpecType = 3;
                        continue block17;
                    }
                    curSpecType = 2;
                    continue block17;
                }
                case 'c': {
                    throw new IllegalArgumentException("Component specific  parameters not allowed with '-Mct' option");
                }
            }
            if (word.equals("off")) {
                if (curSpecType == 0) {
                    this.setDefault("none");
                } else if (curSpecType == 2) {
                    for (i = tileSpec.length - 1; i >= 0; --i) {
                        if (!tileSpec[i]) continue;
                        this.setTileDef(i, "none");
                    }
                }
            } else if (word.equals("on")) {
                if (nc < 3) {
                    this.setDefault("none");
                    continue;
                }
                if (curSpecType == 0) {
                    this.setDefault("rct");
                } else if (curSpecType == 2) {
                    for (i = tileSpec.length - 1; i >= 0; --i) {
                        if (!tileSpec[i]) continue;
                        if (this.getFilterType(i, wfs) == 1) {
                            this.setTileDef(i, "rct");
                            continue;
                        }
                        this.setTileDef(i, "ict");
                    }
                }
            } else {
                throw new IllegalArgumentException("Default parameter of option Mct not recognized: " + param);
            }
            curSpecType = 0;
            tileSpec = null;
        }
        if (this.getDefault() == null) {
            this.setDefault("none");
            for (t = 0; t < nt; ++t) {
                AnWTFilter[][] anfilt;
                if (this.isTileSpecified(t)) continue;
                int[] filtType = new int[this.nComp];
                for (int c5 = 0; c5 < 3; ++c5) {
                    anfilt = (AnWTFilter[][])wfs.getTileCompVal(t, c5);
                    filtType[c5] = anfilt[0][0].getFilterType();
                }
                boolean reject = false;
                for (int c6 = 1; c6 < this.nComp; ++c6) {
                    if (filtType[c6] == filtType[0]) continue;
                    reject = true;
                }
                if (reject) {
                    this.setTileDef(t, "none");
                    continue;
                }
                anfilt = (AnWTFilter[][])wfs.getTileCompVal(t, 0);
                if (anfilt[0][0].getFilterType() == 0) {
                    this.setTileDef(t, "ict");
                    continue;
                }
                this.setTileDef(t, "rct");
            }
        }
        block23: for (t = nt - 1; t >= 0; --t) {
            int filterType;
            if (((String)this.getTileDef(t)).equals("none")) continue;
            if (((String)this.getTileDef(t)).equals("rct")) {
                filterType = this.getFilterType(t, wfs);
                switch (filterType) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        if (this.isTileSpecified(t)) {
                            throw new IllegalArgumentException("Cannot use RCT with 9x7 filter in tile " + t);
                        }
                        this.setTileDef(t, "ict");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Default filter is not JPEG 2000 part I compliant");
                    }
                }
                continue;
            }
            filterType = this.getFilterType(t, wfs);
            switch (filterType) {
                case 1: {
                    if (this.isTileSpecified(t)) {
                        throw new IllegalArgumentException("Cannot use ICT with filter 5x3 in tile " + t);
                    }
                    this.setTileDef(t, "rct");
                    continue block23;
                }
                case 0: {
                    continue block23;
                }
                default: {
                    throw new IllegalArgumentException("Default filter is not JPEG 2000 part I compliant");
                }
            }
        }
    }

    private int getFilterType(int t, AnWTFilterSpec wfs) {
        int[] filtType = new int[this.nComp];
        for (int c2 = 0; c2 < this.nComp; ++c2) {
            AnWTFilter[][] anfilt = t == -1 ? (AnWTFilter[][])wfs.getCompDef(c2) : (AnWTFilter[][])wfs.getTileCompVal(t, c2);
            filtType[c2] = anfilt[0][0].getFilterType();
        }
        boolean reject = false;
        for (int c3 = 1; c3 < this.nComp; ++c3) {
            if (filtType[c3] == filtType[0]) continue;
            reject = true;
        }
        if (reject) {
            throw new IllegalArgumentException("Can not use component transformation when components do not use the same filters");
        }
        return filtType[0];
    }
}

