/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image;

import java.awt.Point;
import jj2000.j2k.NoNextElementException;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;

public class ImgDataJoiner
implements BlkImgDataSrc {
    private int w;
    private int h;
    private int nc;
    private BlkImgDataSrc[] imageData;
    private int[] compIdx;
    private int[] subsX;
    private int[] subsY;

    public ImgDataJoiner(BlkImgDataSrc[] imD, int[] cIdx) {
        int i;
        this.imageData = imD;
        this.compIdx = cIdx;
        if (this.imageData.length != this.compIdx.length) {
            throw new IllegalArgumentException("imD and cIdx must have the same length");
        }
        this.nc = imD.length;
        this.subsX = new int[this.nc];
        this.subsY = new int[this.nc];
        for (i = 0; i < this.nc; ++i) {
            if (imD[i].getNumTiles() == 1 && imD[i].getCompULX(cIdx[i]) == 0 && imD[i].getCompULY(cIdx[i]) == 0) continue;
            throw new IllegalArgumentException("All input components must, not use tiles and must have the origin at the canvas origin");
        }
        int maxW = 0;
        int maxH = 0;
        for (i = 0; i < this.nc; ++i) {
            if (imD[i].getCompImgWidth(cIdx[i]) > maxW) {
                maxW = imD[i].getCompImgWidth(cIdx[i]);
            }
            if (imD[i].getCompImgHeight(cIdx[i]) <= maxH) continue;
            maxH = imD[i].getCompImgHeight(cIdx[i]);
        }
        this.w = maxW;
        this.h = maxH;
        for (i = 0; i < this.nc; ++i) {
            this.subsX[i] = (maxW + imD[i].getCompImgWidth(cIdx[i]) - 1) / imD[i].getCompImgWidth(cIdx[i]);
            this.subsY[i] = (maxH + imD[i].getCompImgHeight(cIdx[i]) - 1) / imD[i].getCompImgHeight(cIdx[i]);
            if ((maxW + this.subsX[i] - 1) / this.subsX[i] == imD[i].getCompImgWidth(cIdx[i]) && (maxH + this.subsY[i] - 1) / this.subsY[i] == imD[i].getCompImgHeight(cIdx[i])) continue;
            throw new Error("Can not compute component subsampling factors: strange subsampling.");
        }
    }

    public int getTileWidth() {
        return this.w;
    }

    public int getTileHeight() {
        return this.h;
    }

    public int getNomTileWidth() {
        return this.w;
    }

    public int getNomTileHeight() {
        return this.h;
    }

    public int getImgWidth() {
        return this.w;
    }

    public int getImgHeight() {
        return this.h;
    }

    public int getNumComps() {
        return this.nc;
    }

    public int getCompSubsX(int c2) {
        return this.subsX[c2];
    }

    public int getCompSubsY(int c2) {
        return this.subsY[c2];
    }

    public int getTileCompWidth(int t, int c2) {
        return this.imageData[c2].getTileCompWidth(t, this.compIdx[c2]);
    }

    public int getTileCompHeight(int t, int c2) {
        return this.imageData[c2].getTileCompHeight(t, this.compIdx[c2]);
    }

    public int getCompImgWidth(int c2) {
        return this.imageData[c2].getCompImgWidth(this.compIdx[c2]);
    }

    public int getCompImgHeight(int n) {
        return this.imageData[n].getCompImgHeight(this.compIdx[n]);
    }

    public int getNomRangeBits(int c2) {
        return this.imageData[c2].getNomRangeBits(this.compIdx[c2]);
    }

    public int getFixedPoint(int c2) {
        return this.imageData[c2].getFixedPoint(this.compIdx[c2]);
    }

    public DataBlk getInternCompData(DataBlk blk, int c2) {
        return this.imageData[c2].getInternCompData(blk, this.compIdx[c2]);
    }

    public DataBlk getCompData(DataBlk blk, int c2) {
        return this.imageData[c2].getCompData(blk, this.compIdx[c2]);
    }

    public void setTile(int x, int y) {
        if (x != 0 || y != 0) {
            throw new IllegalArgumentException();
        }
    }

    public void nextTile() {
        throw new NoNextElementException();
    }

    public Point getTile(Point co) {
        if (co != null) {
            co.x = 0;
            co.y = 0;
            return co;
        }
        return new Point(0, 0);
    }

    public int getTileIdx() {
        return 0;
    }

    public int getCompULX(int c2) {
        return 0;
    }

    public int getCompULY(int c2) {
        return 0;
    }

    public int getTilePartULX() {
        return 0;
    }

    public int getTilePartULY() {
        return 0;
    }

    public int getImgULX() {
        return 0;
    }

    public int getImgULY() {
        return 0;
    }

    public Point getNumTiles(Point co) {
        if (co != null) {
            co.x = 1;
            co.y = 1;
            return co;
        }
        return new Point(1, 1);
    }

    public int getNumTiles() {
        return 1;
    }

    public String toString() {
        String string = "ImgDataJoiner: WxH = " + this.w + "x" + this.h;
        for (int i = 0; i < this.nc; ++i) {
            string = string + "\n- Component " + i + " " + this.imageData[i];
        }
        return string;
    }
}

