/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.Scale2OpImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public class Scale2BicubicOpImage
extends Scale2OpImage {
    protected InterpolationBicubic interpBN = null;
    private int[] dataHi;
    private int[] dataVi;
    private float[] dataHf;
    private float[] dataVf;
    private double[] dataHd;
    private double[] dataVd;
    private byte[][] byteLookupTable;

    public Scale2BicubicOpImage(RenderedImage source, ImageLayout layout, Map configuration, BorderExtender extender, Interpolation interp, double scaleX, double scaleY, double transX, double transY, boolean useRoiAccessor, Range nodata, double[] backgroundValues) {
        super(source, layout, configuration, true, extender, interp, scaleX, scaleY, transX, transY, useRoiAccessor, backgroundValues);
        this.scaleOpInitialization(source, interp, nodata, backgroundValues, useRoiAccessor);
    }

    private void scaleOpInitialization(RenderedImage source, Interpolation interp, Range nodata, double[] backgroundValues, boolean useRoiAccessor) {
        int i;
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel && ImageUtil.isBinary(source.getSampleModel())) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        SampleModel sm = source.getSampleModel();
        int srcDataType = sm.getDataType();
        int numBands = this.getSampleModel().getNumBands();
        if (this.invScaleXRationalNum.compareTo(this.invScaleXRationalDenom) > 0) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = Scale2BicubicOpImage.modnew(this.invScaleXRationalNum, this.invScaleXRationalDenom);
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRationalNum;
        }
        if (this.invScaleYRationalNum.compareTo(this.invScaleYRationalDenom) > 0) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = Scale2BicubicOpImage.modnew(this.invScaleYRationalNum, this.invScaleYRationalDenom);
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRationalNum;
        }
        this.interpolator = interp;
        Range nod = nodata;
        double[] destNod = null;
        if (this.interpolator instanceof InterpolationBicubic) {
            this.isBicubicNew = true;
            this.interpBN = (InterpolationBicubic)this.interpolator;
            this.interp = this.interpBN;
            switch (srcDataType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.dataHi = this.interpBN.getHorizontalTableData();
                    this.dataVi = this.interpBN.getVerticalTableData();
                    break;
                }
                case 4: {
                    this.dataHf = this.interpBN.getHorizontalTableDataFloat();
                    this.dataVf = this.interpBN.getVerticalTableDataFloat();
                    break;
                }
                case 5: {
                    this.dataHd = this.interpBN.getHorizontalTableDataDouble();
                    this.dataVd = this.interpBN.getVerticalTableDataDouble();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data Type");
                }
            }
            this.interpBN.setROIBounds(this.roiBounds);
            this.noData = this.interpBN.getNoDataRange();
            this.precisionBits = this.interpBN.getPrecisionBits();
            if (nod == null) {
                nod = this.interpBN.getNoDataRange();
            }
            if (destNod == null) {
                destNod = new double[]{this.interpBN.getDestinationNoData()};
            }
        }
        if (nod != null) {
            this.hasNoData = true;
            this.noData = nod;
        }
        if (destNod != null) {
            this.destinationNoDataDouble = destNod;
        }
        if (this.destinationNoDataDouble != null && this.destinationNoDataDouble.length < numBands) {
            double[] tmp = new double[numBands];
            Arrays.fill(tmp, this.destinationNoDataDouble[0]);
            this.destinationNoDataDouble = tmp;
        }
        if (this.hasROI) {
            this.useRoiAccessor = useRoiAccessor;
        }
        this.subsampleBits = interp.getSubsampleBitsH();
        if (this.precisionBits > 0) {
            this.round = 1 << this.precisionBits - 1;
        }
        this.one = 1 << this.subsampleBits;
        this.interp_width = interp.getWidth();
        this.interp_height = interp.getHeight();
        this.interp_left = interp.getLeftPadding();
        this.interp_top = interp.getTopPadding();
        this.destinationNoDataByte = new byte[numBands];
        this.destinationNoDataShort = new short[numBands];
        this.destinationNoDataUShort = new short[numBands];
        this.destinationNoDataInt = new int[numBands];
        this.destinationNoDataFloat = new float[numBands];
        for (i = 0; i < numBands; ++i) {
            this.destinationNoDataByte[i] = (byte)((int)this.destinationNoDataDouble[i] & 0xFF);
            this.destinationNoDataUShort[i] = (short)((short)this.destinationNoDataDouble[i] & 0xFFFF);
            this.destinationNoDataShort[i] = (short)this.destinationNoDataDouble[i];
            this.destinationNoDataInt[i] = (int)this.destinationNoDataDouble[i];
            this.destinationNoDataFloat[i] = (float)this.destinationNoDataDouble[i];
        }
        if (this.hasNoData) {
            this.byteLookupTable = new byte[numBands][256];
            for (i = 0; i < this.byteLookupTable[0].length; ++i) {
                byte value = (byte)i;
                for (int b2 = 0; b2 < numBands; ++b2) {
                    this.byteLookupTable[b2][i] = this.noData.contains(value) ? this.destinationNoDataByte[b2] : value;
                }
            }
        } else {
            for (i = 0; i < numBands; ++i) {
                this.destinationNoDataByte[i] = (byte)((int)this.backgroundValues[i] & 0xFF);
                this.destinationNoDataUShort[i] = (short)((short)this.backgroundValues[i] & 0xFFFF);
                this.destinationNoDataShort[i] = (short)this.backgroundValues[i];
                this.destinationNoDataInt[i] = (int)this.backgroundValues[i];
                this.destinationNoDataFloat[i] = (float)this.backgroundValues[i];
            }
        }
        if (this.hasNoData && this.destinationNoDataDouble != null) {
            this.setProperty("GC_NODATA", new NoDataContainer(this.destinationNoDataDouble));
        }
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = source.getBounds();
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int srcPixelStride = srcAccessor.getPixelStride();
        int srcScanlineStride = srcAccessor.getScanlineStride();
        int[] xpos = new int[dwidth];
        int[] ypos = new int[dheight];
        int[] yposRoi = null;
        int roiScanlineStride = 0;
        RasterAccessor roiAccessor = null;
        Raster roi = null;
        RandomIter roiIter = null;
        if (this.hasROI) {
            if (this.useRoiAccessor) {
                roi = this.srcROIImage.getBounds().contains(srcRect) ? this.srcROIImage.getData(srcRect) : this.srcROIImgExt.getData(srcRect);
                roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags(new RenderedImage[]{this.srcROIImage}, this.srcROIImage)[0], this.srcROIImage.getColorModel());
                roiScanlineStride = roiAccessor.getScanlineStride();
                yposRoi = new int[dheight];
            } else {
                roiIter = RandomIterFactory.create(this.srcROIImgExt, this.roiRect, true, true);
            }
        }
        int[] xfracValues = new int[dwidth];
        int[] yfracValues = new int[dheight];
        this.dataType = dest.getSampleModel().getDataType();
        this.preComputePositionsInt(destRect, srcRect.x, srcRect.y, srcPixelStride, srcScanlineStride, xpos, ypos, xfracValues, yfracValues, roiScanlineStride, yposRoi);
        switch (dstAccessor.getDataType()) {
            case 0: {
                this.byteLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride, roiIter);
                break;
            }
            case 1: {
                this.ushortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride, roiIter);
                break;
            }
            case 2: {
                this.shortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride, roiIter);
                break;
            }
            case 3: {
                this.intLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride, roiIter);
                break;
            }
            case 4: {
                this.floatLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride, roiIter);
                break;
            }
            case 5: {
                this.doubleLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride, roiIter);
            }
        }
        if (dstAccessor.isDataCopy()) {
            if (dstAccessor.needsClamping()) {
                dstAccessor.clampDataArrays();
            }
            dstAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        long sum = 0L;
                        int s2 = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h2 = 0; h2 < 4; ++h2) {
                            long temp = 0L;
                            for (int z = 0; z < 4; ++z) {
                                int pixelValue = srcData[pos + (z - 1) * srcPixelStride + (h2 - 1) * srcScanlineStride] & 0xFF;
                                temp += (long)(pixelValue * this.dataHi[offsetX + z]);
                            }
                            sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h2];
                        }
                        s2 = (int)(sum + (long)this.round >> this.precisionBits);
                        if (s2 > 255) {
                            s2 = 255;
                        } else if (s2 < 0) {
                            s2 = 0;
                        }
                        dstData[dstPixelOffset] = (byte)(s2 & 0xFF);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    byte[] srcData = srcDataArrays[k];
                    byte[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int[][] pixelKernel = new int[4][4];
                            int baseIndex = posx / dnumBands + yposRoi[j];
                            if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                            } else {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h3 = 0; h3 < 4; ++h3) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h3][z] = srcData[pos + (z - 1) * srcPixelStride + (h3 - 1) * srcScanlineStride] & 0xFF;
                                        int index = baseIndex - 1 + z + (h3 - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        temp += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                                } else {
                                    long sum = 0L;
                                    int s3 = 0;
                                    for (int h4 = 0; h4 < 4; ++h4) {
                                        long tempSum = 0L;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (long)(pixelKernel[h4][z] * this.dataHi[offsetX + z]);
                                        }
                                        sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h4];
                                    }
                                    s3 = (int)(sum + (long)this.round >> this.precisionBits);
                                    if (s3 > 255) {
                                        s3 = 255;
                                    } else if (s3 < 0) {
                                        s3 = 0;
                                    }
                                    dstData[dstPixelOffset] = (byte)(s3 & 0xFF);
                                }
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    byte[] srcData = srcDataArrays[k];
                    byte[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                            int[][] pixelKernel = new int[4][4];
                            int temp = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h5 = 0; h5 < 4; ++h5) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h5][z] = srcData[pos + (z - 1) * srcPixelStride + (h5 - 1) * srcScanlineStride] & 0xFF;
                                    int increment = this.roiBounds.contains(x0 + h5 - 1, y0 + z - 1) ? roiIter.getSample(x0 + h5 - 1, y0 + z - 1, 0) : 0;
                                    temp += increment & 0xFF;
                                }
                            }
                            if (temp == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                            } else {
                                long sum = 0L;
                                int s4 = 0;
                                for (int h6 = 0; h6 < 4; ++h6) {
                                    long tempSum = 0L;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (long)(pixelKernel[h6][z] * this.dataHi[offsetX + z]);
                                    }
                                    sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h6];
                                }
                                s4 = (int)(sum + (long)this.round >> this.precisionBits);
                                if (s4 > 255) {
                                    s4 = 255;
                                } else if (s4 < 0) {
                                    s4 = 0;
                                }
                                dstData[dstPixelOffset] = (byte)(s4 & 0xFF);
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            long[] emptyArray = new long[4];
            long tempSum = 0L;
            long sum = 0L;
            byte temp = 0;
            int s5 = 0;
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int offsetX = 4 * xfrac[i];
                        for (int h7 = 0; h7 < 4; ++h7) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h7][z] = srcData[pos + (z - 1) * srcPixelStride + (h7 - 1) * srcScanlineStride] & 0xFF;
                                weight = this.byteLookupTable[k][(int)pixelKernel[h7][z]] != this.destinationNoDataByte[k] ? (int)((short)(weight | 1 << 4 * h7 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h7 + z)));
                            }
                            temp = (byte)(weight >> 4 * h7 & 0xF);
                            long[] tempData = this.bicubicInpainting(pixelKernel[h7], temp, emptyArray);
                            tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                            weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h7)) : (int)((byte)(weightVert & 15 - (1 << h7)));
                            sumArray[h7] = tempSum + (long)this.round >> this.precisionBits;
                        }
                        if (weight == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                        } else {
                            weight = 0;
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weightVert = 0;
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            s5 = (int)(sum + (long)this.round >> this.precisionBits);
                            sum = 0L;
                            s5 = InterpolationBicubic.clampAndFixOvershootingByte(s5, this.destinationNoDataByte[k]);
                            dstData[dstPixelOffset] = (byte)(s5 & 0xFF);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long[] emptyArray = new long[4];
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int baseIndex = posx / dnumBands + yposRoi[j];
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                        } else {
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h8 = 0; h8 < 4; ++h8) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h8][z] = srcData[pos + (z - 1) * srcPixelStride + (h8 - 1) * srcScanlineStride] & 0xFF;
                                    int index = baseIndex - 1 + z + (h8 - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tempROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                    weight = this.byteLookupTable[k][(int)pixelKernel[h8][z]] != this.destinationNoDataByte[k] ? (int)((short)(weight | 1 << 4 * h8 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h8 + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                            } else {
                                long sum = 0L;
                                int s6 = 0;
                                for (int h9 = 0; h9 < 4; ++h9) {
                                    long tempSum = 0L;
                                    temp = (byte)(weight >> 4 * h9 & 0xF);
                                    long[] tempData = this.bicubicInpainting(pixelKernel[h9], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h9)) : (int)((byte)(weightVert & 15 - (1 << h9)));
                                    sumArray[h9] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                weightVert = 0;
                                weight = 0;
                                for (int h10 = 0; h10 < 4; ++h10) {
                                    sum += tempData[h10] * (long)this.dataVi[offsetY + h10];
                                }
                                s6 = (int)(sum + (long)this.round >> this.precisionBits);
                                s6 = InterpolationBicubic.clampAndFixOvershootingByte(s6, this.destinationNoDataByte[k]);
                                dstData[dstPixelOffset] = (byte)(s6 & 0xFF);
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long[] emptyArray = new long[4];
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                        int pos = posx + posy;
                        int tempROI = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h11 = 0; h11 < 4; ++h11) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h11][z] = srcData[pos + (z - 1) * srcPixelStride + (h11 - 1) * srcScanlineStride] & 0xFF;
                                int increment = this.roiBounds.contains(x0 + h11 - 1, y0 + z - 1) ? roiIter.getSample(x0 + h11 - 1, y0 + z - 1, 0) : 0;
                                tempROI += increment & 0xFF;
                                weight = this.byteLookupTable[k][(int)pixelKernel[h11][z]] != this.destinationNoDataByte[k] ? (int)((short)(weight | 1 << 4 * h11 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h11 + z)));
                            }
                        }
                        if (weight == 0 || tempROI == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                        } else {
                            long sum = 0L;
                            int s7 = 0;
                            for (int h12 = 0; h12 < 4; ++h12) {
                                long tempSum = 0L;
                                temp = (byte)(weight >> 4 * h12 & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h12], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h12)) : (int)((byte)(weightVert & 15 - (1 << h12)));
                                sumArray[h12] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h13 = 0; h13 < 4; ++h13) {
                                sum += tempData[h13] * (long)this.dataVi[offsetY + h13];
                            }
                            s7 = (int)(sum + (long)this.round >> this.precisionBits);
                            s7 = InterpolationBicubic.clampAndFixOvershootingByte(s7, this.destinationNoDataByte[k]);
                            dstData[dstPixelOffset] = (byte)(s7 & 0xFF);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void ushortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        long sum = 0L;
                        int s2 = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h2 = 0; h2 < 4; ++h2) {
                            long temp = 0L;
                            for (int z = 0; z < 4; ++z) {
                                int pixelValue = srcData[pos + (z - 1) * srcPixelStride + (h2 - 1) * srcScanlineStride] & 0xFFFF;
                                temp += (long)(pixelValue * this.dataHi[offsetX + z]);
                            }
                            sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h2];
                        }
                        s2 = (int)(sum + (long)this.round >> this.precisionBits);
                        if (s2 > 65536) {
                            s2 = 65536;
                        } else if (s2 < 0) {
                            s2 = 0;
                        }
                        dstData[dstPixelOffset] = (short)(s2 & 0xFFFF);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int[][] pixelKernel = new int[4][4];
                            int baseIndex = posx / dnumBands + yposRoi[j];
                            if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                            } else {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h3 = 0; h3 < 4; ++h3) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h3][z] = srcData[pos + (z - 1) * srcPixelStride + (h3 - 1) * srcScanlineStride] & 0xFFFF;
                                        int index = baseIndex - 1 + z + (h3 - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        temp += (short)(roiDataArray[index] & 0xFFFF) != 0 ? 1 : 0;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                                } else {
                                    long sum = 0L;
                                    int s3 = 0;
                                    for (int h4 = 0; h4 < 4; ++h4) {
                                        long tempSum = 0L;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (long)(pixelKernel[h4][z] * this.dataHi[offsetX + z]);
                                        }
                                        sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h4];
                                    }
                                    s3 = (int)(sum + (long)this.round >> this.precisionBits);
                                    s3 = InterpolationBicubic.clampAndFixOvershootingUShort(s3, this.destinationNoDataUShort[k]);
                                    dstData[dstPixelOffset] = (short)(s3 & 0xFFFF);
                                }
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                            int[][] pixelKernel = new int[4][4];
                            int temp = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h5 = 0; h5 < 4; ++h5) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h5][z] = srcData[pos + (z - 1) * srcPixelStride + (h5 - 1) * srcScanlineStride] & 0xFFFF;
                                    int increment = this.roiBounds.contains(x0 + h5 - 1, y0 + z - 1) ? roiIter.getSample(x0 + h5 - 1, y0 + z - 1, 0) : 0;
                                    temp += increment & 0xFFFF;
                                }
                            }
                            if (temp == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                            } else {
                                long sum = 0L;
                                int s4 = 0;
                                for (int h6 = 0; h6 < 4; ++h6) {
                                    long tempSum = 0L;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (long)(pixelKernel[h6][z] * this.dataHi[offsetX + z]);
                                    }
                                    sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h6];
                                }
                                s4 = (int)(sum + (long)this.round >> this.precisionBits);
                                s4 = InterpolationBicubic.clampAndFixOvershootingUShort(s4, this.destinationNoDataUShort[k]);
                                dstData[dstPixelOffset] = (short)(s4 & 0xFFFF);
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            int s5 = 0;
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int offsetX = 4 * xfrac[i];
                        for (int h7 = 0; h7 < 4; ++h7) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h7][z] = srcData[pos + (z - 1) * srcPixelStride + (h7 - 1) * srcScanlineStride] & 0xFFFF;
                                weight = !this.noData.contains((short)pixelKernel[h7][z]) ? (int)((short)(weight | 1 << 4 * h7 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h7 + z)));
                            }
                            temp = (byte)(weight >> 4 * h7 & 0xF);
                            long[] tempData = this.bicubicInpainting(pixelKernel[h7], temp, emptyArray);
                            tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                            weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h7)) : (int)((byte)(weightVert & 15 - (1 << h7)));
                            sumArray[h7] = tempSum + (long)this.round >> this.precisionBits;
                        }
                        if (weight == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                        } else {
                            temp = 0;
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            s5 = (int)(sum + (long)this.round >> this.precisionBits);
                            sum = 0L;
                            s5 = InterpolationBicubic.clampAndFixOvershootingUShort(s5, this.destinationNoDataUShort[k]);
                            dstData[dstPixelOffset] = (short)(s5 & 0xFFFF);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int baseIndex = posx / dnumBands + yposRoi[j];
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                        } else {
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h8 = 0; h8 < 4; ++h8) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h8][z] = srcData[pos + (z - 1) * srcPixelStride + (h8 - 1) * srcScanlineStride] & 0xFFFF;
                                    int index = baseIndex - 1 + z + (h8 - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tempROI += (short)(roiDataArray[index] & 0xFFFF) != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains((short)pixelKernel[h8][z]) ? (int)((short)(weight | 1 << 4 * h8 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h8 + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                            } else {
                                long sum = 0L;
                                int s6 = 0;
                                for (int h9 = 0; h9 < 4; ++h9) {
                                    long tempSum = 0L;
                                    temp = (byte)(weight >> 4 * h9 & 0xF);
                                    long[] tempData = this.bicubicInpainting(pixelKernel[h9], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h9)) : (int)((byte)(weightVert & 15 - (1 << h9)));
                                    sumArray[h9] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h10 = 0; h10 < 4; ++h10) {
                                    sum += tempData[h10] * (long)this.dataVi[offsetY + h10];
                                }
                                s6 = (int)(sum + (long)this.round >> this.precisionBits);
                                s6 = InterpolationBicubic.clampAndFixOvershootingUShort(s6, this.destinationNoDataUShort[k]);
                                dstData[dstPixelOffset] = (short)(s6 & 0xFFFF);
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                        int pos = posx + posy;
                        int tempROI = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h11 = 0; h11 < 4; ++h11) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h11][z] = srcData[pos + (z - 1) * srcPixelStride + (h11 - 1) * srcScanlineStride] & 0xFFFF;
                                int increment = this.roiBounds.contains(x0 + h11 - 1, y0 + z - 1) ? roiIter.getSample(x0 + h11 - 1, y0 + z - 1, 0) : 0;
                                tempROI += increment & 0xFFFF;
                                weight = !this.noData.contains((short)pixelKernel[h11][z]) ? (int)((short)(weight | 1 << 4 * h11 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h11 + z)));
                            }
                        }
                        if (weight == 0 || tempROI == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                        } else {
                            long sum = 0L;
                            int s7 = 0;
                            for (int h12 = 0; h12 < 4; ++h12) {
                                long tempSum = 0L;
                                temp = (byte)(weight >> 4 * h12 & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h12], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h12)) : (int)((byte)(weightVert & 15 - (1 << h12)));
                                sumArray[h12] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h13 = 0; h13 < 4; ++h13) {
                                sum += tempData[h13] * (long)this.dataVi[offsetY + h13];
                            }
                            s7 = (int)(sum + (long)this.round >> this.precisionBits);
                            s7 = InterpolationBicubic.clampAndFixOvershootingUShort(s7, this.destinationNoDataUShort[k]);
                            dstData[dstPixelOffset] = (short)(s7 & 0xFFFF);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void shortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        long sum = 0L;
                        int s2 = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h2 = 0; h2 < 4; ++h2) {
                            long temp = 0L;
                            for (int z = 0; z < 4; ++z) {
                                short pixelValue = srcData[pos + (z - 1) * srcPixelStride + (h2 - 1) * srcScanlineStride];
                                temp += (long)(pixelValue * this.dataHi[offsetX + z]);
                            }
                            sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h2];
                        }
                        s2 = (int)(sum + (long)this.round >> this.precisionBits);
                        if (s2 > Short.MAX_VALUE) {
                            s2 = Short.MAX_VALUE;
                        } else if (s2 < Short.MIN_VALUE) {
                            s2 = Short.MIN_VALUE;
                        }
                        dstData[dstPixelOffset] = (short)s2;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int[][] pixelKernel = new int[4][4];
                            int baseIndex = posx / dnumBands + yposRoi[j];
                            if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                            } else {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h3 = 0; h3 < 4; ++h3) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h3][z] = srcData[pos + (z - 1) * srcPixelStride + (h3 - 1) * srcScanlineStride];
                                        int index = baseIndex - 1 + z + (h3 - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        temp += (short)roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                                } else {
                                    long sum = 0L;
                                    int s3 = 0;
                                    for (int h4 = 0; h4 < 4; ++h4) {
                                        long tempSum = 0L;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (long)(pixelKernel[h4][z] * this.dataHi[offsetX + z]);
                                        }
                                        sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h4];
                                    }
                                    s3 = (int)(sum + (long)this.round >> this.precisionBits);
                                    if (s3 > Short.MAX_VALUE) {
                                        s3 = Short.MAX_VALUE;
                                    } else if (s3 < Short.MIN_VALUE) {
                                        s3 = Short.MIN_VALUE;
                                    }
                                    dstData[dstPixelOffset] = (short)s3;
                                }
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                            int[][] pixelKernel = new int[4][4];
                            int temp = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h5 = 0; h5 < 4; ++h5) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h5][z] = srcData[pos + (z - 1) * srcPixelStride + (h5 - 1) * srcScanlineStride];
                                    int increment = this.roiBounds.contains(x0 + h5 - 1, y0 + z - 1) ? roiIter.getSample(x0 + h5 - 1, y0 + z - 1, 0) : 0;
                                    temp += increment & 0xFFFF;
                                }
                            }
                            if (temp == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                            } else {
                                long sum = 0L;
                                int s4 = 0;
                                for (int h6 = 0; h6 < 4; ++h6) {
                                    long tempSum = 0L;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (long)(pixelKernel[h6][z] * this.dataHi[offsetX + z]);
                                    }
                                    sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h6];
                                }
                                s4 = (int)(sum + (long)this.round >> this.precisionBits);
                                if (s4 > Short.MAX_VALUE) {
                                    s4 = Short.MAX_VALUE;
                                } else if (s4 < Short.MIN_VALUE) {
                                    s4 = Short.MIN_VALUE;
                                }
                                dstData[dstPixelOffset] = (short)s4;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            int s5 = 0;
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int offsetX = 4 * xfrac[i];
                        for (int h7 = 0; h7 < 4; ++h7) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h7][z] = srcData[pos + (z - 1) * srcPixelStride + (h7 - 1) * srcScanlineStride];
                                weight = !this.noData.contains((short)pixelKernel[h7][z]) ? (int)((short)(weight | 1 << 4 * h7 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h7 + z)));
                            }
                            temp = (byte)(weight >> 4 * h7 & 0xF);
                            long[] tempData = this.bicubicInpainting(pixelKernel[h7], temp, emptyArray);
                            tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                            weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h7)) : (int)((byte)(weightVert & 15 - (1 << h7)));
                            sumArray[h7] = tempSum + (long)this.round >> this.precisionBits;
                        }
                        if (weight == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                        } else {
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            s5 = (int)(sum + (long)this.round >> this.precisionBits);
                            sum = 0L;
                            if (s5 > Short.MAX_VALUE) {
                                s5 = Short.MAX_VALUE;
                            } else if (s5 < Short.MIN_VALUE) {
                                s5 = Short.MIN_VALUE;
                            }
                            dstData[dstPixelOffset] = (short)s5;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int baseIndex = posx / dnumBands + yposRoi[j];
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                        } else {
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h8 = 0; h8 < 4; ++h8) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h8][z] = srcData[pos + (z - 1) * srcPixelStride + (h8 - 1) * srcScanlineStride];
                                    int index = baseIndex - 1 + z + (h8 - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tempROI += (short)roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains((short)pixelKernel[h8][z]) ? (int)((short)(weight | 1 << 4 * h8 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h8 + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                            } else {
                                long sum = 0L;
                                int s6 = 0;
                                for (int h9 = 0; h9 < 4; ++h9) {
                                    long tempSum = 0L;
                                    temp = (byte)(weight >> 4 * h9 & 0xF);
                                    long[] tempData = this.bicubicInpainting(pixelKernel[h9], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h9)) : (int)((byte)(weightVert & 15 - (1 << h9)));
                                    sumArray[h9] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h10 = 0; h10 < 4; ++h10) {
                                    sum += tempData[h10] * (long)this.dataVi[offsetY + h10];
                                }
                                s6 = (int)(sum + (long)this.round >> this.precisionBits);
                                if (s6 > Short.MAX_VALUE) {
                                    s6 = Short.MAX_VALUE;
                                } else if (s6 < Short.MIN_VALUE) {
                                    s6 = Short.MIN_VALUE;
                                }
                                dstData[dstPixelOffset] = (short)s6;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                        int pos = posx + posy;
                        int tempROI = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h11 = 0; h11 < 4; ++h11) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h11][z] = srcData[pos + (z - 1) * srcPixelStride + (h11 - 1) * srcScanlineStride];
                                int increment = this.roiBounds.contains(x0 + h11 - 1, y0 + z - 1) ? roiIter.getSample(x0 + h11 - 1, y0 + z - 1, 0) : 0;
                                tempROI += increment;
                                weight = !this.noData.contains((short)pixelKernel[h11][z]) ? (int)((short)(weight | 1 << 4 * h11 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h11 + z)));
                            }
                        }
                        if (weight == 0 || tempROI == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                        } else {
                            long sum = 0L;
                            int s7 = 0;
                            for (int h12 = 0; h12 < 4; ++h12) {
                                long tempSum = 0L;
                                temp = (byte)(weight >> 4 * h12 & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h12], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h12)) : (int)((byte)(weightVert & 15 - (1 << h12)));
                                sumArray[h12] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h13 = 0; h13 < 4; ++h13) {
                                sum += tempData[h13] * (long)this.dataVi[offsetY + h13];
                            }
                            s7 = (int)(sum + (long)this.round >> this.precisionBits);
                            if (s7 > Short.MAX_VALUE) {
                                s7 = Short.MAX_VALUE;
                            } else if (s7 < Short.MIN_VALUE) {
                                s7 = Short.MIN_VALUE;
                            }
                            dstData[dstPixelOffset] = (short)s7;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void intLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[][] dstDataArrays = dst.getIntDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        long sum = 0L;
                        int s2 = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h2 = 0; h2 < 4; ++h2) {
                            long temp = 0L;
                            for (int z = 0; z < 4; ++z) {
                                int pixelValue = srcData[pos + (z - 1) * srcPixelStride + (h2 - 1) * srcScanlineStride];
                                temp += (long)(pixelValue * this.dataHi[offsetX + z]);
                            }
                            sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h2];
                        }
                        dstData[dstPixelOffset] = s2 = (int)(sum + (long)this.round >> this.precisionBits);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    int[] srcData = srcDataArrays[k];
                    int[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int[][] pixelKernel = new int[4][4];
                            int baseIndex = posx / dnumBands + yposRoi[j];
                            if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataInt[k];
                            } else {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h3 = 0; h3 < 4; ++h3) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h3][z] = srcData[pos + (z - 1) * srcPixelStride + (h3 - 1) * srcScanlineStride];
                                        int index = baseIndex - 1 + z + (h3 - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        temp += roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataInt[k];
                                } else {
                                    long sum = 0L;
                                    int s3 = 0;
                                    for (int h4 = 0; h4 < 4; ++h4) {
                                        long tempSum = 0L;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (long)(pixelKernel[h4][z] * this.dataHi[offsetX + z]);
                                        }
                                        sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h4];
                                    }
                                    dstData[dstPixelOffset] = s3 = (int)(sum + (long)this.round >> this.precisionBits);
                                }
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    int[] srcData = srcDataArrays[k];
                    int[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                            int[][] pixelKernel = new int[4][4];
                            int temp = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h5 = 0; h5 < 4; ++h5) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h5][z] = srcData[pos + (z - 1) * srcPixelStride + (h5 - 1) * srcScanlineStride];
                                    int increment = this.roiBounds.contains(x0 + h5 - 1, y0 + z - 1) ? roiIter.getSample(x0 + h5 - 1, y0 + z - 1, 0) : 0;
                                    temp += increment;
                                }
                            }
                            if (temp == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataInt[k];
                            } else {
                                long sum = 0L;
                                int s4 = 0;
                                for (int h6 = 0; h6 < 4; ++h6) {
                                    long tempSum = 0L;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (long)(pixelKernel[h6][z] * this.dataHi[offsetX + z]);
                                    }
                                    sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h6];
                                }
                                dstData[dstPixelOffset] = s4 = (int)(sum + (long)this.round >> this.precisionBits);
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            int s5 = 0;
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int offsetX = 4 * xfrac[i];
                        for (int h7 = 0; h7 < 4; ++h7) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h7][z] = srcData[pos + (z - 1) * srcPixelStride + (h7 - 1) * srcScanlineStride];
                                weight = !this.noData.contains((int)pixelKernel[h7][z]) ? (int)((short)(weight | 1 << 4 * h7 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h7 + z)));
                            }
                            temp = (byte)(weight >> 4 * h7 & 0xF);
                            long[] tempData = this.bicubicInpainting(pixelKernel[h7], temp, emptyArray);
                            tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                            weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h7)) : (int)((byte)(weightVert & 15 - (1 << h7)));
                            sumArray[h7] = tempSum + (long)this.round >> this.precisionBits;
                        }
                        if (weight == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataInt[k];
                        } else {
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            s5 = (int)(sum + (long)this.round >> this.precisionBits);
                            sum = 0L;
                            dstData[dstPixelOffset] = s5;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int baseIndex = posx / dnumBands + yposRoi[j];
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataInt[k];
                        } else {
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h8 = 0; h8 < 4; ++h8) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h8][z] = srcData[pos + (z - 1) * srcPixelStride + (h8 - 1) * srcScanlineStride];
                                    int index = baseIndex - 1 + z + (h8 - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tempROI += roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains((int)pixelKernel[h8][z]) ? (int)((short)(weight | 1 << 4 * h8 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h8 + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataInt[k];
                            } else {
                                long sum = 0L;
                                int s6 = 0;
                                for (int h9 = 0; h9 < 4; ++h9) {
                                    long tempSum = 0L;
                                    temp = (byte)(weight >> 4 * h9 & 0xF);
                                    long[] tempData = this.bicubicInpainting(pixelKernel[h9], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h9)) : (int)((byte)(weightVert & 15 - (1 << h9)));
                                    sumArray[h9] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h10 = 0; h10 < 4; ++h10) {
                                    sum += tempData[h10] * (long)this.dataVi[offsetY + h10];
                                }
                                dstData[dstPixelOffset] = s6 = (int)(sum + (long)this.round >> this.precisionBits);
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                        int pos = posx + posy;
                        int tempROI = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h11 = 0; h11 < 4; ++h11) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h11][z] = srcData[pos + (z - 1) * srcPixelStride + (h11 - 1) * srcScanlineStride];
                                int increment = this.roiBounds.contains(x0 + h11 - 1, y0 + z - 1) ? roiIter.getSample(x0 + h11 - 1, y0 + z - 1, 0) : 0;
                                tempROI += increment;
                                weight = !this.noData.contains((int)pixelKernel[h11][z]) ? (int)((short)(weight | 1 << 4 * h11 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h11 + z)));
                            }
                        }
                        if (weight == 0 || tempROI == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataInt[k];
                        } else {
                            long sum = 0L;
                            int s7 = 0;
                            for (int h12 = 0; h12 < 4; ++h12) {
                                long tempSum = 0L;
                                temp = (byte)(weight >> 4 * h12 & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h12], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h12)) : (int)((byte)(weightVert & 15 - (1 << h12)));
                                sumArray[h12] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h13 = 0; h13 < 4; ++h13) {
                                sum += tempData[h13] * (long)this.dataVi[offsetY + h13];
                            }
                            dstData[dstPixelOffset] = s7 = (int)(sum + (long)this.round >> this.precisionBits);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void floatLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        double sum = 0.0;
                        int offsetX = 4 * xfrac[i];
                        for (int h2 = 0; h2 < 4; ++h2) {
                            double temp = 0.0;
                            for (int z = 0; z < 4; ++z) {
                                float pixelValue = srcData[pos + (z - 1) * srcPixelStride + (h2 - 1) * srcScanlineStride];
                                temp += (double)(pixelValue * this.dataHf[offsetX + z]);
                            }
                            sum += temp * (double)this.dataVf[offsetY + h2];
                        }
                        if (sum > 3.4028234663852886E38) {
                            sum = 3.4028234663852886E38;
                        } else if (sum < -3.4028234663852886E38) {
                            sum = -3.4028234663852886E38;
                        }
                        dstData[dstPixelOffset] = (float)sum;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    float[] srcData = srcDataArrays[k];
                    float[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            float[][] pixelKernel = new float[4][4];
                            int baseIndex = posx / dnumBands + yposRoi[j];
                            if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat[k];
                            } else {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h3 = 0; h3 < 4; ++h3) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h3][z] = srcData[pos + (z - 1) * srcPixelStride + (h3 - 1) * srcScanlineStride];
                                        int index = baseIndex - 1 + z + (h3 - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        temp += roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataFloat[k];
                                } else {
                                    double sum = 0.0;
                                    for (int h4 = 0; h4 < 4; ++h4) {
                                        double tempSum = 0.0;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (double)(pixelKernel[h4][z] * this.dataHf[offsetX + z]);
                                        }
                                        sum += tempSum * (double)this.dataVf[offsetY + h4];
                                    }
                                    if (sum > 3.4028234663852886E38) {
                                        sum = 3.4028234663852886E38;
                                    } else if (sum < -3.4028234663852886E38) {
                                        sum = -3.4028234663852886E38;
                                    }
                                    dstData[dstPixelOffset] = (float)sum;
                                }
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    float[] srcData = srcDataArrays[k];
                    float[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                            float[][] pixelKernel = new float[4][4];
                            int temp = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h5 = 0; h5 < 4; ++h5) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h5][z] = srcData[pos + (z - 1) * srcPixelStride + (h5 - 1) * srcScanlineStride];
                                    int increment = this.roiBounds.contains(x0 + h5 - 1, y0 + z - 1) ? roiIter.getSample(x0 + h5 - 1, y0 + z - 1, 0) : 0;
                                    temp += increment;
                                }
                            }
                            if (temp == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat[k];
                            } else {
                                double sum = 0.0;
                                for (int h6 = 0; h6 < 4; ++h6) {
                                    double tempSum = 0.0;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (double)(pixelKernel[h6][z] * this.dataHf[offsetX + z]);
                                    }
                                    sum += tempSum * (double)this.dataVf[offsetY + h6];
                                }
                                if (sum > 3.4028234663852886E38) {
                                    sum = 3.4028234663852886E38;
                                } else if (sum < -3.4028234663852886E38) {
                                    sum = -3.4028234663852886E38;
                                }
                                dstData[dstPixelOffset] = (float)sum;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            double tempSum = 0.0;
            double sum = 0.0;
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int offsetX = 4 * xfrac[i];
                        for (int h7 = 0; h7 < 4; ++h7) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h7][z] = srcData[pos + (z - 1) * srcPixelStride + (h7 - 1) * srcScanlineStride];
                                weight = !this.noData.contains((float)pixelKernel[h7][z]) ? (int)((short)(weight | 1 << 4 * h7 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h7 + z)));
                            }
                            temp = (byte)(weight >> 4 * h7 & 0xF);
                            double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h7], temp, emptyArray);
                            tempSum = tempData[0] * (double)this.dataHf[offsetX] + tempData[1] * (double)this.dataHf[offsetX + 1] + tempData[2] * (double)this.dataHf[offsetX + 2] + tempData[3] * (double)this.dataHf[offsetX + 3];
                            weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h7)) : (int)((byte)(weightVert & 15 - (1 << h7)));
                            sumArray[h7] = tempSum;
                        }
                        if (weight == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat[k];
                        } else {
                            double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            sum = tempData[0] * (double)this.dataVf[offsetY] + tempData[1] * (double)this.dataVf[offsetY + 1] + tempData[2] * (double)this.dataVf[offsetY + 2] + tempData[3] * (double)this.dataVf[offsetY + 3];
                            if (sum > 3.4028234663852886E38) {
                                sum = 3.4028234663852886E38;
                            } else if (sum < -3.4028234663852886E38) {
                                sum = -3.4028234663852886E38;
                            }
                            dstData[dstPixelOffset] = (float)sum;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int baseIndex = posx / dnumBands + yposRoi[j];
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat[k];
                        } else {
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h8 = 0; h8 < 4; ++h8) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h8][z] = srcData[pos + (z - 1) * srcPixelStride + (h8 - 1) * srcScanlineStride];
                                    int index = baseIndex - 1 + z + (h8 - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tempROI += roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains((float)pixelKernel[h8][z]) ? (int)((short)(weight | 1 << 4 * h8 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h8 + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat[k];
                            } else {
                                double sum = 0.0;
                                for (int h9 = 0; h9 < 4; ++h9) {
                                    double tempSum = 0.0;
                                    temp = (byte)(weight >> 4 * h9 & 0xF);
                                    double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h9], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (double)this.dataHf[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h9)) : (int)((byte)(weightVert & 15 - (1 << h9)));
                                    sumArray[h9] = tempSum;
                                }
                                double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h10 = 0; h10 < 4; ++h10) {
                                    sum += tempData[h10] * (double)this.dataVf[offsetY + h10];
                                }
                                if (sum > 3.4028234663852886E38) {
                                    sum = 3.4028234663852886E38;
                                } else if (sum < -3.4028234663852886E38) {
                                    sum = -3.4028234663852886E38;
                                }
                                dstData[dstPixelOffset] = (float)sum;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                        int pos = posx + posy;
                        int tempROI = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h11 = 0; h11 < 4; ++h11) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h11][z] = srcData[pos + (z - 1) * srcPixelStride + (h11 - 1) * srcScanlineStride];
                                int increment = this.roiBounds.contains(x0 + h11 - 1, y0 + z - 1) ? roiIter.getSample(x0 + h11 - 1, y0 + z - 1, 0) : 0;
                                tempROI += increment;
                                weight = !this.noData.contains((float)pixelKernel[h11][z]) ? (int)((short)(weight | 1 << 4 * h11 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h11 + z)));
                            }
                        }
                        if (weight == 0 || tempROI == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat[k];
                        } else {
                            double sum = 0.0;
                            for (int h12 = 0; h12 < 4; ++h12) {
                                double tempSum = 0.0;
                                temp = (byte)(weight >> 4 * h12 & 0xF);
                                double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h12], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (double)this.dataHf[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h12)) : (int)((byte)(weightVert & 15 - (1 << h12)));
                                sumArray[h12] = tempSum;
                            }
                            double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h13 = 0; h13 < 4; ++h13) {
                                sum += tempData[h13] * (double)this.dataVf[offsetY + h13];
                            }
                            if (sum > 3.4028234663852886E38) {
                                sum = 3.4028234663852886E38;
                            } else if (sum < -3.4028234663852886E38) {
                                sum = -3.4028234663852886E38;
                            }
                            dstData[dstPixelOffset] = (float)sum;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void doubleLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        double sum = 0.0;
                        int offsetX = 4 * xfrac[i];
                        for (int h2 = 0; h2 < 4; ++h2) {
                            double temp = 0.0;
                            for (int z = 0; z < 4; ++z) {
                                double pixelValue = srcData[pos + (z - 1) * srcPixelStride + (h2 - 1) * srcScanlineStride];
                                temp += pixelValue * this.dataHd[offsetX + z];
                            }
                            sum += temp * this.dataVd[offsetY + h2];
                        }
                        dstData[dstPixelOffset] = sum;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    double[] srcData = srcDataArrays[k];
                    double[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            double[][] pixelKernel = new double[4][4];
                            int baseIndex = posx / dnumBands + yposRoi[j];
                            if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble[k];
                            } else {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h3 = 0; h3 < 4; ++h3) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h3][z] = srcData[pos + (z - 1) * srcPixelStride + (h3 - 1) * srcScanlineStride];
                                        int index = baseIndex - 1 + z + (h3 - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        temp += roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataDouble[k];
                                } else {
                                    double sum = 0.0;
                                    for (int h4 = 0; h4 < 4; ++h4) {
                                        double tempSum = 0.0;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += pixelKernel[h4][z] * this.dataHd[offsetX + z];
                                        }
                                        sum += tempSum * this.dataVd[offsetY + h4];
                                    }
                                    dstData[dstPixelOffset] = sum;
                                }
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    double[] srcData = srcDataArrays[k];
                    double[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                            double[][] pixelKernel = new double[4][4];
                            int temp = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h5 = 0; h5 < 4; ++h5) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h5][z] = srcData[pos + (z - 1) * srcPixelStride + (h5 - 1) * srcScanlineStride];
                                    int increment = this.roiBounds.contains(x0 + h5 - 1, y0 + z - 1) ? roiIter.getSample(x0 + h5 - 1, y0 + z - 1, 0) : 0;
                                    temp += increment;
                                }
                            }
                            if (temp == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble[k];
                            } else {
                                double sum = 0.0;
                                for (int h6 = 0; h6 < 4; ++h6) {
                                    double tempSum = 0.0;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += pixelKernel[h6][z] * this.dataHd[offsetX + z];
                                    }
                                    sum += tempSum * this.dataVd[offsetY + h6];
                                }
                                dstData[dstPixelOffset] = sum;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            double tempSum = 0.0;
            double sum = 0.0;
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int offsetX = 4 * xfrac[i];
                        for (int h7 = 0; h7 < 4; ++h7) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h7][z] = srcData[pos + (z - 1) * srcPixelStride + (h7 - 1) * srcScanlineStride];
                                weight = !this.noData.contains(pixelKernel[h7][z]) ? (int)((short)(weight | 1 << 4 * h7 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h7 + z)));
                            }
                            temp = (byte)(weight >> 4 * h7 & 0xF);
                            double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h7], temp, emptyArray);
                            tempSum = tempData[0] * this.dataHd[offsetX] + tempData[1] * this.dataHd[offsetX + 1] + tempData[2] * this.dataHd[offsetX + 2] + tempData[3] * this.dataHd[offsetX + 3];
                            weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h7)) : (int)((byte)(weightVert & 15 - (1 << h7)));
                            sumArray[h7] = tempSum;
                        }
                        if (weight == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble[k];
                        } else {
                            double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            dstData[dstPixelOffset] = sum = tempData[0] * this.dataVd[offsetY] + tempData[1] * this.dataVd[offsetY + 1] + tempData[2] * this.dataVd[offsetY + 2] + tempData[3] * this.dataVd[offsetY + 3];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int baseIndex = posx / dnumBands + yposRoi[j];
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble[k];
                        } else {
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h8 = 0; h8 < 4; ++h8) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h8][z] = srcData[pos + (z - 1) * srcPixelStride + (h8 - 1) * srcScanlineStride];
                                    int index = baseIndex - 1 + z + (h8 - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tempROI += roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains(pixelKernel[h8][z]) ? (int)((short)(weight | 1 << 4 * h8 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h8 + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble[k];
                            } else {
                                double sum = 0.0;
                                for (int h9 = 0; h9 < 4; ++h9) {
                                    double tempSum = 0.0;
                                    temp = (byte)(weight >> 4 * h9 & 0xF);
                                    double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h9], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * this.dataHd[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h9)) : (int)((byte)(weightVert & 15 - (1 << h9)));
                                    sumArray[h9] = tempSum;
                                }
                                double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h10 = 0; h10 < 4; ++h10) {
                                    sum += tempData[h10] * this.dataVd[offsetY + h10];
                                }
                                dstData[dstPixelOffset] = sum;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                        int pos = posx + posy;
                        int tempROI = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h11 = 0; h11 < 4; ++h11) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h11][z] = srcData[pos + (z - 1) * srcPixelStride + (h11 - 1) * srcScanlineStride];
                                int increment = this.roiBounds.contains(x0 + h11 - 1, y0 + z - 1) ? roiIter.getSample(x0 + h11 - 1, y0 + z - 1, 0) : 0;
                                tempROI += increment;
                                weight = !this.noData.contains(pixelKernel[h11][z]) ? (int)((short)(weight | 1 << 4 * h11 + z)) : (int)((short)(weight & 65535 - (1 << 4 * h11 + z)));
                            }
                        }
                        if (weight == 0 || tempROI == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble[k];
                        } else {
                            double sum = 0.0;
                            for (int h12 = 0; h12 < 4; ++h12) {
                                double tempSum = 0.0;
                                temp = (byte)(weight >> 4 * h12 & 0xF);
                                double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h12], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * this.dataHd[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h12)) : (int)((byte)(weightVert & 15 - (1 << h12)));
                                sumArray[h12] = tempSum;
                            }
                            double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h13 = 0; h13 < 4; ++h13) {
                                sum += tempData[h13] * this.dataVd[offsetY + h13];
                            }
                            dstData[dstPixelOffset] = sum;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private long[] bicubicInpainting(long[] array, short weightSum, long[] emptyArray) {
        if (weightSum == 15) {
            return array;
        }
        long s_ = array[0];
        long s0 = array[1];
        long s1 = array[2];
        long s2 = array[3];
        emptyArray[0] = 0L;
        emptyArray[1] = 0L;
        emptyArray[2] = 0L;
        emptyArray[3] = 0L;
        switch (weightSum) {
            case 0: {
                break;
            }
            case 1: {
                emptyArray[0] = s_;
                emptyArray[1] = s_;
                emptyArray[2] = s_;
                emptyArray[3] = s_;
                break;
            }
            case 2: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 3: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 4: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 5: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2L;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 6: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 7: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 8: {
                emptyArray[0] = s2;
                emptyArray[1] = s2;
                emptyArray[2] = s2;
                emptyArray[3] = s2;
                break;
            }
            case 9: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s2) / 2L;
                emptyArray[2] = (s_ + s2) / 2L;
                emptyArray[3] = s2;
                break;
            }
            case 10: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2L;
                emptyArray[3] = s2;
                break;
            }
            case 11: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2L;
                emptyArray[3] = s2;
                break;
            }
            case 12: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 13: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2L;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 14: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Array cannot be composed from more than 4 elements");
            }
        }
        return emptyArray;
    }

    private double[] bicubicInpaintingDouble(double[] array, short weightSum, double[] emptyArray) {
        if (weightSum == 15) {
            return array;
        }
        double s_ = array[0];
        double s0 = array[1];
        double s1 = array[2];
        double s2 = array[3];
        emptyArray[0] = 0.0;
        emptyArray[1] = 0.0;
        emptyArray[2] = 0.0;
        emptyArray[3] = 0.0;
        switch (weightSum) {
            case 0: {
                break;
            }
            case 1: {
                emptyArray[0] = s_;
                emptyArray[1] = s_;
                emptyArray[2] = s_;
                emptyArray[3] = s_;
                break;
            }
            case 2: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 3: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 4: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 5: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2.0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 6: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 7: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 8: {
                emptyArray[0] = s2;
                emptyArray[1] = s2;
                emptyArray[2] = s2;
                emptyArray[3] = s2;
                break;
            }
            case 9: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s2) / 2.0;
                emptyArray[2] = (s_ + s2) / 2.0;
                emptyArray[3] = s2;
                break;
            }
            case 10: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2.0;
                emptyArray[3] = s2;
                break;
            }
            case 11: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2.0;
                emptyArray[3] = s2;
                break;
            }
            case 12: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 13: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2.0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 14: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Array cannot be composed from more than 4 elements");
            }
        }
        return emptyArray;
    }
}

