/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.bandcombine;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public class BandCombineOpImage
extends PointOpImage {
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    private final boolean hasNoData;
    private Range noData;
    private boolean[] lut;
    private final boolean hasROI;
    private ROI roi;
    private final boolean caseA;
    private final boolean caseB;
    private final boolean caseC;
    private final Rectangle roiBounds;
    private PlanarImage roiImage;
    private double[][] matrix;
    private byte destNoDataByte;
    private short destNoDataShort;
    private int destNoDataInt;
    private float destNoDataFloat;
    private double destNoDataDouble;

    public BandCombineOpImage(RenderedImage source, Map config, ImageLayout layout, double[][] matrix, ROI roi, Range noData, double destinationNoData) {
        super(source, layout, config, true);
        this.matrix = matrix;
        int numBands = matrix.length;
        if (this.getSampleModel().getNumBands() != numBands) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getDataType(), this.tileWidth, this.tileHeight, numBands);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, config);
            }
        }
        if (roi != null) {
            this.hasROI = true;
            this.roi = roi;
            this.roiBounds = roi.getBounds();
        } else {
            this.hasROI = false;
            this.roi = null;
            this.roiBounds = null;
        }
        if (noData != null) {
            this.hasNoData = true;
            this.noData = noData;
        } else {
            this.hasNoData = false;
        }
        int dataType = source.getSampleModel().getDataType();
        this.destNoDataDouble = destinationNoData;
        switch (dataType) {
            case 0: {
                this.destNoDataByte = ImageUtil.clampRoundByte(destinationNoData);
                break;
            }
            case 1: {
                this.destNoDataShort = ImageUtil.clampRoundUShort(destinationNoData);
                break;
            }
            case 2: {
                this.destNoDataShort = ImageUtil.clampRoundShort(destinationNoData);
                break;
            }
            case 3: {
                this.destNoDataInt = ImageUtil.clampRoundInt(destinationNoData);
                break;
            }
            case 4: {
                this.destNoDataFloat = ImageUtil.clampFloat(destinationNoData);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image data type");
            }
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        boolean bl = this.caseC = this.hasNoData && !this.hasROI;
        if (this.hasNoData && dataType == 0) {
            this.initBooleanNoDataTable();
        }
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor s2 = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor d2 = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiTile = this.roi.intersect(new ROIShape(srcRectExpanded));
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create(roiIMG, null, true, true);
                    }
                }
            }
        }
        if (!this.hasROI || !roiDisjointTile) {
            switch (d2.getDataType()) {
                case 0: {
                    this.computeRectByte(s2, d2, roiIter, roiContainsTile);
                    break;
                }
                case 1: {
                    this.computeRectUShort(s2, d2, roiIter, roiContainsTile);
                    break;
                }
                case 2: {
                    this.computeRectShort(s2, d2, roiIter, roiContainsTile);
                    break;
                }
                case 3: {
                    this.computeRectInt(s2, d2, roiIter, roiContainsTile);
                    break;
                }
                case 4: {
                    this.computeRectFloat(s2, d2, roiIter, roiContainsTile);
                    break;
                }
                case 5: {
                    this.computeRectDouble(s2, d2, roiIter, roiContainsTile);
                }
            }
            if (d2.isDataCopy()) {
                d2.clampDataArrays();
                d2.copyDataToRaster();
            }
        } else {
            double[] backgroundValues = new double[s2.getNumBands()];
            Arrays.fill(backgroundValues, this.destNoDataDouble);
            ImageUtil.fillBackground(dest, destRect, backgroundValues);
        }
    }

    private void computeRectByte(RasterAccessor s2, RasterAccessor d2, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = s2.getScanlineStride();
        int srcPixelStride = s2.getPixelStride();
        int srcBands = s2.getNumBands();
        int[] srcBandOffsets = s2.getBandOffsets();
        byte[][] srcData = s2.getByteDataArrays();
        int dstWidth = d2.getWidth();
        int dstHeight = d2.getHeight();
        int dstBands = d2.getNumBands();
        int dstLineStride = d2.getScanlineStride();
        int dstPixelStride = d2.getPixelStride();
        int[] dstBandOffsets = d2.getBandOffsets();
        byte[][] dstData = d2.getByteDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = s2.getX();
        int srcY = s2.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b2 = 0; b2 < dstBands; ++b2) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b2];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)(srcData[k][srcPixelOffset + srcBandOffsets[k]] & 0xFF);
                        }
                        dstData[b2][dstPixelOffset + dstBandOffsets[b2]] = ImageUtil.clampRoundByte(sum += (float)mat[srcBands]);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    x0 = srcX + w;
                    y0 = srcY + h3;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b3 = 0; b3 < dstBands; ++b3) {
                            dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = this.destNoDataByte;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b3 = 0; b3 < dstBands; ++b3) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b3];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)(srcData[k][srcPixelOffset + srcBandOffsets[k]] & 0xFF);
                        }
                        dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = ImageUtil.clampRoundByte(sum += (float)mat[srcBands]);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b4 = 0; b4 < dstBands; ++b4) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b4];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            byte sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (!this.lut[sample & 0xFF]) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)(sample & 0xFF);
                        }
                        dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = valid ? ImageUtil.clampRoundByte(sum += (float)mat[srcBands]) : this.destNoDataByte;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    x0 = srcX + w;
                    y0 = srcY + h5;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = this.destNoDataByte;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b5 = 0; b5 < dstBands; ++b5) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b5];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            byte sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (!this.lut[sample & 0xFF]) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)(sample & 0xFF);
                        }
                        dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = valid ? ImageUtil.clampRoundByte(sum += (float)mat[srcBands]) : this.destNoDataByte;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void computeRectUShort(RasterAccessor s2, RasterAccessor d2, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = s2.getScanlineStride();
        int srcPixelStride = s2.getPixelStride();
        int srcBands = s2.getNumBands();
        int[] srcBandOffsets = s2.getBandOffsets();
        short[][] srcData = s2.getShortDataArrays();
        int dstWidth = d2.getWidth();
        int dstHeight = d2.getHeight();
        int dstBands = d2.getNumBands();
        int dstLineStride = d2.getScanlineStride();
        int dstPixelStride = d2.getPixelStride();
        int[] dstBandOffsets = d2.getBandOffsets();
        short[][] dstData = d2.getShortDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = s2.getX();
        int srcY = s2.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b2 = 0; b2 < dstBands; ++b2) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b2];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)(srcData[k][srcPixelOffset + srcBandOffsets[k]] & 0xFFFF);
                        }
                        dstData[b2][dstPixelOffset + dstBandOffsets[b2]] = ImageUtil.clampRoundUShort(sum += (float)mat[srcBands]);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    x0 = srcX + w;
                    y0 = srcY + h3;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b3 = 0; b3 < dstBands; ++b3) {
                            dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = this.destNoDataShort;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b3 = 0; b3 < dstBands; ++b3) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b3];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)(srcData[k][srcPixelOffset + srcBandOffsets[k]] & 0xFFFF);
                        }
                        dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = ImageUtil.clampRoundUShort(sum += (float)mat[srcBands]);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b4 = 0; b4 < dstBands; ++b4) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b4];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            short sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)(sample & 0xFFFF);
                        }
                        dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = valid ? ImageUtil.clampRoundUShort(sum += (float)mat[srcBands]) : this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    x0 = srcX + w;
                    y0 = srcY + h5;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = this.destNoDataShort;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b5 = 0; b5 < dstBands; ++b5) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b5];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            short sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)(sample & 0xFFFF);
                        }
                        dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = valid ? ImageUtil.clampRoundUShort(sum += (float)mat[srcBands]) : this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void computeRectShort(RasterAccessor s2, RasterAccessor d2, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = s2.getScanlineStride();
        int srcPixelStride = s2.getPixelStride();
        int srcBands = s2.getNumBands();
        int[] srcBandOffsets = s2.getBandOffsets();
        short[][] srcData = s2.getShortDataArrays();
        int dstWidth = d2.getWidth();
        int dstHeight = d2.getHeight();
        int dstBands = d2.getNumBands();
        int dstLineStride = d2.getScanlineStride();
        int dstPixelStride = d2.getPixelStride();
        int[] dstBandOffsets = d2.getBandOffsets();
        short[][] dstData = d2.getShortDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = s2.getX();
        int srcY = s2.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b2 = 0; b2 < dstBands; ++b2) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b2];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b2][dstPixelOffset + dstBandOffsets[b2]] = ImageUtil.clampRoundShort(sum += (float)mat[srcBands]);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    x0 = srcX + w;
                    y0 = srcY + h3;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b3 = 0; b3 < dstBands; ++b3) {
                            dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = this.destNoDataShort;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b3 = 0; b3 < dstBands; ++b3) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b3];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = ImageUtil.clampRoundShort(sum += (float)mat[srcBands]);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b4 = 0; b4 < dstBands; ++b4) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b4];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            short sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)sample;
                        }
                        dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = valid ? ImageUtil.clampRoundShort(sum += (float)mat[srcBands]) : this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    x0 = srcX + w;
                    y0 = srcY + h5;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = this.destNoDataShort;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b5 = 0; b5 < dstBands; ++b5) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b5];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            short sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)sample;
                        }
                        dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = valid ? ImageUtil.clampRoundShort(sum += (float)mat[srcBands]) : this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void computeRectInt(RasterAccessor s2, RasterAccessor d2, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = s2.getScanlineStride();
        int srcPixelStride = s2.getPixelStride();
        int srcBands = s2.getNumBands();
        int[] srcBandOffsets = s2.getBandOffsets();
        int[][] srcData = s2.getIntDataArrays();
        int dstWidth = d2.getWidth();
        int dstHeight = d2.getHeight();
        int dstBands = d2.getNumBands();
        int dstLineStride = d2.getScanlineStride();
        int dstPixelStride = d2.getPixelStride();
        int[] dstBandOffsets = d2.getBandOffsets();
        int[][] dstData = d2.getIntDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = s2.getX();
        int srcY = s2.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b2 = 0; b2 < dstBands; ++b2) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b2];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b2][dstPixelOffset + dstBandOffsets[b2]] = ImageUtil.clampRoundInt(sum += (float)mat[srcBands]);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    x0 = srcX + w;
                    y0 = srcY + h3;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b3 = 0; b3 < dstBands; ++b3) {
                            dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = this.destNoDataInt;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b3 = 0; b3 < dstBands; ++b3) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b3];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = ImageUtil.clampRoundInt(sum += (float)mat[srcBands]);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b4 = 0; b4 < dstBands; ++b4) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b4];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            int sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)sample;
                        }
                        dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = valid ? ImageUtil.clampRoundInt(sum += (float)mat[srcBands]) : this.destNoDataInt;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    x0 = srcX + w;
                    y0 = srcY + h5;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = this.destNoDataInt;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b5 = 0; b5 < dstBands; ++b5) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b5];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            int sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)sample;
                        }
                        dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = valid ? ImageUtil.clampRoundInt(sum += (float)mat[srcBands]) : this.destNoDataInt;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void computeRectFloat(RasterAccessor s2, RasterAccessor d2, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = s2.getScanlineStride();
        int srcPixelStride = s2.getPixelStride();
        int srcBands = s2.getNumBands();
        int[] srcBandOffsets = s2.getBandOffsets();
        float[][] srcData = s2.getFloatDataArrays();
        int dstWidth = d2.getWidth();
        int dstHeight = d2.getHeight();
        int dstBands = d2.getNumBands();
        int dstLineStride = d2.getScanlineStride();
        int dstPixelStride = d2.getPixelStride();
        int[] dstBandOffsets = d2.getBandOffsets();
        float[][] dstData = d2.getFloatDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = s2.getX();
        int srcY = s2.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b2 = 0; b2 < dstBands; ++b2) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b2];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b2][dstPixelOffset + dstBandOffsets[b2]] = sum += (float)mat[srcBands];
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    x0 = srcX + w;
                    y0 = srcY + h3;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b3 = 0; b3 < dstBands; ++b3) {
                            dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = this.destNoDataFloat;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b3 = 0; b3 < dstBands; ++b3) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b3];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = sum += (float)mat[srcBands];
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b4 = 0; b4 < dstBands; ++b4) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b4];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            float sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * sample;
                        }
                        dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = valid ? (sum += (float)mat[srcBands]) : this.destNoDataFloat;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    x0 = srcX + w;
                    y0 = srcY + h5;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = this.destNoDataFloat;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b5 = 0; b5 < dstBands; ++b5) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b5];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            float sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * sample;
                        }
                        dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = valid ? (sum += (float)mat[srcBands]) : this.destNoDataFloat;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void computeRectDouble(RasterAccessor s2, RasterAccessor d2, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = s2.getScanlineStride();
        int srcPixelStride = s2.getPixelStride();
        int srcBands = s2.getNumBands();
        int[] srcBandOffsets = s2.getBandOffsets();
        double[][] srcData = s2.getDoubleDataArrays();
        int dstWidth = d2.getWidth();
        int dstHeight = d2.getHeight();
        int dstBands = d2.getNumBands();
        int dstLineStride = d2.getScanlineStride();
        int dstPixelStride = d2.getPixelStride();
        int[] dstBandOffsets = d2.getBandOffsets();
        double[][] dstData = d2.getDoubleDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = s2.getX();
        int srcY = s2.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b2 = 0; b2 < dstBands; ++b2) {
                        double sum = 0.0;
                        double[] mat = this.matrix[b2];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += mat[k] * srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b2][dstPixelOffset + dstBandOffsets[b2]] = sum += mat[srcBands];
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    x0 = srcX + w;
                    y0 = srcY + h3;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b3 = 0; b3 < dstBands; ++b3) {
                            dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = this.destNoDataDouble;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b3 = 0; b3 < dstBands; ++b3) {
                        double sum = 0.0;
                        double[] mat = this.matrix[b3];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += mat[k] * srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b3][dstPixelOffset + dstBandOffsets[b3]] = sum += (double)((float)mat[srcBands]);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b4 = 0; b4 < dstBands; ++b4) {
                        double sum = 0.0;
                        double[] mat = this.matrix[b4];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            double sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += mat[k] * sample;
                        }
                        dstData[b4][dstPixelOffset + dstBandOffsets[b4]] = valid ? (sum += mat[srcBands]) : this.destNoDataDouble;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    x0 = srcX + w;
                    y0 = srcY + h5;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = this.destNoDataDouble;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b5 = 0; b5 < dstBands; ++b5) {
                        double sum = 0.0;
                        double[] mat = this.matrix[b5];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            double sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (double)((float)mat[k] * (float)sample);
                        }
                        dstData[b5][dstPixelOffset + dstBandOffsets[b5]] = valid ? (sum += mat[srcBands]) : this.destNoDataDouble;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void initBooleanNoDataTable() {
        this.lut = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            boolean result = true;
            if (this.noData.contains((byte)i)) {
                result = false;
            }
            this.lut[i] = result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            BandCombineOpImage bandCombineOpImage = this;
            synchronized (bandCombineOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }
}

