/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.iterator;

import com.sun.media.jai.iterator.RandomIterCSM;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;

public class RandomIterCSMByte
extends RandomIterCSM {
    byte[][] bankData;

    public RandomIterCSMByte(RenderedImage im, Rectangle bounds) {
        super(im, bounds);
    }

    protected final void dataBufferChanged() {
        this.bankData = ((DataBufferByte)this.dataBuffer).getBankData();
    }

    public final int getSample(int x, int y, int b2) {
        this.makeCurrent(x - this.boundsX, y - this.boundsY);
        return this.bankData[b2][(x - this.sampleModelTranslateX) * this.pixelStride + (y - this.sampleModelTranslateY) * this.scanlineStride + this.bandOffsets[b2]] & 0xFF;
    }

    public final float getSampleFloat(int x, int y, int b2) {
        this.makeCurrent(x - this.boundsX, y - this.boundsX);
        return this.bankData[b2][(x - this.sampleModelTranslateX) * this.pixelStride + (y - this.sampleModelTranslateY) * this.scanlineStride + this.bandOffsets[b2]] & 0xFF;
    }

    public final double getSampleDouble(int x, int y, int b2) {
        this.makeCurrent(x - this.boundsX, y - this.boundsX);
        return this.bankData[b2][(x - this.sampleModelTranslateX) * this.pixelStride + (y - this.sampleModelTranslateY) * this.scanlineStride + this.bandOffsets[b2]] & 0xFF;
    }

    public int[] getPixel(int x, int y, int[] iArray) {
        if (iArray == null) {
            iArray = new int[this.numBands];
        }
        int offset = (x - this.sampleModelTranslateX) * this.pixelStride + (y - this.sampleModelTranslateY) * this.scanlineStride;
        for (int b2 = 0; b2 < this.numBands; ++b2) {
            iArray[b2] = this.bankData[b2][offset + this.bandOffsets[b2]] & 0xFF;
        }
        return iArray;
    }
}

