/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.InvertedCMYKColorSpace;
import com.sun.media.imageioimpl.plugins.clib.CLibImageReader;
import com.sun.media.imageioimpl.plugins.clib.InputStreamAdapter;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGMetadata;
import com.sun.media.imageioimpl.plugins.jpeg.I18N;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jpeg.Decoder;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

final class CLibJPEGImageReader
extends CLibImageReader {
    private static final boolean DEBUG = false;
    private mediaLibImage infoImage = null;
    private int infoImageIndex = -1;
    private byte[] iccProfileData = null;
    private IIOMetadata imageMetadata = null;
    private int imageMetadataIndex = -1;
    private HashMap imageTypes = new HashMap();
    private int bitDepth;

    CLibJPEGImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    protected final synchronized mediaLibImage decode(InputStream stream) throws IOException {
        mediaLibImage mlImage = null;
        Decoder decoder = null;
        try {
            int format;
            if (stream instanceof InputStreamAdapter) {
                ImageInputStream iis = ((InputStreamAdapter)stream).getWrappedStream();
                decoder = new Decoder(iis);
            } else {
                decoder = new Decoder(stream);
            }
            mlImage = decoder.decode(null);
            this.iccProfileData = decoder.getEmbeddedICCProfile();
            if (this.iccProfileData != null && mlImage.getType() == 1 && ((format = mlImage.getFormat()) == 11 || format == 14)) {
                long t0 = System.currentTimeMillis();
                byte[] data = mlImage.getByteData();
                int len = data.length;
                for (int i = mlImage.getOffset(); i < len; ++i) {
                    data[i] = (byte)(255 - data[i] & 0xFF);
                }
            }
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
        if (mlImage == null) {
            throw new IIOException(I18N.getString("CLibJPEGImageReader0"));
        }
        try {
            this.bitDepth = decoder.getDepth();
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
        decoder.dispose();
        return mlImage;
    }

    private synchronized mediaLibImage getInfoImage(int imageIndex) throws IOException {
        if (this.infoImage == null || imageIndex != this.infoImageIndex) {
            if (imageIndex == this.getImageIndex()) {
                this.infoImage = this.getImage(imageIndex);
                this.infoImageIndex = imageIndex;
                return this.infoImage;
            }
            if (this.input == null) {
                throw new IllegalStateException("input == null");
            }
            ImageInputStream iis = null;
            if (!(this.input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("!(input instanceof ImageInputStream)");
            }
            iis = (ImageInputStream)this.input;
            this.seekToImage(imageIndex);
            iis.mark();
            Decoder decoder = null;
            try {
                decoder = new Decoder(iis);
                this.infoImage = decoder.getSize();
                this.iccProfileData = decoder.getEmbeddedICCProfile();
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
            if (this.infoImage == null || this.infoImage.getFormat() == 0 && (this.infoImage = this.getImage(imageIndex)) == null) {
                throw new IIOException(I18N.getString("CLibJPEGImageReader0"));
            }
            this.infoImageIndex = imageIndex;
            try {
                this.bitDepth = decoder.getDepth();
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
            iis.reset();
            decoder.dispose();
        }
        return this.infoImage;
    }

    public int getWidth(int imageIndex) throws IOException {
        return this.getInfoImage(imageIndex).getWidth();
    }

    public int getHeight(int imageIndex) throws IOException {
        return this.getInfoImage(imageIndex).getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getImageTypes(int imageIndex) throws IOException {
        this.seekToImage(imageIndex);
        ArrayList types = null;
        HashMap hashMap = this.imageTypes;
        synchronized (hashMap) {
            Integer key = new Integer(imageIndex);
            if (this.imageTypes.containsKey(key)) {
                types = (ArrayList)this.imageTypes.get(key);
            } else {
                ColorSpace cs;
                types = new ArrayList();
                mediaLibImage mlImage = this.getInfoImage(imageIndex);
                if (this.iccProfileData != null) {
                    ICC_Profile profile = ICC_Profile.getInstance(this.iccProfileData);
                    cs = new ICC_ColorSpace(profile);
                    types.add(CLibJPEGImageReader.createImageType(mlImage, cs, this.bitDepth, null, null, null, null));
                }
                cs = mlImage.getFormat() == 11 ? InvertedCMYKColorSpace.getInstance() : null;
                types.add(CLibJPEGImageReader.createImageType(mlImage, cs, this.bitDepth, null, null, null, null));
            }
        }
        return types.iterator();
    }

    public synchronized IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("input == null");
        }
        if (this.imageMetadata == null || imageIndex != this.imageMetadataIndex) {
            this.seekToImage(imageIndex);
            ImageInputStream stream = (ImageInputStream)this.input;
            long pos = stream.getStreamPosition();
            try {
                this.imageMetadata = new CLibJPEGMetadata(stream);
                this.imageMetadataIndex = imageIndex;
            }
            catch (IIOException e2) {
                throw e2;
            }
            finally {
                stream.seek(pos);
            }
        }
        return this.imageMetadata;
    }

    public boolean readerSupportsThumbnails() {
        return true;
    }

    public int getNumThumbnails(int imageIndex) throws IOException {
        CLibJPEGMetadata metadata = (CLibJPEGMetadata)this.getImageMetadata(imageIndex);
        return metadata.getNumThumbnails();
    }

    public BufferedImage readThumbnail(int imageIndex, int thumbnailIndex) throws IOException {
        CLibJPEGMetadata metadata = (CLibJPEGMetadata)this.getImageMetadata(imageIndex);
        return metadata.getThumbnail(thumbnailIndex);
    }

    protected void resetLocal() {
        this.infoImage = null;
        this.infoImageIndex = -1;
        this.iccProfileData = null;
        this.imageMetadata = null;
        this.imageMetadataIndex = -1;
        this.imageTypes.clear();
        super.resetLocal();
    }
}

