/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual.layout;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;
import salvo.jesus.graph.GraphException;
import salvo.jesus.graph.Tree;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.Visitor;
import salvo.jesus.graph.algorithm.DepthFirstGraphTraversal;
import salvo.jesus.graph.algorithm.GraphTraversal;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.visual.layout.AbstractGridLayout;
import salvo.jesus.graph.visual.layout.Grid;
import salvo.jesus.graph.visual.layout.TreeGridAdjuster;

public class LayeredTreeLayout
extends AbstractGridLayout
implements Visitor {
    List verticesReadyForPositioning;
    List gridsOfVertices;
    static Category logCategory = Category.getInstance((String)(class$salvo$jesus$graph$visual$layout$LayeredTreeLayout == null ? (class$salvo$jesus$graph$visual$layout$LayeredTreeLayout = LayeredTreeLayout.class$("salvo.jesus.graph.visual.layout.LayeredTreeLayout")) : class$salvo$jesus$graph$visual$layout$LayeredTreeLayout).getName());
    static /* synthetic */ Class class$salvo$jesus$graph$visual$layout$LayeredTreeLayout;

    public LayeredTreeLayout(VisualGraph vGraph) {
        super(vGraph);
    }

    public void layout() {
        ArrayList visited = new ArrayList(10);
        super.layout();
        this.verticesReadyForPositioning = new ArrayList(10);
        this.initGridsOfVertices();
        Tree tree = (Tree)this.vgraph.getGraph();
        DepthFirstGraphTraversal traversal = new DepthFirstGraphTraversal(this.vgraph.getGraph());
        ((GraphTraversal)traversal).traverse(tree.getRoot(), visited, this);
        this.drawLayout();
    }

    private void initGridsOfVertices() {
        int size = this.vgraph.getGraph().getVerticesCount();
        this.gridsOfVertices = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.gridsOfVertices.add(null);
        }
    }

    private void layout(Vertex rootVertex, List children) {
        Grid newGrid;
        int numberOfChildren = children.size();
        if (numberOfChildren == 0) {
            ArrayList<VisualVertex> singleElementList = new ArrayList<VisualVertex>(10);
            VisualVertex rootVisualVertex = this.vgraph.getVisualVertex(rootVertex);
            singleElementList.add(rootVisualVertex);
            newGrid = new Grid(singleElementList, 1, 1);
            newGrid.setGridPoint(0, 0, rootVisualVertex);
            this.gridsOfVertices.set(this.vgraph.getVisualVertices().indexOf(rootVisualVertex), newGrid);
            this.verticesReadyForPositioning.add(rootVertex);
        } else {
            Grid childGrid = null;
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                VisualVertex vVertex = this.vgraph.getVisualVertex((Vertex)children.get(i));
                if (i == 0) {
                    childGrid = (Grid)this.gridsOfVertices.get(this.vgraph.getVisualVertices().indexOf(vVertex));
                }
                if (i <= 0) continue;
                childGrid.appendToRight((Grid)this.gridsOfVertices.get(this.vgraph.getVisualVertices().indexOf(vVertex)));
            }
            int childMinX = 0;
            int childMaxX = 0;
            for (int i = 0; i < size; ++i) {
                VisualVertex vVertex = this.vgraph.getVisualVertex((Vertex)children.get(i));
                Point vertexPoint = childGrid.findVisualVertex(vVertex);
                logCategory.debug((Object)("Position of " + vVertex + " : " + vertexPoint));
                if (i == 0) {
                    childMinX = vertexPoint.x;
                    childMaxX = vertexPoint.x;
                    continue;
                }
                childMinX = Math.min(childMinX, vertexPoint.x);
                childMaxX = Math.max(childMaxX, vertexPoint.x);
            }
            int childWidth = childMaxX - childMinX + 1;
            logCategory.debug((Object)("Child width of " + rootVertex + ": " + childWidth));
            if (childWidth % 2 == 0) {
                int insertedColumnX = childMinX + Math.round(childWidth / 2);
                logCategory.debug((Object)("Inserting blank column at " + insertedColumnX));
                childGrid.insertEmptyGrid(insertedColumnX);
                logCategory.debug((Object)"Adjusting grid");
                logCategory.debug((Object)childGrid);
                TreeGridAdjuster adjuster = new TreeGridAdjuster(this.vgraph, rootVertex, childGrid, insertedColumnX);
                adjuster.adjust();
                adjuster = null;
            }
            ArrayList<VisualVertex> singleElementList = new ArrayList<VisualVertex>(10);
            VisualVertex rootVisualVertex = this.vgraph.getVisualVertex(rootVertex);
            singleElementList.add(rootVisualVertex);
            newGrid = new Grid(singleElementList, childGrid.getWidth(), 1);
            newGrid.setGridPoint(childMinX + Math.round(childWidth / 2), 0, rootVisualVertex);
            newGrid.appendToBottom(childGrid);
            logCategory.debug((Object)("\tAppended children of " + rootVertex));
            logCategory.debug((Object)("\t\t" + newGrid.visualVertices));
            logCategory.debug((Object)("\t\t" + newGrid.gridPointAssignment));
            logCategory.debug((Object)("\t\t" + newGrid));
            this.gridsOfVertices.set(this.vgraph.getVisualVertices().indexOf(rootVisualVertex), newGrid);
            this.verticesReadyForPositioning.add(rootVertex);
        }
        this.grid = newGrid;
        Tree tree = (Tree)this.vgraph.getGraph();
        try {
            Vertex parent = tree.getParent(rootVertex);
            logCategory.debug((Object)"....Testing for Recursion...");
            if (parent != null) {
                List siblings = tree.getChildren(parent);
                siblings.remove(rootVertex);
                if (this.verticesReadyForPositioning.containsAll(siblings)) {
                    logCategory.debug((Object)"....Recursing...");
                    siblings.add(rootVertex);
                    this.layout(parent, siblings);
                    this.verticesReadyForPositioning.add(rootVertex);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public boolean visit(Vertex vertexToVisit) {
        Tree tree = (Tree)this.vgraph.getGraph();
        List siblings = new ArrayList();
        List children = null;
        logCategory.debug((Object)("Visiting " + vertexToVisit));
        try {
            Vertex parent = tree.getParent(vertexToVisit);
            if (parent != null) {
                siblings = tree.getChildren(parent);
            } else {
                siblings.clear();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        siblings.remove(vertexToVisit);
        try {
            children = tree.getChildren(vertexToVisit);
        }
        catch (GraphException ex) {
            ex.printStackTrace();
        }
        if (children.size() == 0) {
            logCategory.debug((Object)"Visiting leaf");
            this.layout(vertexToVisit, children);
        }
        return true;
    }

    public void routeEdge(Graphics2D g2d, VisualEdge vEdge) {
        VisualVertex visualVertexA = vEdge.getVisualVertexA();
        VisualVertex visualVertexB = vEdge.getVisualVertexB();
        GeneralPath drawPath = vEdge.getGeneralPath();
        Rectangle fromvertexBounds = visualVertexA.getBounds();
        Rectangle tovertexBounds = visualVertexB.getBounds();
        drawPath.reset();
        drawPath.moveTo((float)fromvertexBounds.getCenterX(), (float)fromvertexBounds.getCenterY());
        drawPath.lineTo((float)tovertexBounds.getCenterX(), (float)tovertexBounds.getCenterY());
    }

    public void addVertex(VisualVertex vVertex) {
    }

    public void removeEdge(VisualEdge vEdge) {
    }

    public void removeVertex(VisualVertex vVertex) {
    }

    public void addEdge(VisualEdge vEdge) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

