/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import salvo.jesus.graph.LabeledGraphComponent;
import salvo.jesus.graph.java.awt.geom.SerializablePathIterator;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.VisualGraphComponent;
import salvo.jesus.graph.visual.drawing.Painter;

public abstract class AbstractVisualGraphComponent
implements VisualGraphComponent {
    LabeledGraphComponent component;
    Color outlinecolor = Color.black;
    Color fillcolor = new Color(0, 255, 255);
    Font font = new Font("Lucida Sans", 0, 10);
    Color fontcolor = Color.black;
    transient GeneralPath drawpath;
    List mouseMotionListeners = new ArrayList(10);
    List mouseListeners = new ArrayList(10);
    Painter painter;
    VisualGraph visualGraph;
    transient FontMetrics fontMetrics = new Panel().getFontMetrics(this.getFont());

    public String getLabel() {
        return this.component.getLabel();
    }

    public Color getFillcolor() {
        return this.fillcolor;
    }

    public Color getOutlinecolor() {
        return this.outlinecolor;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public Color getFontcolor() {
        return this.fontcolor;
    }

    public GeneralPath getGeneralPath() {
        return this.drawpath;
    }

    public Painter getPainter() {
        return this.painter;
    }

    public VisualGraph getVisualGraph() {
        return this.visualGraph;
    }

    public void setFillcolor(Color fillcolor) {
        this.fillcolor = fillcolor;
    }

    public void setLabel(String text) {
        this.component.setLabel(text);
    }

    public void setOutlinecolor(Color outlinecolor) {
        this.outlinecolor = outlinecolor;
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontMetrics = new Panel().getFontMetrics(this.font);
    }

    public void setFontcolor(Color fontcolor) {
        this.fontcolor = fontcolor;
    }

    public void setGeneralPath(GeneralPath path) {
        this.drawpath = path;
        this.rescale();
    }

    public void setGeneralPath(PathIterator pathIterator) {
        GeneralPath newPath = new GeneralPath();
        newPath.append(pathIterator, true);
        this.setGeneralPath(newPath);
    }

    public void setPainter(Painter newPainter) {
        this.painter = newPainter;
    }

    public Rectangle getBounds() {
        return this.drawpath.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.drawpath.getBounds();
    }

    public void addMouseListener(MouseListener l) {
        this.mouseListeners.add(l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        this.mouseMotionListeners.add(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.mouseListeners.remove(l);
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        this.mouseMotionListeners.remove(l);
    }

    public void processMouseEvent(MouseEvent e) {
        int size = this.mouseListeners.size();
        for (int i = 0; i < size; ++i) {
            MouseListener listener = (MouseListener)this.mouseListeners.get(i);
            int id = e.getID();
            if (id == 500) {
                listener.mouseClicked(e);
                continue;
            }
            if (id == 501) {
                listener.mousePressed(e);
                continue;
            }
            if (id == 502) {
                listener.mouseReleased(e);
                continue;
            }
            if (id == 504) {
                listener.mouseEntered(e);
                continue;
            }
            if (id != 505) continue;
            listener.mouseExited(e);
        }
    }

    public void processMouseMotionEvent(MouseEvent e) {
        int size = this.mouseMotionListeners.size();
        for (int i = 0; i < size; ++i) {
            MouseMotionListener listener = (MouseMotionListener)this.mouseMotionListeners.get(i);
            int id = e.getID();
            if (id == 506) {
                listener.mouseDragged(e);
                continue;
            }
            if (id != 503) continue;
            listener.mouseMoved(e);
        }
    }

    public void processKeyEvent(KeyEvent e) {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializablePathIterator sIterator = new SerializablePathIterator(this.drawpath.getPathIterator(new AffineTransform()));
        out.writeObject(sIterator);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        SerializablePathIterator sIterator = (SerializablePathIterator)in.readObject();
        this.drawpath = new GeneralPath();
        this.drawpath.append(sIterator, false);
    }
}

