/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.Visualization.KeelToPMML;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.Visualization.KeelToPMML.MeasuresCalculator;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.Visualization.KeelToPMML.StringPair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class KeelToPMMLProcessor {
    private Document readedDocument = null;
    private HashMap<String, Integer> items = new HashMap();
    private HashMap<String, ArrayList<Integer>> itemsets = new HashMap();
    private ArrayList<ArrayList<Integer>> rules = new ArrayList();
    private ArrayList<ArrayList<StringPair>> rulesMeasures = new ArrayList();
    private HashMap<String, String> itemsetsSupport = new HashMap();
    private String itemNameValueSeparator;
    private String itemsetIdSeparator;
    private int itemCounter;
    private int itemsetCounter;

    public KeelToPMMLProcessor(String itemNVSep, String itemsetSep) {
        this.itemNameValueSeparator = itemNVSep;
        this.itemsetIdSeparator = itemsetSep;
    }

    private void resetProcessor() {
        this.itemsetsSupport.clear();
        this.rulesMeasures.clear();
        this.items.clear();
        this.itemsets.clear();
        this.rules.clear();
        this.itemCounter = 0;
        this.itemsetCounter = 0;
    }

    public void parseXmlFile(String traFile, String tstFile, String outName) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.resetProcessor();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.readedDocument = db.parse(tstFile);
            this.parseDocumentTst();
            this.readedDocument = db.parse(traFile);
            this.parseDocumentTra();
            this.items = KeelToPMMLProcessor.sortByValues(this.items);
            this.itemsets = KeelToPMMLProcessor.sortByValuesArray(this.itemsets);
            this.writeToFile(outName);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void parseDocumentTra() {
        Element docEle = this.readedDocument.getDocumentElement();
        NodeList rules = docEle.getElementsByTagName("rule");
        ArrayList itemsetAntecedents = new ArrayList();
        ArrayList itemsetConsequents = new ArrayList();
        if (rules != null && rules.getLength() > 0) {
            for (int i = 0; i < rules.getLength(); ++i) {
                Element rule = (Element)rules.item(i);
                itemsetAntecedents = this.processAntecedents(rule);
                itemsetConsequents = this.processConsequents(rule);
                this.processItemset(itemsetAntecedents, itemsetConsequents);
                this.processRule(itemsetAntecedents, itemsetConsequents);
            }
        }
    }

    private void parseDocumentTst() {
        Element docEle = this.readedDocument.getDocumentElement();
        NodeList rules = docEle.getElementsByTagName("rule");
        Double support = 0.0;
        Double confidence = 0.0;
        Double antSupport = 0.0;
        Double conSuport = 0.0;
        MeasuresCalculator mc = new MeasuresCalculator();
        ArrayList itemsetAntecedents = new ArrayList();
        ArrayList itemsetConsequents = new ArrayList();
        if (rules != null && rules.getLength() > 0) {
            for (int i = 0; i < rules.getLength(); ++i) {
                Element rule = (Element)rules.item(i);
                this.rulesMeasures.add(new ArrayList());
                support = this.processMeasure(rule, "rule_support", "support");
                antSupport = this.processMeasure(rule, "antecedent_support", "antecedent_support");
                conSuport = this.processMeasure(rule, "consequent_support", "consequent_support");
                this.putMeasure("lift", mc.calculateLift(antSupport, conSuport, support));
                this.putMeasure("confidence", mc.calculateConfidence(antSupport, conSuport, support));
                this.putMeasure("certainFactor", mc.calculateCF(antSupport, conSuport, support));
                this.putMeasure("conviction", mc.calculateConviction(antSupport, conSuport, support));
            }
        }
    }

    private ArrayList processAntecedents(Element rule) {
        Element antecedent;
        NodeList attributes;
        NodeList antecedents = rule.getElementsByTagName("antecedents");
        ArrayList<String> itemset = new ArrayList<String>();
        if (antecedents != null && antecedents.getLength() > 0 && (attributes = (antecedent = (Element)antecedents.item(0)).getElementsByTagName("attribute")) != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Element attr = (Element)attributes.item(i);
                String itemId = attr.getAttribute("name") + this.itemNameValueSeparator + attr.getAttribute("value");
                if (!this.items.containsKey(itemId)) {
                    this.items.put(itemId, this.itemCounter);
                    ++this.itemCounter;
                }
                itemset.add(itemId);
            }
        }
        return itemset;
    }

    private ArrayList processConsequents(Element rule) {
        Element antecedent;
        NodeList attributes;
        NodeList antecedents = rule.getElementsByTagName("consequents");
        ArrayList<String> itemset = new ArrayList<String>();
        if (antecedents != null && antecedents.getLength() > 0 && (attributes = (antecedent = (Element)antecedents.item(0)).getElementsByTagName("attribute")) != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Element attr = (Element)attributes.item(i);
                String itemId = attr.getAttribute("name") + this.itemNameValueSeparator + attr.getAttribute("value");
                if (!this.items.containsKey(itemId)) {
                    this.items.put(itemId, this.itemCounter);
                    ++this.itemCounter;
                }
                itemset.add(itemId);
            }
        }
        return itemset;
    }

    private void processItemset(ArrayList<String> ant, ArrayList<String> con) {
        ArrayList concatAC;
        ArrayList<Integer> ids;
        String itemsetId = "";
        itemsetId = this.join(ant, this.itemsetIdSeparator);
        if (!this.itemsets.containsKey(itemsetId)) {
            ids = new ArrayList<Integer>();
            ids.add(this.itemsetCounter);
            for (String i : ant) {
                ids.add(this.items.get(i));
            }
            this.itemsets.put(itemsetId, ids);
            ++this.itemsetCounter;
        }
        if (!this.itemsets.containsKey(itemsetId = this.join(con, this.itemsetIdSeparator))) {
            ids = new ArrayList();
            ids.add(this.itemsetCounter);
            for (String i : con) {
                ids.add(this.items.get(i));
            }
            this.itemsets.put(itemsetId, ids);
            ++this.itemsetCounter;
        }
        if (!this.itemsets.containsKey(itemsetId = this.join(concatAC = this.concat(ant, con), this.itemsetIdSeparator))) {
            ArrayList<Integer> ids2 = new ArrayList<Integer>();
            ids2.add(this.itemsetCounter);
            for (String i : concatAC) {
                ids2.add(this.items.get(i));
            }
            this.itemsets.put(itemsetId, ids2);
            ++this.itemsetCounter;
        }
    }

    private void processRule(ArrayList<String> ant, ArrayList<String> con) {
        String antecedentsId = this.join(ant, this.itemsetIdSeparator);
        String consequentsId = this.join(con, this.itemsetIdSeparator);
        ArrayList concatAC = this.concat(ant, con);
        String totalItemsetId = this.join(concatAC, this.itemsetIdSeparator);
        this.rules.add(new ArrayList());
        this.rules.get(this.rules.size() - 1).add(this.itemsets.get(antecedentsId).get(0));
        this.rules.get(this.rules.size() - 1).add(this.itemsets.get(consequentsId).get(0));
        this.itemsetsSupport.put(antecedentsId, this.rulesMeasures.get(this.rules.size() - 1).get(2).getValue());
        this.itemsetsSupport.put(consequentsId, this.rulesMeasures.get(this.rules.size() - 1).get(3).getValue());
        this.itemsetsSupport.put(totalItemsetId, this.rulesMeasures.get(this.rules.size() - 1).get(0).getValue());
    }

    private Double processMeasure(Element rule, String measureName, String beautifulName) {
        String measureValue = rule.getAttribute(measureName);
        this.rulesMeasures.get(this.rulesMeasures.size() - 1).add(new StringPair(beautifulName, measureValue));
        return Double.parseDouble(measureValue);
    }

    private void putMeasure(String measureName, Double measureValue) {
        this.rulesMeasures.get(this.rulesMeasures.size() - 1).add(new StringPair(measureName, measureValue.toString()));
    }

    /*
     * WARNING - void declaration
     */
    private void writeToFile(String outName) throws FileNotFoundException, UnsupportedEncodingException {
        String key;
        String minSupport = this.itemsetsSupport.get(this.findSmallerValue(this.itemsetsSupport));
        String minConfidence = this.findMinConfidence();
        PrintWriter writer = new PrintWriter(outName, "UTF-8");
        writer.println("<PMML xmlns=\"http://www.dmg.org/PMML-4_1\" version=\"4.1\">\n  <Header copyright=\"www.dmg.org\" description=\"Undefined\"/>\n  <AssociationModel functionName=\"associationRules\" numberOfTransactions=\"Undefined\" numberOfItems=\"" + this.items.size() + "\" minimumSupport=\"" + minSupport + "\" minimumConfidence=\"" + minConfidence + "\" numberOfItemsets=\"" + this.itemsets.size() + "\" numberOfRules=\"" + this.rules.size() + "\">\n" + "");
        writer.println("\n\n<!-- Items -->");
        for (Map.Entry<String, Integer> entry : this.items.entrySet()) {
            key = entry.getKey();
            Integer id = entry.getValue();
            writer.println("<Item id=\"" + id + "\" value=\"" + key + "\"/>");
        }
        writer.println("\n\n<!-- Itemsets -->");
        for (Map.Entry<String, Serializable> entry : this.itemsets.entrySet()) {
            key = entry.getKey();
            ArrayList ids = (ArrayList)entry.getValue();
            String support = this.itemsetsSupport.get(key);
            int n = ids.size() - 1;
            writer.println("<Itemset id=\"" + ids.get(0) + "\" support=\"" + support + "\" numberOfItems=\"" + n + "\">");
            for (int i = 1; i < ids.size(); ++i) {
                Integer id = (Integer)ids.get(i);
                writer.println("<ItemRef itemRef=\"" + id + "\"/>");
            }
            writer.println("</Itemset>");
        }
        writer.println("\n\n<!-- Assotiation Rules -->");
        for (int i = 0; i < this.rules.size(); ++i) {
            void var6_12;
            String string = "";
            for (StringPair measure : this.rulesMeasures.get(i)) {
                String string2 = (String)var6_12 + measure.getKey() + "=" + '\"' + measure.getValue() + "\" ";
            }
            writer.println("<AssociationRule id=\"" + i + "\" " + (String)var6_12 + " antecedent=\"" + this.rules.get(i).get(0) + "\" consequent=\"" + this.rules.get(i).get(1) + "\"/>");
        }
        writer.println("</AssociationModel>\n</PMML>");
        writer.flush();
        writer.close();
    }

    private String join(ArrayList<String> in, String separator) {
        String out = "";
        for (String i : in) {
            out = out + i + separator;
        }
        return out;
    }

    private ArrayList concat(ArrayList<String> a, ArrayList<String> b) {
        ArrayList<String> out = new ArrayList<String>();
        for (String i : a) {
            out.add(i);
        }
        for (String i : b) {
            out.add(i);
        }
        return out;
    }

    private static HashMap sortByValues(HashMap map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
            }
        });
        LinkedHashMap sortedHashMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedHashMap.put(entry.getKey(), entry.getValue());
        }
        return sortedHashMap;
    }

    private static HashMap sortByValuesArray(HashMap map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                ArrayList a1 = (ArrayList)((Map.Entry)o1).getValue();
                ArrayList a2 = (ArrayList)((Map.Entry)o2).getValue();
                return ((Comparable)a1.get(0)).compareTo(a2.get(0));
            }
        });
        LinkedHashMap sortedHashMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedHashMap.put(entry.getKey(), entry.getValue());
        }
        return sortedHashMap;
    }

    private String findSmallerValue(HashMap<String, String> map) {
        double valueNumber = Double.MAX_VALUE;
        String smallerElement = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == "" || !(Double.parseDouble(value) < valueNumber)) continue;
            smallerElement = key;
            valueNumber = Double.parseDouble(value);
        }
        return smallerElement;
    }

    private String findMinConfidence() {
        Double smallerConf = Double.MAX_VALUE;
        for (int i = 0; i < this.rulesMeasures.size(); ++i) {
            double act = Double.parseDouble(this.rulesMeasures.get(i).get(1).getValue());
            if (!(act < smallerConf)) continue;
            smallerConf = act;
        }
        return smallerConf.toString();
    }
}

