/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.GMCA;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.GMCA.Cluster;
import keel.Algorithms.Instance_Generation.GMCA.ClusterSet;
import keel.Algorithms.Instance_Generation.MCA.MCAGenerator;
import keel.Algorithms.Instance_Generation.utilities.Debug;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class GMCAGenerator
extends MCAGenerator {
    ClusterSet clusters;
    PrototypeSet R = null;

    public GMCAGenerator(PrototypeSet _trainingDataSet) {
        super(_trainingDataSet);
        this.algorithmName = "GMCA";
    }

    public GMCAGenerator(PrototypeSet _trainingDataSet, Parameters parameters) {
        super(_trainingDataSet, parameters);
        this.algorithmName = "GMCA";
    }

    protected void initClusters(PrototypeSet T) {
        this.R = new PrototypeSet();
        this.clusters = new ClusterSet();
        ArrayList<Double> classes = T.nonVoidClasses();
        for (double k : classes) {
            PrototypeSet Tk = T.getFromClass(k);
            Tk.randomize();
            while (Tk.size() > 0) {
                int neighbors = 2;
                if (Tk.size() == 3) {
                    neighbors = 3;
                }
                PrototypeSet clusterSet = KNN.getNearestNeighbors((Prototype)Tk.get(0), Tk, neighbors);
                clusterSet.add(Tk.get(0));
                Cluster newCluster = new Cluster(clusterSet);
                this.clusters.add(newCluster);
                this.R.add(newCluster.getRepresentative());
                for (Prototype p : clusterSet) {
                    Tk.remove(p);
                }
            }
        }
    }

    protected boolean isPrototypeConsistent(PrototypeSet modified) {
        int accuracyWithPStar = GMCAGenerator.absoluteAccuracy(modified, this.trainingDataSet);
        boolean foundBetter = (double)accuracyWithPStar >= this.currentAccuracy;
        return foundBetter;
    }

    protected static double d(Prototype a, Prototype b) {
        return Distance.d(a, b);
    }

    protected boolean isConsistent(Cluster mix, PrototypeSet modified) {
        boolean merge = true;
        ArrayList<Double> classes = modified.nonVoidClasses();
        Prototype pStar = mix.getRepresentative();
        PrototypeSet setStar = mix.getPrototypeSet();
        double kStar = pStar.label();
        double rStar = mix.getRadiusLength();
        HashMap<Double, Prototype> sK = new HashMap<Double, Prototype>();
        for (double k : classes) {
            Prototype p = modified.nearestToWithClass(pStar, k);
            sK.put(k, p);
        }
        for (double k : classes) {
            if (k == kStar) continue;
            double maxRadius = this.clusters.maxRadiusLengthOfClass(k);
            if (!(GMCAGenerator.d(pStar, (Prototype)sK.get(k)) <= 2.0 * Math.max(rStar, maxRadius))) continue;
            PrototypeSet Pk = modified.getFromClass(k);
            for (Prototype s : Pk) {
                Cluster clusterOfs = this.clusters.get(s);
                PrototypeSet setOfs = clusterOfs.getPrototypeSet();
                double rs = clusterOfs.getRadiusLength();
                if (!(GMCAGenerator.d(pStar, s) <= 2.0 * Math.max(rStar, rs))) continue;
                ArrayList<Pair<Prototype, Prototype>> setStarMoves = new ArrayList<Pair<Prototype, Prototype>>();
                for (Prototype x : setStar) {
                    if (!(GMCAGenerator.d(pStar, x) >= GMCAGenerator.d(s, x))) continue;
                    Prototype nx = setStar.nearestTo(x);
                    if (GMCAGenerator.d(nx, x) < GMCAGenerator.d(s, x)) {
                        setStarMoves.add(new Pair<Prototype, Prototype>(x, nx));
                        continue;
                    }
                    merge = false;
                    return false;
                }
                ArrayList<Pair<Prototype, Prototype>> setOfsMoves = new ArrayList<Pair<Prototype, Prototype>>();
                for (Prototype y : setOfs) {
                    if (!(GMCAGenerator.d(pStar, y) <= GMCAGenerator.d(s, y))) continue;
                    Prototype prototype = Pk.nearestTo(y);
                    if (GMCAGenerator.d(prototype, y) < GMCAGenerator.d(pStar, y)) {
                        setOfsMoves.add(new Pair<Prototype, Prototype>(y, prototype));
                        continue;
                    }
                    merge = false;
                    return false;
                }
                ArrayList<Prototype> movedX = new ArrayList<Prototype>();
                for (Pair pair : setStarMoves) {
                    Prototype prototype = (Prototype)pair.first();
                    if (movedX.contains(prototype)) continue;
                    movedX.add(prototype);
                    Prototype nx = (Prototype)pair.second();
                    this.clusters.moveTo(prototype, this.clusters.getClusterOf(nx));
                }
                ArrayList<Prototype> movedY = new ArrayList<Prototype>();
                for (Pair pair : setOfsMoves) {
                    Prototype y = (Prototype)pair.first();
                    if (movedY.contains(y)) continue;
                    movedY.add(y);
                    Prototype ny = (Prototype)pair.second();
                    this.clusters.moveTo(y, this.clusters.getClusterOf(ny));
                }
            }
        }
        return true;
    }

    @Override
    public PrototypeSet reduceSet() {
        int count = 0;
        int counterOfMerges = 0;
        PrototypeSet V = this.trainingDataSet.copy();
        int numClasses = V.nonVoidClasses().size();
        this.initClusters(V);
        Random r = new Random();
        r.setSeed(SEED);
        this.currentAccuracy = GMCAGenerator.absoluteAccuracy(V, this.trainingDataSet);
        do {
            counterOfMerges = 0;
            ArrayList<Pair<Cluster, Cluster>> nearest = this.clusters.nearestClustersWithSameClass();
            int nearestSize = nearest.size();
            boolean foundBetter = false;
            for (int i = 0; !foundBetter && i < nearestSize; ++i) {
                this.clusters.test(V);
                Cluster Cp = nearest.get(i).first();
                Cluster Cq = nearest.get(i).second();
                Prototype p = Cp.getRepresentative();
                Prototype q = Cq.getRepresentative();
                Cluster mix = this.clusters.merge(Cp, Cq);
                PrototypeSet modified = new PrototypeSet(V);
                modified.remove(p);
                modified.remove(q);
                foundBetter = this.isConsistent(mix, modified);
                if (!foundBetter) continue;
                Prototype avg = mix.getRepresentative();
                this.clusters.assignment.put(avg, mix);
                ++count;
                this.R.remove(p);
                this.R.remove(q);
                this.R.add(avg);
                ++counterOfMerges;
                if (this.clusters.size() != numClasses) continue;
                counterOfMerges = 0;
            }
        } while (counterOfMerges > 0);
        return this.R;
    }

    public static void main(String[] args) {
        Debug.setStdDebugMode(false);
        Parameters.setUse("GMCA", "<seed>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        GMCAGenerator.setSeed(seed);
        GMCAGenerator generator = new GMCAGenerator(training);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy1NN(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

