/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.M5Rules;

import keel.Dataset.Attributes;

public class SimpleRule {
    public static int GREATER = 0;
    public static int LOWER = 1;
    public static int EQUAL = 2;
    private int attribute;
    private int operator;
    private double value;

    public SimpleRule() {
    }

    public SimpleRule(int attribute, double value, int operator) {
        this.attribute = attribute;
        this.value = value;
        this.operator = operator;
    }

    public int getAttribute() {
        return this.attribute;
    }

    public double getValue() {
        return this.value;
    }

    public int getOperator() {
        return this.operator;
    }

    public boolean isDiscret() {
        return this.operator == EQUAL;
    }

    public boolean isContinous() {
        return this.operator != EQUAL;
    }

    public void set(int attribute, double value, int operator) {
        this.attribute = attribute;
        this.value = value;
        this.operator = operator;
    }

    public void setAttribute(int attribute) {
        this.attribute = attribute;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public boolean isEqual(SimpleRule sr) {
        return this.attribute == sr.attribute && this.operator == sr.operator && this.value == sr.value;
    }

    public SimpleRule getCopy() {
        return new SimpleRule(this.attribute, this.value, this.operator);
    }

    public String toString() {
        String V = "";
        V = V + this.value;
        String operator_string = "<undef>";
        if (this.operator == GREATER) {
            operator_string = ">";
        }
        if (this.operator == LOWER) {
            operator_string = "<=";
        }
        if (this.operator == EQUAL) {
            operator_string = "=";
            V = Attributes.getAttribute(this.attribute).getNominalValue((int)this.value);
        }
        return "" + Attributes.getAttribute(this.attribute).getName() + operator_string + V;
    }
}

