/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.PreadjustmentVariable;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.TsVariableDescriptor;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.IModelBuilder;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreadjustmentType;
import ec.tstoolkit.modelling.arima.x13.ArimaSpec;
import ec.tstoolkit.modelling.arima.x13.MovingHolidaySpec;
import ec.tstoolkit.modelling.arima.x13.RegArimaSpecification;
import ec.tstoolkit.modelling.arima.x13.RegressionSpec;
import ec.tstoolkit.modelling.arima.x13.TradingDaysSpec;
import ec.tstoolkit.modelling.arima.x13.TransformSpec;
import ec.tstoolkit.modelling.arima.x13.X13Exception;
import ec.tstoolkit.sarima.SarimaComponent;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.AbstractSingleTsVariable;
import ec.tstoolkit.timeseries.regression.AbstractTsVariableBox;
import ec.tstoolkit.timeseries.regression.DecoratedTsVariable;
import ec.tstoolkit.timeseries.regression.EasterVariable;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.regression.ICalendarVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.InterventionVariable;
import ec.tstoolkit.timeseries.regression.JulianEasterVariable;
import ec.tstoolkit.timeseries.regression.LeapYearVariable;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import ec.tstoolkit.timeseries.regression.OutliersFactory;
import ec.tstoolkit.timeseries.regression.Ramp;
import ec.tstoolkit.timeseries.regression.StockTradingDaysVariables;
import ec.tstoolkit.timeseries.regression.TsVariableGroup;
import java.util.ArrayList;
import java.util.Map;

public class X13ModelBuilder
implements IModelBuilder {
    private final RegArimaSpecification spec_;
    private final ProcessingContext context_;

    public X13ModelBuilder(RegArimaSpecification spec) {
        this.spec_ = spec;
        this.context_ = ProcessingContext.getActiveContext();
    }

    public X13ModelBuilder(RegArimaSpecification spec, ProcessingContext context) {
        this.spec_ = spec;
        this.context_ = context != null ? context : ProcessingContext.getActiveContext();
    }

    private void initializeArima(ModelDescription model) {
        if (this.spec_.isUsingAutoModel()) {
            model.setAirline(true);
        } else if (this.spec_.getArima() == null) {
            model.setAirline(true);
        } else {
            ArimaSpec arima = this.spec_.getArima();
            SarimaComponent cmp = new SarimaComponent();
            cmp.setFrequency(model.getFrequency());
            cmp.setMu(arima.getMu());
            cmp.setPhi(arima.getPhi());
            cmp.setTheta(arima.getTheta());
            cmp.setD(arima.getD());
            cmp.setBPhi(arima.getBPhi());
            cmp.setBTheta(arima.getBTheta());
            cmp.setBD(arima.getBD());
            model.setArimaComponent(cmp);
        }
    }

    private void initializeVariables(ModelDescription model, RegressionSpec regSpec) {
        if (regSpec == null) {
            return;
        }
        Map<String, double[]> preadjustment = regSpec.getAllFixedCoefficients();
        if (regSpec.getTradingDays().isUsed()) {
            this.initializeTradingDays(model, regSpec.getTradingDays(), preadjustment);
        }
        if (regSpec.getMovingHolidays() != null) {
            this.initializeMovingHolidays(model, regSpec.getMovingHolidays(), preadjustment);
        }
        if (regSpec.getOutliersCount() > 0) {
            this.initializeOutliers(model, regSpec.getOutliers(), preadjustment);
        }
        if (regSpec.getUserDefinedVariablesCount() > 0) {
            this.initializeUsers(model, regSpec.getUserDefinedVariables(), preadjustment);
        }
        if (regSpec.getInterventionVariablesCount() > 0) {
            this.initializeInterventions(model, regSpec.getInterventionVariables(), preadjustment);
        }
        if (regSpec.getRampsCount() > 0) {
            this.initializeRamps(model, regSpec.getRamps(), preadjustment);
        }
    }

    @Override
    public boolean initialize(ModellingContext context) {
        this.initializeTransformation(context.description, this.spec_.getTransform());
        this.initializeArima(context.description);
        this.initializeVariables(context.description, this.spec_.getRegression());
        return true;
    }

    private void initializeTransformation(ModelDescription model, TransformSpec fnSpec) {
        if (fnSpec == null) {
            return;
        }
        PreadjustmentType type = PreadjustmentType.None;
        if (fnSpec.getFunction() != DefaultTransformationType.Auto) {
            if (fnSpec.getAdjust() == LengthOfPeriodType.LeapYear) {
                type = PreadjustmentType.LeapYear;
            }
            if (fnSpec.getAdjust() == LengthOfPeriodType.LengthOfPeriod) {
                type = PreadjustmentType.LengthOfPeriod;
            }
        }
        model.setTransformation(fnSpec.getFunction(), type);
    }

    private void initializeTradingDays(ModelDescription model, TradingDaysSpec tradingDays, Map<String, double[]> preadjustment) {
        if (tradingDays.isStockTradingDays()) {
            this.initializeStockTradingDays(model, tradingDays, preadjustment);
        }
        if (tradingDays.getHolidays() != null) {
            this.initializeHolidays(model, tradingDays, preadjustment);
        } else if (tradingDays.getUserVariables() != null) {
            this.initializeUserHolidays(model, tradingDays, preadjustment);
        } else {
            this.initializeDefaultTradingDays(model, tradingDays, preadjustment);
        }
    }

    private void initializeMovingHolidays(ModelDescription model, MovingHolidaySpec[] mh, Map<String, double[]> preadjustment) {
        for (int i = 0; i < mh.length; ++i) {
            Variable tvar;
            PreadjustmentVariable pvar;
            String sname;
            AbstractSingleTsVariable var;
            if (mh[i].getType() == MovingHolidaySpec.Type.Easter) {
                var = new EasterVariable();
                ((EasterVariable)var).setType(EasterVariable.Correction.PreComputed);
                ((EasterVariable)var).setDuration(mh[i].getW());
                sname = ITsVariable.shortName(var.getName());
                if (preadjustment.containsKey(sname)) {
                    pvar = PreadjustmentVariable.movingHolidayVariable((IMovingHolidayVariable)((Object)var), preadjustment.get(sname));
                    model.addPreadjustment(pvar);
                    continue;
                }
                tvar = Variable.movingHolidayVariable((IMovingHolidayVariable)((Object)var), RegStatus.Undefined);
                if (null != mh[i].getTest()) {
                    switch (mh[i].getTest()) {
                        case Add: {
                            tvar.status = RegStatus.ToAdd;
                            break;
                        }
                        case Remove: {
                            tvar.status = RegStatus.ToRemove;
                            break;
                        }
                        default: {
                            tvar.status = RegStatus.Prespecified;
                        }
                    }
                }
                model.addVariable(tvar);
                continue;
            }
            if (mh[i].getType() != MovingHolidaySpec.Type.JulianEaster) continue;
            var = new JulianEasterVariable();
            ((JulianEasterVariable)var).setDuration(mh[i].getW());
            sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                pvar = PreadjustmentVariable.movingHolidayVariable((IMovingHolidayVariable)((Object)var), preadjustment.get(sname));
                model.addPreadjustment(pvar);
                continue;
            }
            tvar = Variable.movingHolidayVariable((IMovingHolidayVariable)((Object)var), RegStatus.Undefined);
            if (null != mh[i].getTest()) {
                switch (mh[i].getTest()) {
                    case Add: {
                        tvar.status = RegStatus.ToAdd;
                        break;
                    }
                    case Remove: {
                        tvar.status = RegStatus.ToRemove;
                        break;
                    }
                    default: {
                        tvar.status = RegStatus.Prespecified;
                    }
                }
            }
            model.addVariable(tvar);
        }
    }

    private void initializeOutliers(ModelDescription model, OutlierDefinition[] outliers, Map<String, double[]> preadjustment) {
        ArrayList<IOutlierVariable> pvar = new ArrayList<IOutlierVariable>();
        OutliersFactory fac = this.spec_.getOutliersFactory();
        for (int i = 0; i < outliers.length; ++i) {
            IOutlierVariable v = fac.make(outliers[i]);
            String sname = ITsVariable.shortName(v.getName());
            if (preadjustment.containsKey(sname)) {
                PreadjustmentVariable pv = PreadjustmentVariable.outlier(v, preadjustment.get(sname));
                model.addPreadjustment(pv);
                continue;
            }
            pvar.add(v);
        }
        model.addPrespecifiedOutliers(pvar);
    }

    private void initializeUsers(ModelDescription model, TsVariableDescriptor[] uvars, Map<String, double[]> preadjustment) {
        if (uvars == null) {
            return;
        }
        for (int i = 0; i < uvars.length; ++i) {
            ITsVariable var = uvars[i].toTsVariable(this.context_);
            String sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                PreadjustmentVariable pv = PreadjustmentVariable.userVariable(var, uvars[i].getEffect().type(), preadjustment.get(sname));
                model.addPreadjustment(pv);
                continue;
            }
            Variable uvar = Variable.userVariable(var, uvars[i].getEffect().type(), RegStatus.Prespecified);
            model.addVariable(uvar);
        }
    }

    private void initializeInterventions(ModelDescription model, InterventionVariable[] interventionVariables, Map<String, double[]> preadjustment) {
        if (interventionVariables == null) {
            return;
        }
        for (int i = 0; i < interventionVariables.length; ++i) {
            InterventionVariable var = interventionVariables[i];
            String sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                PreadjustmentVariable pv = PreadjustmentVariable.userVariable(var, Variable.searchType(var), preadjustment.get(sname));
                model.addPreadjustment(pv);
                continue;
            }
            Variable uvar = Variable.userVariable(var, Variable.searchType(var), RegStatus.Prespecified);
            model.addVariable(uvar);
        }
    }

    private void initializeRamps(ModelDescription model, Ramp[] ramps, Map<String, double[]> preadjustment) {
        if (ramps == null) {
            return;
        }
        for (int i = 0; i < ramps.length; ++i) {
            Ramp var = ramps[i];
            String sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                PreadjustmentVariable pv = PreadjustmentVariable.userVariable(var, ComponentType.Trend, preadjustment.get(sname));
                model.addPreadjustment(pv);
                continue;
            }
            Variable uvar = Variable.userVariable(var, ComponentType.Trend, RegStatus.Prespecified);
            model.addVariable(uvar);
        }
    }

    private void initializeHolidays(ModelDescription model, TradingDaysSpec td, Map<String, double[]> preadjustment) {
        Variable tvar;
        PreadjustmentVariable pvar;
        String sname;
        ICalendarVariable var;
        IGregorianCalendarProvider cal = (IGregorianCalendarProvider)this.context_.getGregorianCalendars().get(td.getHolidays());
        if (cal == null) {
            return;
        }
        TradingDaysType ttd = td.getTradingDaysType();
        LengthOfPeriodType tlp = td.getLengthOfPeriod();
        boolean auto = td.isAutoAdjust();
        if (ttd != TradingDaysType.None) {
            var = new GregorianCalendarVariables(cal, ttd);
            sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                pvar = PreadjustmentVariable.calendarVariable(var, preadjustment.get(sname));
                model.addPreadjustment(pvar);
            } else {
                tvar = Variable.calendarVariable(var, RegStatus.Undefined);
                if (null != td.getTest()) {
                    switch (td.getTest()) {
                        case Add: {
                            tvar.status = RegStatus.ToAdd;
                            break;
                        }
                        case Remove: {
                            tvar.status = RegStatus.ToRemove;
                            break;
                        }
                        default: {
                            tvar.status = RegStatus.Prespecified;
                        }
                    }
                }
                model.addVariable(tvar);
            }
        }
        if (tlp != LengthOfPeriodType.None) {
            var = new LeapYearVariable(tlp);
            sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                pvar = PreadjustmentVariable.calendarVariable(var, preadjustment.get(sname));
                model.addPreadjustment(pvar);
            } else {
                tvar = Variable.calendarVariable(var, RegStatus.Undefined);
                if (null != td.getTest()) {
                    switch (td.getTest()) {
                        case Add: {
                            tvar.status = RegStatus.ToAdd;
                            break;
                        }
                        case Remove: {
                            tvar.status = RegStatus.ToRemove;
                            break;
                        }
                        default: {
                            tvar.status = RegStatus.Prespecified;
                        }
                    }
                }
                model.addVariable(tvar);
            }
        }
        if (auto) {
            model.setTransformation(PreadjustmentType.Auto);
        }
    }

    private void initializeUserHolidays(ModelDescription model, TradingDaysSpec td, Map<String, double[]> preadjustment) {
        String[] userVariables = td.getUserVariables();
        if (userVariables == null || userVariables.length == 0) {
            return;
        }
        ArrayList<ITsVariable> nonUserFixedVariables = new ArrayList<ITsVariable>();
        for (int i = 0; i < userVariables.length; ++i) {
            userVariables[i] = userVariables[i].replace("td|", "");
            String userVariableName = "td|".concat(userVariables[i]);
            ITsVariable var = this.context_.getTsVariable(userVariables[i]);
            if (var == null) {
                throw new X13Exception(userVariables[i] + " not found");
            }
            if (preadjustment.containsKey(ITsVariable.validName(userVariableName))) {
                userVariables[i] = userVariableName;
                DecoratedTsVariable temp = new DecoratedTsVariable(var, userVariableName);
                PreadjustmentVariable pvar = PreadjustmentVariable.tdVariable(temp, preadjustment.get(ITsVariable.validName(userVariables[i])));
                model.addPreadjustment(pvar);
                continue;
            }
            nonUserFixedVariables.add(var);
        }
        if (!nonUserFixedVariables.isEmpty()) {
            TsVariableGroup var = new TsVariableGroup("User-defined calendar variables", nonUserFixedVariables.toArray(new ITsVariable[nonUserFixedVariables.size()]));
            var.setName("usertd");
            if (preadjustment.containsKey("td")) {
                ITradingDaysVariable tdvar_fixed = AbstractTsVariableBox.tradingDays(var);
                PreadjustmentVariable pv_td = PreadjustmentVariable.tdVariable(tdvar_fixed, preadjustment.get("td"));
                model.addPreadjustment(pv_td);
            } else {
                Variable tvar = Variable.tdVariable(var, RegStatus.Undefined);
                switch (td.getTest()) {
                    case Add: {
                        tvar.status = RegStatus.ToAdd;
                        break;
                    }
                    case Remove: {
                        tvar.status = RegStatus.ToRemove;
                        break;
                    }
                    default: {
                        tvar.status = RegStatus.Prespecified;
                    }
                }
                model.addVariable(tvar);
            }
        }
    }

    private void initializeDefaultTradingDays(ModelDescription model, TradingDaysSpec td, Map<String, double[]> preadjustment) {
        Variable tvar;
        PreadjustmentVariable pvar;
        String sname;
        ICalendarVariable var;
        TradingDaysType ttd = td.getTradingDaysType();
        LengthOfPeriodType tlp = td.getLengthOfPeriod();
        boolean auto = td.isAutoAdjust();
        if (ttd != TradingDaysType.None) {
            var = GregorianCalendarVariables.getDefault(ttd);
            sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                pvar = PreadjustmentVariable.calendarVariable(var, preadjustment.get(sname));
                model.addPreadjustment(pvar);
            } else {
                tvar = Variable.calendarVariable(var, RegStatus.Undefined);
                if (null != td.getTest()) {
                    switch (td.getTest()) {
                        case Add: {
                            tvar.status = RegStatus.ToAdd;
                            break;
                        }
                        case Remove: {
                            tvar.status = RegStatus.ToRemove;
                            break;
                        }
                        default: {
                            tvar.status = RegStatus.Prespecified;
                        }
                    }
                }
                model.addVariable(tvar);
            }
        }
        if (tlp != LengthOfPeriodType.None) {
            var = new LeapYearVariable(tlp);
            sname = ITsVariable.shortName(var.getName());
            if (preadjustment.containsKey(sname)) {
                pvar = PreadjustmentVariable.calendarVariable(var, preadjustment.get(sname));
                model.addPreadjustment(pvar);
            } else {
                tvar = Variable.calendarVariable(var, RegStatus.Undefined);
                if (null != td.getTest()) {
                    switch (td.getTest()) {
                        case Add: {
                            tvar.status = RegStatus.ToAdd;
                            break;
                        }
                        case Remove: {
                            tvar.status = RegStatus.ToRemove;
                            break;
                        }
                        default: {
                            tvar.status = RegStatus.Prespecified;
                        }
                    }
                }
                model.addVariable(tvar);
            }
        }
        if (auto) {
            model.setTransformation(PreadjustmentType.Auto);
        }
    }

    private void initializeStockTradingDays(ModelDescription model, TradingDaysSpec td, Map<String, double[]> preadjustment) {
        StockTradingDaysVariables var = new StockTradingDaysVariables(td.getStockTradingDays());
        String sname = ITsVariable.shortName(var.getName());
        if (preadjustment.containsKey(sname)) {
            PreadjustmentVariable pvar = PreadjustmentVariable.calendarVariable(var, preadjustment.get(sname));
            model.addPreadjustment(pvar);
        } else {
            Variable tvar = Variable.calendarVariable(var, RegStatus.Undefined);
            switch (td.getTest()) {
                case Add: {
                    tvar.status = RegStatus.ToAdd;
                    break;
                }
                case Remove: {
                    tvar.status = RegStatus.ToRemove;
                    break;
                }
                default: {
                    tvar.status = RegStatus.Prespecified;
                }
            }
            model.addVariable(tvar);
        }
    }
}

