library(JointNets)

graphics.off()
par(ask = FALSE)
par(mfrow = c(1, 1))


readline(prompt = "Press [enter] to continue to cancer demo with 2 tasks (not v. pcr) and 26 features (26 cancer types) ")

data(cancer)
cancerlist = list(as.matrix(cancer[[1]][which(cancer[[2]] == "not"), ]),
                  as.matrix(cancer[[1]][which(cancer[[2]] == "pcr"), ]))
result = diffee(cancerlist[[1]], cancerlist[[2]], 40)
label = colnames(cancer[[1]])
graph = returngraph(result)
layout = layout_nicely(graph, dim = 2)

readline(prompt = "Press [enter] to view the difference graph generated by diffee")

{
  par(mfrow = c(1, 2))
  plot(result, layout = layout)
  nodeid = which(label %in% c("BECNI", "FLJI2650"))
  plot(result,
       type = "neighbour",
       index = nodeid,
       layout = layout)
}

readline(prompt = "Press [enter] to continue to NIPS word count demo with 2 tasks (before 2006 and after 2006) and 37 features (37 words)")


data(nip_37_data)
label = colnames(nip_37_data[[1]])
result = diffee(nip_37_data[[1]], nip_37_data[[2]] , 0.0035)
graph = returngraph(result)
layout = layout_nicely(graph, dim = 2)

readline(prompt = "Press [enter] to view the difference graph")

{
  par(mfrow = c(1, 2))
  plot(result, layout = layout)
  nodeid = which(label %in% c("results", "section")) ### look for id
  plot(result,
       type = "neighbour",
       index = nodeid,
       layout = layout)
}



readline(prompt = "Press [enter] to continue to synthetic Gaussian data demo with 2 tasks and 20 features")


data(exampleData)
result = diffee(exampleData[[1]], exampleData[[2]], 0.45)
data(exampleDataGraph)
layout = layout_nicely(exampleDataGraph[[1]], dim = 2)


readline(prompt = "Press [enter] to view comparison between ground truth and generated difference graph")

{
  par(mfrow = c(1, 2))
  plot(result, layout = layout)
  plot(
    union(exampleDataGraph[[2]], exampleDataGraph[[3]]),
    layout = layout,
    vertex.label.font = 2,
    vertex.shape = "none",
    vertex.label.color = "gray40",
    vertex.label.cex = .7,
    vertex.frame.color = "white",
    vertex.size = 10 ,
    edge.color = rainbow(1)[1],
    main = "difference graph ground truth"
  )

}



readline(prompt = "Press [enter] to continue to synthetic Gaussian data demo with 2 tasks and 500 features")


readline(prompt = "Press [enter] to view the DIFFEE runtime (takes roughly 30 seconds on an i7 machine)")
{
  start_time = Sys.time()
  data500 = simulation(p=500, n = c(500,500))
  diffee(data500$simulatedsamples[[1]], data500$simulatedsamples[[2]], 1)
  end_time = Sys.time()
  print(paste(
    "the time taken for DIFFEE to run with p = 500 is",
    end_time - start_time,
    "mins"
  ))
}
