/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.GammaFunction;
import dr.math.MersenneTwisterFast;
import dr.util.NumberFormatter;
import java.text.NumberFormat;
import java.text.ParseException;

public class MathUtils {
    private static final MersenneTwisterFast random = MersenneTwisterFast.DEFAULT_INSTANCE;

    private MathUtils() {
    }

    public static int randomChoice(double[] dArray) {
        int n;
        double d = MathUtils.nextDouble();
        if (d <= dArray[0]) {
            n = 0;
        } else {
            for (n = 1; !(n >= dArray.length || d <= dArray[n] && d > dArray[n - 1]); ++n) {
            }
        }
        return n;
    }

    public static int randomChoicePDF(double[] dArray) {
        int n;
        double d = MathUtils.nextDouble() * MathUtils.getTotal(dArray);
        for (n = 0; n < dArray.length; ++n) {
            if (!((d -= dArray[n]) < 0.0)) continue;
            return n;
        }
        for (n = 0; n < dArray.length; ++n) {
            System.out.println(n + "\t" + dArray[n]);
        }
        throw new Error("randomChoicePDF falls through -- negative, infinite or NaN components in input distribution, or all zeroes?");
    }

    public static int randomChoiceLogPDF(double[] dArray) {
        double d = Double.NEGATIVE_INFINITY;
        double[] dArray2 = dArray;
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            double d2 = dArray2[i];
            if (!(d2 > d)) continue;
            d = d2;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            throw new Error("randomChoiceLogPDF falls through -- all -INF components in input distribution");
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] - d;
        }
        double[] dArray3 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray3[n] = Math.exp(dArray[n]);
        }
        return MathUtils.randomChoicePDF(dArray3);
    }

    public static double[] getNormalized(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = MathUtils.getTotal(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] / d;
        }
        return dArray2;
    }

    public static double getTotal(double[] dArray, int n, int n2) {
        double d = 0.0;
        for (int i = n; i < n2; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double getTotal(double[] dArray) {
        return MathUtils.getTotal(dArray, 0, dArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSeed() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.getSeed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSeed(long l) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.setSeed(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte nextByte() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextByte();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nextBoolean() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nextBytes(byte[] byArray) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.nextBytes(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char nextChar() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextChar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextGaussian() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextGaussian();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextGamma(double d, double d2) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextGamma(d, d2);
        }
    }

    public static double nextBeta(double d, double d2) {
        double d3 = MathUtils.nextGamma(d, 1.0);
        double d4 = MathUtils.nextGamma(d2, 1.0);
        return d3 / (d3 + d4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextDouble() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextDouble();
        }
    }

    public static double randomLogDouble() {
        return Math.log(MathUtils.nextDouble());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextExponential(double d) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return -1.0 * Math.log(1.0 - random.nextDouble()) / d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextInverseGaussian(double d, double d2) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            double d3 = random.nextGaussian();
            double d4 = d3 * d3;
            double d5 = d + d * d * d4 / (2.0 * d2) - d / (2.0 * d2) * Math.sqrt(4.0 * d * d2 * d4 + d * d * d4 * d4);
            double d6 = MathUtils.nextDouble();
            if (d6 <= d / (d + d5)) {
                return d5;
            }
            return d * d / d5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float nextFloat() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextFloat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextLong() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short nextShort() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextShort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextInt() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextInt(int n) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextInt(n);
        }
    }

    public static double uniform(double d, double d2) {
        return d + MathUtils.nextDouble() * (d2 - d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuffle(int[] nArray) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.shuffle(nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuffle(int[] nArray, int n) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.shuffle(nArray, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] shuffled(int n) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.shuffled(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] sampleIndicesWithReplacement(int n) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = random.nextInt(n);
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void permute(int[] nArray) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.permute(nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] permuted(int n) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.permuted(n);
        }
    }

    public static double logHyperSphereVolume(int n, double d) {
        return (double)n * (0.5723649429247001 + Math.log(d)) + -GammaFunction.lnGamma((double)n / 2.0 + 1.0);
    }

    public static double hypot(double d, double d2) {
        double d3;
        if (Math.abs(d) > Math.abs(d2)) {
            d3 = d2 / d;
            d3 = Math.abs(d) * Math.sqrt(1.0 + d3 * d3);
        } else if (d2 != 0.0) {
            d3 = d / d2;
            d3 = Math.abs(d2) * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public static double round(double d, int n) {
        NumberFormatter numberFormatter = new NumberFormatter(n);
        try {
            return NumberFormat.getInstance().parse(numberFormatter.format(d)).doubleValue();
        }
        catch (ParseException parseException) {
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getRandomState() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.getRandomState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRandomState(int[] nArray) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.setRandomState(nArray);
        }
    }

    public static boolean isClose(double[] dArray, double[] dArray2, double d) {
        if (dArray.length != dArray2.length) {
            return false;
        }
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(dArray[i]) || Double.isNaN(dArray2[i])) {
                return false;
            }
            if (!(Math.abs(dArray[i] - dArray2[i]) > d)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRelativelyClose(double[] dArray, double[] dArray2, double d) {
        if (dArray.length != dArray2.length) {
            return false;
        }
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d2 = 2.0 * (dArray[i] - dArray2[i]) / (dArray[i] + dArray2[i]);
            if (!(Math.abs(d2) > d)) continue;
            return false;
        }
        return true;
    }
}

