/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.operators;

import dr.evomodel.antigenic.phyloclustering.TreeClusteringSharedRoutines;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.LinkedList;

public class RandomWalkOnActiveMu
extends AbstractAdaptableOperator {
    private MatrixParameter mu = null;
    private MatrixParameter virusLocations = null;
    private MatrixParameter virusLocationsTreeNode = null;
    private Parameter indicators;
    private TreeModel treeModel;
    private int numdata;
    private int numNodes;
    private int[] correspondingTreeIndexForVirus = null;
    private double windowSize = 0.5;
    public static final String RANDOMWALKACTIVEMU = "randomWalkOnActiveMu";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String VIRUSLOCATIONS = "virusLocations";
        public static final String VIRUSLOCATIONSTREENODE = "virusLocationsTreeNodes";
        public static final String MU = "mu";
        public static final String INDICATORS = "indicators";
        public static final String WINDOWSIZE = "windowSize";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("windowSize"), new ElementRule("virusLocations", Parameter.class), new ElementRule("virusLocationsTreeNodes", MatrixParameter.class), new ElementRule("mu", Parameter.class), new ElementRule("indicators", Parameter.class), new ElementRule(TreeModel.class)};

        @Override
        public String getParserName() {
            return RandomWalkOnActiveMu.RANDOMWALKACTIVEMU;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(WINDOWSIZE);
            XMLObject xMLObject2 = xMLObject.getChild(VIRUSLOCATIONS);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(VIRUSLOCATIONSTREENODE);
            MatrixParameter matrixParameter2 = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(MU);
            MatrixParameter matrixParameter3 = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(INDICATORS);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            return new RandomWalkOnActiveMu(d, matrixParameter, matrixParameter3, parameter, treeModel, d2, matrixParameter2);
        }

        @Override
        public String getParserDescription() {
            return "changes serum drift and make sure the first dimension of the active drifted mus stay the same";
        }

        @Override
        public Class getReturnType() {
            return RandomWalkOnActiveMu.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public RandomWalkOnActiveMu(double d, MatrixParameter matrixParameter, MatrixParameter matrixParameter2, Parameter parameter, TreeModel treeModel, double d2, MatrixParameter matrixParameter3) {
        super(AdaptationMode.ADAPTATION_ON);
        this.setWeight(d);
        this.windowSize = d2;
        this.virusLocations = matrixParameter;
        this.mu = matrixParameter2;
        this.indicators = parameter;
        this.treeModel = treeModel;
        this.virusLocationsTreeNode = matrixParameter3;
        this.numNodes = this.treeModel.getNodeCount();
        this.numdata = matrixParameter.getColumnDimension();
        this.correspondingTreeIndexForVirus = TreeClusteringSharedRoutines.setMembershipTreeToVirusIndexes(this.numdata, matrixParameter, this.numNodes, this.treeModel);
        TreeClusteringSharedRoutines.updateUndriftedVirusLocations(this.numNodes, this.numdata, this.treeModel, this.virusLocationsTreeNode, parameter, matrixParameter2, matrixParameter, this.correspondingTreeIndexForVirus);
    }

    @Override
    public double doOperation() {
        int n = TreeClusteringSharedRoutines.findAnOnNodeIncludingRootRandomly(this.numNodes, this.indicators);
        int n2 = (int)Math.floor(MathUtils.nextDouble() * 2.0);
        double d = (2.0 * MathUtils.nextDouble() - 1.0) * this.windowSize;
        double d2 = this.mu.getParameter(n).getParameterValue(n2);
        this.mu.getParameter(n).setParameterValue(n2, d2 + d);
        LinkedList<Integer> linkedList = TreeClusteringSharedRoutines.findActiveBreakpointsChildren(n, this.numNodes, this.treeModel, this.indicators);
        for (int i = 0; i < linkedList.size(); ++i) {
            int n3 = linkedList.get(i);
            Parameter parameter = this.mu.getParameter(n3);
            double d3 = parameter.getParameterValue(n2);
            this.mu.getParameter(n3).setParameterValue(n2, d3 - d);
        }
        TreeClusteringSharedRoutines.updateUndriftedVirusLocations(this.numNodes, this.numdata, this.treeModel, this.virusLocationsTreeNode, this.indicators, this.mu, this.virusLocations, this.correspondingTreeIndexForVirus);
        return 0.0;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.windowSize);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.windowSize = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.windowSize;
    }

    @Override
    public String getAdaptableParameterName() {
        return "windowSize";
    }

    @Override
    public final String getOperatorName() {
        return RANDOMWALKACTIVEMU;
    }

    public int getStepCount() {
        return 1;
    }
}

