/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.athena;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.simba.athena.amazonaws.ClientConfiguration;
import com.simba.athena.amazonaws.annotation.ThreadSafe;
import com.simba.athena.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.simba.athena.amazonaws.client.AwsAsyncClientParams;
import com.simba.athena.amazonaws.handlers.AsyncHandler;
import com.simba.athena.amazonaws.services.athena.AmazonAthenaAsync;
import com.simba.athena.amazonaws.services.athena.AmazonAthenaAsyncClientBuilder;
import com.simba.athena.amazonaws.services.athena.AmazonAthenaClient;
import com.simba.athena.amazonaws.services.athena.model.BatchGetNamedQueryRequest;
import com.simba.athena.amazonaws.services.athena.model.BatchGetNamedQueryResult;
import com.simba.athena.amazonaws.services.athena.model.BatchGetQueryExecutionRequest;
import com.simba.athena.amazonaws.services.athena.model.BatchGetQueryExecutionResult;
import com.simba.athena.amazonaws.services.athena.model.CreateNamedQueryRequest;
import com.simba.athena.amazonaws.services.athena.model.CreateNamedQueryResult;
import com.simba.athena.amazonaws.services.athena.model.CreateWorkGroupRequest;
import com.simba.athena.amazonaws.services.athena.model.CreateWorkGroupResult;
import com.simba.athena.amazonaws.services.athena.model.DeleteNamedQueryRequest;
import com.simba.athena.amazonaws.services.athena.model.DeleteNamedQueryResult;
import com.simba.athena.amazonaws.services.athena.model.DeleteWorkGroupRequest;
import com.simba.athena.amazonaws.services.athena.model.DeleteWorkGroupResult;
import com.simba.athena.amazonaws.services.athena.model.GetNamedQueryRequest;
import com.simba.athena.amazonaws.services.athena.model.GetNamedQueryResult;
import com.simba.athena.amazonaws.services.athena.model.GetQueryExecutionRequest;
import com.simba.athena.amazonaws.services.athena.model.GetQueryExecutionResult;
import com.simba.athena.amazonaws.services.athena.model.GetQueryResultsRequest;
import com.simba.athena.amazonaws.services.athena.model.GetQueryResultsResult;
import com.simba.athena.amazonaws.services.athena.model.GetWorkGroupRequest;
import com.simba.athena.amazonaws.services.athena.model.GetWorkGroupResult;
import com.simba.athena.amazonaws.services.athena.model.ListNamedQueriesRequest;
import com.simba.athena.amazonaws.services.athena.model.ListNamedQueriesResult;
import com.simba.athena.amazonaws.services.athena.model.ListQueryExecutionsRequest;
import com.simba.athena.amazonaws.services.athena.model.ListQueryExecutionsResult;
import com.simba.athena.amazonaws.services.athena.model.ListWorkGroupsRequest;
import com.simba.athena.amazonaws.services.athena.model.ListWorkGroupsResult;
import com.simba.athena.amazonaws.services.athena.model.StartQueryExecutionRequest;
import com.simba.athena.amazonaws.services.athena.model.StartQueryExecutionResult;
import com.simba.athena.amazonaws.services.athena.model.StopQueryExecutionRequest;
import com.simba.athena.amazonaws.services.athena.model.StopQueryExecutionResult;
import com.simba.athena.amazonaws.services.athena.model.UpdateWorkGroupRequest;
import com.simba.athena.amazonaws.services.athena.model.UpdateWorkGroupResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonAthenaAsyncClient
extends AmazonAthenaClient
implements AmazonAthenaAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonAthenaAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonAthenaAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonAthenaAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonAthenaAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonAthenaAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonAthenaAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonAthenaAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonAthenaAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonAthenaAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonAthenaAsyncClientBuilder asyncBuilder() {
        return AmazonAthenaAsyncClientBuilder.standard();
    }

    AmazonAthenaAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetNamedQueryResult> batchGetNamedQueryAsync(BatchGetNamedQueryRequest request) {
        return this.batchGetNamedQueryAsync(request, null);
    }

    @Override
    public Future<BatchGetNamedQueryResult> batchGetNamedQueryAsync(BatchGetNamedQueryRequest request, final AsyncHandler<BatchGetNamedQueryRequest, BatchGetNamedQueryResult> asyncHandler) {
        final BatchGetNamedQueryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetNamedQueryResult>(){

            @Override
            public BatchGetNamedQueryResult call() throws Exception {
                BatchGetNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeBatchGetNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetQueryExecutionResult> batchGetQueryExecutionAsync(BatchGetQueryExecutionRequest request) {
        return this.batchGetQueryExecutionAsync(request, null);
    }

    @Override
    public Future<BatchGetQueryExecutionResult> batchGetQueryExecutionAsync(BatchGetQueryExecutionRequest request, final AsyncHandler<BatchGetQueryExecutionRequest, BatchGetQueryExecutionResult> asyncHandler) {
        final BatchGetQueryExecutionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetQueryExecutionResult>(){

            @Override
            public BatchGetQueryExecutionResult call() throws Exception {
                BatchGetQueryExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeBatchGetQueryExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNamedQueryResult> createNamedQueryAsync(CreateNamedQueryRequest request) {
        return this.createNamedQueryAsync(request, null);
    }

    @Override
    public Future<CreateNamedQueryResult> createNamedQueryAsync(CreateNamedQueryRequest request, final AsyncHandler<CreateNamedQueryRequest, CreateNamedQueryResult> asyncHandler) {
        final CreateNamedQueryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNamedQueryResult>(){

            @Override
            public CreateNamedQueryResult call() throws Exception {
                CreateNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCreateNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWorkGroupResult> createWorkGroupAsync(CreateWorkGroupRequest request) {
        return this.createWorkGroupAsync(request, null);
    }

    @Override
    public Future<CreateWorkGroupResult> createWorkGroupAsync(CreateWorkGroupRequest request, final AsyncHandler<CreateWorkGroupRequest, CreateWorkGroupResult> asyncHandler) {
        final CreateWorkGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateWorkGroupResult>(){

            @Override
            public CreateWorkGroupResult call() throws Exception {
                CreateWorkGroupResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCreateWorkGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNamedQueryResult> deleteNamedQueryAsync(DeleteNamedQueryRequest request) {
        return this.deleteNamedQueryAsync(request, null);
    }

    @Override
    public Future<DeleteNamedQueryResult> deleteNamedQueryAsync(DeleteNamedQueryRequest request, final AsyncHandler<DeleteNamedQueryRequest, DeleteNamedQueryResult> asyncHandler) {
        final DeleteNamedQueryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNamedQueryResult>(){

            @Override
            public DeleteNamedQueryResult call() throws Exception {
                DeleteNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeDeleteNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteWorkGroupResult> deleteWorkGroupAsync(DeleteWorkGroupRequest request) {
        return this.deleteWorkGroupAsync(request, null);
    }

    @Override
    public Future<DeleteWorkGroupResult> deleteWorkGroupAsync(DeleteWorkGroupRequest request, final AsyncHandler<DeleteWorkGroupRequest, DeleteWorkGroupResult> asyncHandler) {
        final DeleteWorkGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteWorkGroupResult>(){

            @Override
            public DeleteWorkGroupResult call() throws Exception {
                DeleteWorkGroupResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeDeleteWorkGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNamedQueryResult> getNamedQueryAsync(GetNamedQueryRequest request) {
        return this.getNamedQueryAsync(request, null);
    }

    @Override
    public Future<GetNamedQueryResult> getNamedQueryAsync(GetNamedQueryRequest request, final AsyncHandler<GetNamedQueryRequest, GetNamedQueryResult> asyncHandler) {
        final GetNamedQueryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNamedQueryResult>(){

            @Override
            public GetNamedQueryResult call() throws Exception {
                GetNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueryExecutionResult> getQueryExecutionAsync(GetQueryExecutionRequest request) {
        return this.getQueryExecutionAsync(request, null);
    }

    @Override
    public Future<GetQueryExecutionResult> getQueryExecutionAsync(GetQueryExecutionRequest request, final AsyncHandler<GetQueryExecutionRequest, GetQueryExecutionResult> asyncHandler) {
        final GetQueryExecutionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueryExecutionResult>(){

            @Override
            public GetQueryExecutionResult call() throws Exception {
                GetQueryExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetQueryExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueryResultsResult> getQueryResultsAsync(GetQueryResultsRequest request) {
        return this.getQueryResultsAsync(request, null);
    }

    @Override
    public Future<GetQueryResultsResult> getQueryResultsAsync(GetQueryResultsRequest request, final AsyncHandler<GetQueryResultsRequest, GetQueryResultsResult> asyncHandler) {
        final GetQueryResultsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueryResultsResult>(){

            @Override
            public GetQueryResultsResult call() throws Exception {
                GetQueryResultsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetQueryResults(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetWorkGroupResult> getWorkGroupAsync(GetWorkGroupRequest request) {
        return this.getWorkGroupAsync(request, null);
    }

    @Override
    public Future<GetWorkGroupResult> getWorkGroupAsync(GetWorkGroupRequest request, final AsyncHandler<GetWorkGroupRequest, GetWorkGroupResult> asyncHandler) {
        final GetWorkGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetWorkGroupResult>(){

            @Override
            public GetWorkGroupResult call() throws Exception {
                GetWorkGroupResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetWorkGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNamedQueriesResult> listNamedQueriesAsync(ListNamedQueriesRequest request) {
        return this.listNamedQueriesAsync(request, null);
    }

    @Override
    public Future<ListNamedQueriesResult> listNamedQueriesAsync(ListNamedQueriesRequest request, final AsyncHandler<ListNamedQueriesRequest, ListNamedQueriesResult> asyncHandler) {
        final ListNamedQueriesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNamedQueriesResult>(){

            @Override
            public ListNamedQueriesResult call() throws Exception {
                ListNamedQueriesResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListNamedQueries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListQueryExecutionsResult> listQueryExecutionsAsync(ListQueryExecutionsRequest request) {
        return this.listQueryExecutionsAsync(request, null);
    }

    @Override
    public Future<ListQueryExecutionsResult> listQueryExecutionsAsync(ListQueryExecutionsRequest request, final AsyncHandler<ListQueryExecutionsRequest, ListQueryExecutionsResult> asyncHandler) {
        final ListQueryExecutionsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListQueryExecutionsResult>(){

            @Override
            public ListQueryExecutionsResult call() throws Exception {
                ListQueryExecutionsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListQueryExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkGroupsResult> listWorkGroupsAsync(ListWorkGroupsRequest request) {
        return this.listWorkGroupsAsync(request, null);
    }

    @Override
    public Future<ListWorkGroupsResult> listWorkGroupsAsync(ListWorkGroupsRequest request, final AsyncHandler<ListWorkGroupsRequest, ListWorkGroupsResult> asyncHandler) {
        final ListWorkGroupsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWorkGroupsResult>(){

            @Override
            public ListWorkGroupsResult call() throws Exception {
                ListWorkGroupsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListWorkGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartQueryExecutionResult> startQueryExecutionAsync(StartQueryExecutionRequest request) {
        return this.startQueryExecutionAsync(request, null);
    }

    @Override
    public Future<StartQueryExecutionResult> startQueryExecutionAsync(StartQueryExecutionRequest request, final AsyncHandler<StartQueryExecutionRequest, StartQueryExecutionResult> asyncHandler) {
        final StartQueryExecutionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartQueryExecutionResult>(){

            @Override
            public StartQueryExecutionResult call() throws Exception {
                StartQueryExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeStartQueryExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopQueryExecutionResult> stopQueryExecutionAsync(StopQueryExecutionRequest request) {
        return this.stopQueryExecutionAsync(request, null);
    }

    @Override
    public Future<StopQueryExecutionResult> stopQueryExecutionAsync(StopQueryExecutionRequest request, final AsyncHandler<StopQueryExecutionRequest, StopQueryExecutionResult> asyncHandler) {
        final StopQueryExecutionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopQueryExecutionResult>(){

            @Override
            public StopQueryExecutionResult call() throws Exception {
                StopQueryExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeStopQueryExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateWorkGroupResult> updateWorkGroupAsync(UpdateWorkGroupRequest request) {
        return this.updateWorkGroupAsync(request, null);
    }

    @Override
    public Future<UpdateWorkGroupResult> updateWorkGroupAsync(UpdateWorkGroupRequest request, final AsyncHandler<UpdateWorkGroupRequest, UpdateWorkGroupResult> asyncHandler) {
        final UpdateWorkGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateWorkGroupResult>(){

            @Override
            public UpdateWorkGroupResult call() throws Exception {
                UpdateWorkGroupResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeUpdateWorkGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

