/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab.statisticaltests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import moa.gui.experimentertab.Algorithm;
import moa.gui.experimentertab.Stream;
import moa.gui.experimentertab.statisticaltests.CDF_Normal;
import moa.gui.experimentertab.statisticaltests.Fichero;
import moa.gui.experimentertab.statisticaltests.PValuePerTwoAlgorithm;
import moa.gui.experimentertab.statisticaltests.Pareja;
import moa.gui.experimentertab.statisticaltests.RankPerAlgorithm;
import moa.gui.experimentertab.statisticaltests.Relation;

public class StatisticalTest {
    ArrayList algoritmos;
    ArrayList datasets;
    ArrayList datos;
    int i;
    int j;
    int k;
    int m;
    int posicion;
    double[][] mean;
    Pareja[][] orden;
    Pareja[][] rank;
    boolean encontrado;
    int ig;
    double sum;
    boolean[] visto;
    ArrayList porVisitar;
    double[] Rj;
    double friedman;
    double sumatoria = 0.0;
    double termino1;
    double termino2;
    double termino3;
    double iman;
    boolean[] vistos;
    int pos;
    int tmp;
    double min;
    double maxVal;
    double rankingRef;
    double[] Pi;
    double[] ALPHAiHolm;
    double[] ALPHAiShaffer;
    String[] ordenAlgoritmos;
    double[] ordenRankings;
    int[] order;
    double[][] adjustedP;
    double[] Ci;
    double SE;
    boolean parar;
    boolean otro;
    ArrayList indices = new ArrayList();
    ArrayList exhaustiveI = new ArrayList();
    boolean[][] cuadro;
    double minPi;
    double tmpPi;
    double maxAPi;
    double tmpAPi;
    Relation[] parejitas;
    int lineaN = 0;
    int columnaN = 0;
    ArrayList T;
    int[] Tarray;
    ArrayList<RankPerAlgorithm> rankAlg;
    double pFriedman;
    double pIman;
    public List<Stream> streams = new ArrayList<Stream>();

    public StatisticalTest(List<Stream> streams) {
        this.streams = streams;
        this.algoritmos = new ArrayList();
        this.datasets = new ArrayList();
        this.datos = new ArrayList();
        this.rankAlg = new ArrayList();
    }

    public void readCSV(String path) {
        String cadena = Fichero.leeFichero(path);
        StringTokenizer lineas = new StringTokenizer(cadena, "\n\r");
        while (lineas.hasMoreTokens()) {
            String linea = lineas.nextToken();
            StringTokenizer tokens = new StringTokenizer(linea, ",\t");
            this.columnaN = 0;
            while (tokens.hasMoreTokens()) {
                String token;
                if (this.lineaN == 0) {
                    if (this.columnaN == 0) {
                        token = tokens.nextToken();
                    } else {
                        token = tokens.nextToken();
                        this.algoritmos.add(token);
                        this.datos.add(new ArrayList());
                    }
                } else if (this.columnaN == 0) {
                    token = tokens.nextToken();
                    this.datasets.add(token);
                } else {
                    token = tokens.nextToken();
                    ((ArrayList)this.datos.get(this.columnaN - 1)).add(new Double(token));
                }
                ++this.columnaN;
            }
            ++this.lineaN;
        }
    }

    public void readData() {
        int i;
        int cont = 0;
        int algorithmSize = this.streams.get((int)0).algorithm.size();
        int streamSize = this.streams.size();
        int measureSize = this.streams.get((int)0).algorithm.get((int)0).measures.size();
        for (i = 0; i < algorithmSize; ++i) {
            this.algoritmos.add(this.streams.get((int)0).algorithm.get((int)i).name);
            this.datos.add(new ArrayList());
        }
        for (i = 0; i < streamSize; ++i) {
            List<Algorithm> alg = this.streams.get((int)i).algorithm;
            this.datasets.add(this.streams.get((int)i).name);
            for (int j = 0; j < algorithmSize; ++j) {
                ((ArrayList)this.datos.get(j)).add(alg.get((int)j).measures.get(cont).getValue());
            }
        }
    }

    public void avgPerformance() {
        this.mean = new double[this.datasets.size()][this.algoritmos.size()];
        this.i = 0;
        while (this.i < this.datasets.size()) {
            this.j = 0;
            while (this.j < this.algoritmos.size()) {
                this.mean[this.i][this.j] = (Double)((ArrayList)this.datos.get(this.j)).get(this.i);
                ++this.j;
            }
            ++this.i;
        }
        this.orden = new Pareja[this.datasets.size()][this.algoritmos.size()];
        this.i = 0;
        while (this.i < this.datasets.size()) {
            this.j = 0;
            while (this.j < this.algoritmos.size()) {
                this.orden[this.i][this.j] = new Pareja(this.j, this.mean[this.i][this.j]);
                ++this.j;
            }
            Arrays.sort(this.orden[this.i]);
            ++this.i;
        }
        this.rank = new Pareja[this.datasets.size()][this.algoritmos.size()];
        this.posicion = 0;
        this.i = 0;
        while (this.i < this.datasets.size()) {
            this.j = 0;
            while (this.j < this.algoritmos.size()) {
                this.encontrado = false;
                this.k = 0;
                while (this.k < this.algoritmos.size() && !this.encontrado) {
                    if (this.orden[this.i][this.k].indice == (double)this.j) {
                        this.encontrado = true;
                        this.posicion = this.k + 1;
                    }
                    ++this.k;
                }
                this.rank[this.i][this.j] = new Pareja(this.posicion, this.orden[this.i][this.posicion - 1].valor);
                ++this.j;
            }
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.datasets.size()) {
            this.visto = new boolean[this.algoritmos.size()];
            this.porVisitar = new ArrayList();
            Arrays.fill(this.visto, false);
            this.j = 0;
            while (this.j < this.algoritmos.size()) {
                this.porVisitar.clear();
                this.sum = this.rank[this.i][this.j].indice;
                this.visto[this.j] = true;
                this.ig = 1;
                this.k = this.j + 1;
                while (this.k < this.algoritmos.size()) {
                    if (this.rank[this.i][this.j].valor == this.rank[this.i][this.k].valor && !this.visto[this.k]) {
                        this.sum += this.rank[this.i][this.k].indice;
                        ++this.ig;
                        this.porVisitar.add(new Integer(this.k));
                        this.visto[this.k] = true;
                    }
                    ++this.k;
                }
                this.sum /= (double)this.ig;
                this.rank[this.i][this.j].indice = this.sum;
                this.k = 0;
                while (this.k < this.porVisitar.size()) {
                    this.rank[this.i][((Integer)this.porVisitar.get((int)this.k)).intValue()].indice = this.sum;
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        this.avgRankingPerAlgorithm();
    }

    private void avgRankingPerAlgorithm() {
        this.Rj = new double[this.algoritmos.size()];
        this.i = 0;
        while (this.i < this.algoritmos.size()) {
            this.Rj[this.i] = 0.0;
            this.j = 0;
            while (this.j < this.datasets.size()) {
                int n = this.i;
                this.Rj[n] = this.Rj[n] + this.rank[this.j][this.i].indice / (double)this.datasets.size();
                ++this.j;
            }
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.algoritmos.size()) {
            this.rankAlg.add(new RankPerAlgorithm((String)this.algoritmos.get(this.i), this.Rj[this.i]));
            ++this.i;
        }
        Collections.sort(this.rankAlg, new ComparatorImpl());
        this.termino1 = 12.0 * (double)this.datasets.size() / ((double)this.algoritmos.size() * ((double)this.algoritmos.size() + 1.0));
        this.termino2 = (double)this.algoritmos.size() * ((double)this.algoritmos.size() + 1.0) * ((double)this.algoritmos.size() + 1.0) / 4.0;
        this.i = 0;
        while (this.i < this.algoritmos.size()) {
            this.sumatoria += this.Rj[this.i] * this.Rj[this.i];
            ++this.i;
        }
        this.friedman = (this.sumatoria - this.termino2) * this.termino1;
        this.pFriedman = StatisticalTest.ChiSq(this.friedman, this.algoritmos.size() - 1);
        this.iman = (double)(this.datasets.size() - 1) * this.friedman / ((double)(this.datasets.size() * (this.algoritmos.size() - 1)) - this.friedman);
        this.pIman = StatisticalTest.FishF(this.iman, this.algoritmos.size() - 1, (this.algoritmos.size() - 1) * (this.datasets.size() - 1));
        this.termino3 = Math.sqrt((double)this.algoritmos.size() * ((double)this.algoritmos.size() + 1.0) / (6.0 * (double)this.datasets.size()));
        this.inicialize();
    }

    public double getFriedmanPValue() {
        return this.pFriedman;
    }

    public double getImanPValue() {
        return this.pIman;
    }

    public ArrayList<RankPerAlgorithm> getRankAlg() {
        return this.rankAlg;
    }

    private void inicialize() {
        this.Pi = new double[(int)StatisticalTest.combinatoria(2, this.algoritmos.size())];
        this.ordenAlgoritmos = new String[(int)StatisticalTest.combinatoria(2, this.algoritmos.size())];
        this.ordenRankings = new double[(int)StatisticalTest.combinatoria(2, this.algoritmos.size())];
        this.order = new int[(int)StatisticalTest.combinatoria(2, this.algoritmos.size())];
        this.parejitas = new Relation[(int)StatisticalTest.combinatoria(2, this.algoritmos.size())];
        this.T = new ArrayList();
        this.T = StatisticalTest.trueHShaffer(this.algoritmos.size());
        this.Tarray = new int[this.T.size()];
        this.i = 0;
        while (this.i < this.T.size()) {
            this.Tarray[this.i] = (Integer)this.T.get(this.i);
            ++this.i;
        }
        Arrays.sort(this.Tarray);
        this.SE = this.termino3;
        this.vistos = new boolean[(int)StatisticalTest.combinatoria(2, this.algoritmos.size())];
        this.i = 0;
        this.k = 0;
        while (this.i < this.algoritmos.size()) {
            this.j = this.i + 1;
            while (this.j < this.algoritmos.size()) {
                this.ordenRankings[this.k] = Math.abs(this.Rj[this.i] - this.Rj[this.j]);
                this.ordenAlgoritmos[this.k] = (String)this.algoritmos.get(this.i) + " vs. " + (String)this.algoritmos.get(this.j);
                this.parejitas[this.k] = new Relation(this.i, this.j);
                ++this.j;
                ++this.k;
            }
            ++this.i;
        }
        Arrays.fill(this.vistos, false);
        this.i = 0;
        while (this.i < this.ordenRankings.length) {
            this.j = 0;
            while (this.vistos[this.j]) {
                ++this.j;
            }
            this.pos = this.j;
            this.maxVal = this.ordenRankings[this.j];
            ++this.j;
            while (this.j < this.ordenRankings.length) {
                if (!this.vistos[this.j] && this.ordenRankings[this.j] > this.maxVal) {
                    this.pos = this.j;
                    this.maxVal = this.ordenRankings[this.j];
                }
                ++this.j;
            }
            this.vistos[this.pos] = true;
            this.order[this.i] = this.pos;
            ++this.i;
        }
        this.pos = 0;
        this.tmp = this.Tarray.length - 1;
        this.i = 0;
        while (this.i < this.order.length) {
            this.Pi[this.i] = 2.0 * CDF_Normal.normp(-1.0 * Math.abs(this.ordenRankings[this.order[this.i]] / this.SE));
            ++this.i;
        }
    }

    public ArrayList<PValuePerTwoAlgorithm> holmTest() {
        ArrayList<PValuePerTwoAlgorithm> algPValues = new ArrayList<PValuePerTwoAlgorithm>();
        double[] holmPValues = new double[this.Pi.length];
        this.i = 0;
        while (this.i < holmPValues.length) {
            holmPValues[this.i] = this.Pi[this.i] * (double)(holmPValues.length - this.i);
            ++this.i;
        }
        this.i = 1;
        while (this.i < holmPValues.length) {
            if (holmPValues[this.i] < holmPValues[this.i - 1]) {
                holmPValues[this.i] = holmPValues[this.i - 1];
            }
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.Pi.length) {
            algPValues.add(new PValuePerTwoAlgorithm(this.algoritmos.get(this.parejitas[this.order[this.i]].i).toString(), this.algoritmos.get(this.parejitas[this.order[this.i]].j).toString(), holmPValues[this.i]));
            ++this.i;
        }
        return algPValues;
    }

    public ArrayList<PValuePerTwoAlgorithm> shafferTest() {
        ArrayList<PValuePerTwoAlgorithm> algPValues = new ArrayList<PValuePerTwoAlgorithm>();
        double[] shafferPValues = new double[this.Pi.length];
        this.pos = 0;
        this.tmp = this.Tarray.length - 1;
        this.i = 0;
        while (this.i < shafferPValues.length) {
            shafferPValues[this.i] = this.Pi[this.i] * ((double)shafferPValues.length - (double)Math.max(this.pos, this.i));
            if (this.i == this.pos) {
                --this.tmp;
                this.pos = (int)StatisticalTest.combinatoria(2, this.algoritmos.size()) - this.Tarray[this.tmp];
            }
            ++this.i;
        }
        this.i = 1;
        while (this.i < shafferPValues.length) {
            if (shafferPValues[this.i] < shafferPValues[this.i - 1]) {
                shafferPValues[this.i] = shafferPValues[this.i - 1];
            }
            if (shafferPValues[this.i] < shafferPValues[this.i - 1]) {
                shafferPValues[this.i] = shafferPValues[this.i - 1];
            }
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.Pi.length) {
            algPValues.add(new PValuePerTwoAlgorithm(this.algoritmos.get(this.parejitas[this.order[this.i]].i).toString(), this.algoritmos.get(this.parejitas[this.order[this.i]].j).toString(), shafferPValues[this.i]));
            ++this.i;
        }
        return algPValues;
    }

    public ArrayList<PValuePerTwoAlgorithm> nemenyiTest() {
        ArrayList<PValuePerTwoAlgorithm> algPValues = new ArrayList<PValuePerTwoAlgorithm>();
        double[] nemenyiPValues = new double[this.Pi.length];
        this.pos = 0;
        this.tmp = this.Tarray.length - 1;
        this.i = 0;
        while (this.i < nemenyiPValues.length) {
            nemenyiPValues[this.i] = this.Pi[this.i] * (double)nemenyiPValues.length;
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.Pi.length) {
            algPValues.add(new PValuePerTwoAlgorithm(this.algoritmos.get(this.parejitas[this.order[this.i]].i).toString(), this.algoritmos.get(this.parejitas[this.order[this.i]].j).toString(), nemenyiPValues[this.i]));
            ++this.i;
        }
        return algPValues;
    }

    private static double combinatoria(int m, int n) {
        double result = 1.0;
        if (n >= m) {
            for (int i = 1; i <= m; ++i) {
                result *= (double)(n - m + i) / (double)i;
            }
        } else {
            result = 0.0;
        }
        return result;
    }

    private static ArrayList obtainExhaustive(ArrayList indices) {
        int j;
        int i;
        ArrayList result = new ArrayList();
        boolean[] number = new boolean[indices.size()];
        ArrayList<Relation> set = new ArrayList<Relation>();
        ArrayList<Integer> ind1 = new ArrayList<Integer>();
        ArrayList<Integer> ind2 = new ArrayList<Integer>();
        ArrayList temp = new ArrayList();
        ArrayList temp2 = new ArrayList();
        ArrayList temp3 = new ArrayList();
        for (i = 0; i < indices.size(); ++i) {
            for (j = i + 1; j < indices.size(); ++j) {
                set.add(new Relation((Integer)indices.get(i), (Integer)indices.get(j)));
            }
        }
        if (set.size() > 0) {
            result.add(set);
        }
        for (i = 1; i < (int)Math.pow(2.0, indices.size() - 1); ++i) {
            int k;
            Arrays.fill(number, false);
            ind1.clear();
            ind2.clear();
            temp.clear();
            temp2.clear();
            temp3.clear();
            String binario = Integer.toString(i, 2);
            for (k = 0; k < number.length - binario.length(); ++k) {
                number[k] = false;
            }
            j = 0;
            while (j < binario.length()) {
                if (binario.charAt(j) == '1') {
                    number[k] = true;
                }
                ++j;
                ++k;
            }
            for (j = 0; j < number.length; ++j) {
                if (number[j]) {
                    ind1.add((Integer)indices.get(j));
                    continue;
                }
                ind2.add((Integer)indices.get(j));
            }
            ArrayList res1 = StatisticalTest.obtainExhaustive(ind1);
            ArrayList res2 = StatisticalTest.obtainExhaustive(ind2);
            for (j = 0; j < res1.size(); ++j) {
                result.add(new ArrayList((ArrayList)res1.get(j)));
            }
            for (j = 0; j < res2.size(); ++j) {
                result.add(new ArrayList((ArrayList)res2.get(j)));
            }
            for (j = 0; j < res1.size(); ++j) {
                temp = (ArrayList)((ArrayList)res1.get(j)).clone();
                for (k = 0; k < res2.size(); ++k) {
                    temp2 = (ArrayList)temp.clone();
                    temp3 = (ArrayList)((ArrayList)res2.get(k)).clone();
                    if (((Relation)temp2.get((int)0)).i < ((Relation)temp3.get((int)0)).i) {
                        temp2.addAll(temp3);
                        result.add(new ArrayList(temp2));
                        continue;
                    }
                    temp3.addAll(temp2);
                    result.add(new ArrayList(temp3));
                }
            }
        }
        for (i = 0; i < result.size(); ++i) {
            if (!((ArrayList)result.get(i)).toString().equalsIgnoreCase("[]")) continue;
            result.remove(i);
            --i;
        }
        for (i = 0; i < result.size(); ++i) {
            for (j = i + 1; j < result.size(); ++j) {
                if (!((ArrayList)result.get(i)).toString().equalsIgnoreCase(((ArrayList)result.get(j)).toString())) continue;
                result.remove(j);
                --j;
            }
        }
        return result;
    }

    private static ArrayList trueHShaffer(int k) {
        ArrayList number = new ArrayList();
        ArrayList tmp = new ArrayList();
        if (k <= 1) {
            number.add(0);
        } else {
            for (int j = 1; j <= k; ++j) {
                tmp = StatisticalTest.trueHShaffer(k - j);
                ArrayList<Integer> tmp2 = new ArrayList<Integer>();
                for (int p = 0; p < tmp.size(); ++p) {
                    tmp2.add((Integer)tmp.get(p) + (int)StatisticalTest.combinatoria(2, j));
                }
                number = StatisticalTest.unionVectores(number, tmp2);
            }
        }
        return number;
    }

    private static ArrayList unionVectores(ArrayList a, ArrayList b) {
        for (int i = 0; i < b.size(); ++i) {
            if (a.contains(new Integer((Integer)b.get(i)))) continue;
            a.add(b.get(i));
        }
        return a;
    }

    private static double ChiSq(double x, int n) {
        if (n == 1 & x > 1000.0) {
            return 0.0;
        }
        if (x > 1000.0 | n > 1000) {
            double q = StatisticalTest.ChiSq((x - (double)n) * (x - (double)n) / (double)(2 * n), 1) / 2.0;
            if (x > (double)n) {
                return q;
            }
            return 1.0 - q;
        }
        double p = Math.exp(-0.5 * x);
        if (n % 2 == 1) {
            p *= Math.sqrt(2.0 * x / Math.PI);
        }
        for (double k = (double)n; k >= 2.0; k -= 2.0) {
            p = p * x / k;
        }
        double t = p;
        double a = n;
        while (t > 1.0E-10 * p) {
            t = t * x / (a += 2.0);
            p += t;
        }
        return 1.0 - p;
    }

    private static double FishF(double f, int n1, int n2) {
        double x = (double)n2 / ((double)n1 * f + (double)n2);
        if (n1 % 2 == 0) {
            return StatisticalTest.StatCom(1.0 - x, n2, n1 + n2 - 4, n2 - 2) * Math.pow(x, (double)n2 / 2.0);
        }
        if (n2 % 2 == 0) {
            return 1.0 - StatisticalTest.StatCom(x, n1, n1 + n2 - 4, n1 - 2) * Math.pow(1.0 - x, (double)n1 / 2.0);
        }
        double th = Math.atan(Math.sqrt((double)n1 * f / (1.0 * (double)n2)));
        double a = th / 1.5707963267948966;
        double sth = Math.sin(th);
        double cth = Math.cos(th);
        if (n2 > 1) {
            a += sth * cth * StatisticalTest.StatCom(cth * cth, 2, n2 - 3, -1) / 1.5707963267948966;
        }
        if (n1 == 1) {
            return 1.0 - a;
        }
        double c = 4.0 * StatisticalTest.StatCom(sth * sth, n2 + 1, n1 + n2 - 4, n2 - 2) * sth * Math.pow(cth, n2) / Math.PI;
        if (n2 == 1) {
            return 1.0 - a + c / 2.0;
        }
        int k = 2;
        while ((double)k <= (double)(n2 - 1) / 2.0) {
            c = c * (double)k / ((double)k - 0.5);
            ++k;
        }
        return 1.0 - a + c;
    }

    private static double StatCom(double q, int i, int j, int b) {
        double zz;
        double z = zz = 1.0;
        for (int k = i; k <= j; k += 2) {
            zz = zz * q * (double)k / (double)(k - b);
            z += zz;
        }
        return z;
    }

    private static class ComparatorImpl
    implements Comparator<RankPerAlgorithm> {
        @Override
        public int compare(RankPerAlgorithm r1, RankPerAlgorithm r2) {
            return r1.compareTo(r2);
        }
    }
}

