/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import java.util.Comparator;
import java.util.function.ToDoubleFunction;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.regression.GenericTradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import lombok.Generated;

public final class TradingDaysRegressionComparator {
    public static final ITradingDaysVariable[] ALL = new ITradingDaysVariable[]{new GenericTradingDaysVariable(DayClustering.TD2), new GenericTradingDaysVariable(DayClustering.TD3), new GenericTradingDaysVariable(DayClustering.TD3c), new GenericTradingDaysVariable(DayClustering.TD4), new GenericTradingDaysVariable(DayClustering.TD7)};
    public static final ITradingDaysVariable[] ALL_NESTED = new ITradingDaysVariable[]{new GenericTradingDaysVariable(DayClustering.TD2), new GenericTradingDaysVariable(DayClustering.TD3), new GenericTradingDaysVariable(DayClustering.TD4), new GenericTradingDaysVariable(DayClustering.TD7)};
    public static final ITradingDaysVariable[] DEFAULT = new ITradingDaysVariable[]{new GenericTradingDaysVariable(DayClustering.TD2), new GenericTradingDaysVariable(DayClustering.TD3), new GenericTradingDaysVariable(DayClustering.TD7)};
    public static final ITradingDaysVariable[] LEGACY = new ITradingDaysVariable[]{new GenericTradingDaysVariable(DayClustering.TD2), new GenericTradingDaysVariable(DayClustering.TD7)};

    public static RegArimaEstimation<SarimaModel>[] test(ModelDescription description, ITradingDaysVariable[] td, ILengthOfPeriodVariable lp, double eps) {
        RegArimaEstimation[] rslt = new RegArimaEstimation[td.length + 2];
        ModelDescription refdesc = ModelDescription.copyOf(description);
        refdesc.remove("td");
        refdesc.remove("lp");
        refdesc.setAirline(true);
        refdesc.setMean(true);
        boolean useLp = lp != null && !refdesc.isAdjusted();
        IRegArimaComputer<SarimaModel> processor = RegArimaUtility.processor(true, eps);
        rslt[0] = refdesc.estimate(processor);
        if (useLp) {
            refdesc.addVariable(Variable.variable((String)"lp", (ITsVariable)lp));
            rslt[1] = refdesc.estimate(processor);
        }
        for (int i = 0; i < td.length; ++i) {
            ModelDescription cdesc = ModelDescription.copyOf(refdesc);
            cdesc.addVariable(Variable.variable((String)"td", (ITsVariable)td[i]));
            rslt[i + 2] = cdesc.estimate(processor);
        }
        return rslt;
    }

    public static RegArimaEstimation<SarimaModel>[] testRestrictions(ModelDescription description, ITradingDaysVariable[] td, ILengthOfPeriodVariable lp, double eps) {
        RegArimaModel reg;
        RegArimaEstimation<SarimaModel> fullEstimation;
        boolean useLp;
        RegArimaEstimation[] rslt = new RegArimaEstimation[td.length + 2];
        int lastModel = td.length - 1;
        ModelDescription refdesc = ModelDescription.copyOf(description);
        refdesc.remove("td");
        refdesc.remove("lp");
        refdesc.setAirline(true);
        refdesc.setMean(true);
        boolean bl = useLp = lp != null && !refdesc.isAdjusted();
        if (useLp) {
            refdesc.addVariable(Variable.variable((String)"lp", (ITsVariable)lp));
        }
        ModelDescription cdesc = ModelDescription.copyOf(refdesc);
        cdesc.addVariable(Variable.variable((String)"td", (ITsVariable)td[lastModel]));
        IRegArimaComputer<SarimaModel> processor = RegArimaUtility.processor(true, eps);
        rslt[lastModel + 2] = fullEstimation = cdesc.estimate(processor);
        double llcorr = fullEstimation.getLlAdjustment();
        for (int i = 0; i < lastModel; ++i) {
            cdesc = ModelDescription.copyOf(refdesc);
            cdesc.addVariable(Variable.variable((String)"td", (ITsVariable)td[i]));
            reg = RegArimaModel.of(cdesc.regarima(), fullEstimation.getModel().arima());
            rslt[i + 2] = RegArimaEstimation.of(reg, llcorr, 2);
        }
        if (useLp) {
            reg = RegArimaModel.of(refdesc.regarima(), fullEstimation.getModel().arima());
            rslt[1] = RegArimaEstimation.of(reg, llcorr, 2);
            refdesc.remove("lp");
        }
        reg = RegArimaModel.of(refdesc.regarima(), fullEstimation.getModel().arima());
        rslt[0] = RegArimaEstimation.of(reg, llcorr, 2);
        return rslt;
    }

    public static int bestModel(RegArimaEstimation<SarimaModel>[] rslt, Comparator<RegArimaEstimation<SarimaModel>> cmp) {
        int best;
        for (best = 0; rslt[best] == null && best < rslt.length; ++best) {
        }
        if (best == rslt.length) {
            return -1;
        }
        for (int i = best + 1; i < rslt.length; ++i) {
            if (rslt[i] == null || cmp.compare(rslt[best], rslt[i]) <= 0) continue;
            best = i;
        }
        return best;
    }

    public static int waldTest(RegArimaEstimation<SarimaModel>[] rslt, double pval, double prest) {
        int i;
        int best = rslt.length - 1;
        ConcentratedLikelihoodWithMissing ll = rslt[best].getConcentratedLikelihood();
        ConcentratedLikelihoodWithMissing ll0 = rslt[0].getConcentratedLikelihood();
        int df = ll.degreesOfFreedom() - 2;
        double sigma = ll.ssq() / (double)df;
        double[] pvals = new double[rslt.length];
        double[] ssq = new double[rslt.length];
        int[] nx = new int[rslt.length];
        nx[0] = ll0.nx();
        nx[best] = ll.nx();
        ssq[0] = ll0.ssq();
        ssq[best] = ll.ssq();
        for (i = 1; i < best; ++i) {
            if (rslt[i] == null) continue;
            ConcentratedLikelihoodWithMissing lli = rslt[i].getConcentratedLikelihood();
            nx[i] = lli.nx();
            ssq[i] = lli.ssq();
        }
        for (i = 1; i <= best; ++i) {
            int n = nx[i] - nx[0];
            if (n == 0) {
                pvals[i] = 1.0;
                continue;
            }
            double f = (ssq[0] - ssq[i]) / ((double)n * sigma);
            if (f > 0.0) {
                F fdist = new F(n, df);
                pvals[i] = fdist.getProbability(f, ProbabilityType.Upper);
                continue;
            }
            pvals[i] = 1.0;
        }
        while (best > 0 && pvals[best] > pval) {
            --best;
        }
        if (best <= 1) {
            return best;
        }
        for (int next = best - 1; next > 0; --next) {
            F f;
            double pdel;
            int ndel;
            double fdel;
            if (!(pvals[next] < pval) || !((fdel = (ssq[next] - ssq[best]) / ((double)(ndel = nx[best] - nx[next]) * sigma)) > 0.0) || !((pdel = (f = new F(ndel, df)).getProbability(fdel, ProbabilityType.Upper)) > prest)) continue;
            best = next;
        }
        return best;
    }

    public static Comparator<RegArimaEstimation<SarimaModel>> aicComparator() {
        return TradingDaysRegressionComparator.comparator(e -> e.statistics().getAIC());
    }

    public static Comparator<RegArimaEstimation<SarimaModel>> aiccComparator() {
        return TradingDaysRegressionComparator.comparator(e -> e.statistics().getAICC());
    }

    public static Comparator<RegArimaEstimation<SarimaModel>> biccComparator() {
        return TradingDaysRegressionComparator.comparator(e -> e.statistics().getBICC());
    }

    public static Comparator<RegArimaEstimation<SarimaModel>> bicComparator() {
        return TradingDaysRegressionComparator.comparator(e -> e.statistics().getBIC());
    }

    private static Comparator<RegArimaEstimation<SarimaModel>> comparator(ToDoubleFunction<RegArimaEstimation<SarimaModel>> fn) {
        return (e1, e2) -> {
            if (e1 == null) {
                return 1;
            }
            if (e2 == null) {
                return -1;
            }
            return Double.compare(fn.applyAsDouble((RegArimaEstimation<SarimaModel>)e1), fn.applyAsDouble((RegArimaEstimation<SarimaModel>)e2));
        };
    }

    @Generated
    private TradingDaysRegressionComparator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

