/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.math;

import jdplus.toolkit.base.api.math.ComplexType;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class Complex
implements ComplexType {
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex TWO = new Complex(2.0, 0.0);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex ZERO = new Complex(0.0, 0.0);
    public static final Complex NEG_ONE = new Complex(-1.0, 0.0);
    public static final Complex NEG_TWO = new Complex(-2.0, 0.0);
    public static final Complex NEG_I = new Complex(0.0, -1.0);
    public static final double EPS = 1.0E-9;
    private final double re;
    private final double im;

    public static Complex cart(double re, double im) {
        if (re == 0.0) {
            if (im == 1.0) {
                return I;
            }
            if (im == 0.0) {
                return ZERO;
            }
            if (im == -1.0) {
                return NEG_I;
            }
        } else if (im == 0.0) {
            if (re == 1.0) {
                return ONE;
            }
            if (re == -1.0) {
                return NEG_ONE;
            }
            if (re == -2.0) {
                return NEG_TWO;
            }
        }
        return new Complex(re, im);
    }

    public static Complex polar(double r, double theta) {
        if (r < 0.0) {
            theta += Math.PI;
            r = -r;
        }
        return Complex.cart(r * Math.cos(theta %= Math.PI * 2), r * Math.sin(theta));
    }

    public static Complex cart(double re) {
        return Complex.cart(re, 0.0);
    }

    private Complex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public Complex conj() {
        return Complex.cart(this.re, -this.im);
    }

    public boolean equals(Complex z, double tolerance) {
        return ComplexType.abs(this.re - z.re, this.im - z.im) <= tolerance;
    }

    public boolean isInfinity() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("(");
        result.append(this.re);
        if (this.im < 0.0) {
            result.append(" - ").append(-this.im);
        } else if (this.im == 0.0) {
            result.append(" - ").append(0.0);
        } else {
            result.append(" + ").append(this.im);
        }
        result.append("i)");
        return result.toString();
    }

    public double absSquare() {
        return this.re * this.re + this.im * this.im;
    }

    public double distance(Complex r) {
        return ComplexType.abs(this.re - r.getRe(), this.im - r.getIm());
    }

    public double squareDistance(Complex r) {
        double dr = this.re - r.getRe();
        double di = this.im - r.getIm();
        return dr * dr + di * di;
    }

    public Complex minus(Complex b) {
        return Complex.cart(this.re - b.getRe(), this.im - b.getIm());
    }

    public Complex minus(double z) {
        if (z == 0.0) {
            return this;
        }
        return Complex.cart(this.re - z, this.im);
    }

    public Complex negate() {
        return Complex.cart(-this.re, -this.im);
    }

    public Complex plus(Complex b) {
        return Complex.cart(this.re + b.getRe(), this.im + b.getIm());
    }

    public Complex plus(double z) {
        if (z == 0.0) {
            return this;
        }
        return Complex.cart(this.re + z, this.im);
    }

    public Complex times(Complex b) {
        return Complex.cart(this.re * b.getRe() - this.im * b.getIm(), this.re * b.getIm() + this.im * b.getRe());
    }

    public Complex times(double z) {
        if (z == 1.0) {
            return this;
        }
        if (z == 0.0) {
            return ZERO;
        }
        return Complex.cart(this.re * z, this.im * z);
    }

    public Complex div(Complex b) {
        double dIm;
        double dRe;
        double bRe = b.re;
        double bIm = b.im;
        if (Math.abs(bRe) >= Math.abs(bIm)) {
            double scalar = 1.0 / (bRe + bIm * (bIm / bRe));
            dRe = scalar * (this.re + this.im * (bIm / bRe));
            dIm = scalar * (this.im - this.re * (bIm / bRe));
        } else {
            double scalar = 1.0 / (bRe * (bRe / bIm) + bIm);
            dRe = scalar * (this.re * (bRe / bIm) + this.im);
            dIm = scalar * (this.im * (bRe / bIm) - this.re);
        }
        return Complex.cart(dRe, dIm);
    }

    public Complex div(double z) {
        if (z == 1.0) {
            return this;
        }
        return Complex.cart(this.re / z, this.im / z);
    }

    public Complex inv() {
        double zIm;
        double zRe;
        if (Math.abs(this.re) >= Math.abs(this.im)) {
            double scalar;
            zRe = scalar = 1.0 / (this.re + this.im * (this.im / this.re));
            zIm = scalar * (-this.im / this.re);
        } else {
            double scalar = 1.0 / (this.re * (this.re / this.im) + this.im);
            zRe = scalar * (this.re / this.im);
            zIm = -scalar;
        }
        return Complex.cart(zRe, zIm);
    }

    @Override
    @Generated
    public double getRe() {
        return this.re;
    }

    @Override
    @Generated
    public double getIm() {
        return this.im;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Complex)) {
            return false;
        }
        Complex other = (Complex)o;
        if (Double.compare(this.getRe(), other.getRe()) != 0) {
            return false;
        }
        return Double.compare(this.getIm(), other.getIm()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $re = Double.doubleToLongBits(this.getRe());
        result = result * 59 + (int)($re >>> 32 ^ $re);
        long $im = Double.doubleToLongBits(this.getIm());
        result = result * 59 + (int)($im >>> 32 ^ $im);
        return result;
    }
}

