/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.series;

import java.awt.Color;
import org.knowm.xchart.internal.chartpart.RenderableSeries;

public abstract class Series {
    private final String name;
    private String label;
    private Color fillColor;
    private boolean showInLegend = true;
    private boolean isEnabled = true;
    private int yAxisGroup = 0;
    private String yAxisDecimalPattern;

    protected Series(String name) {
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException("Series name cannot be null or zero-length!!!");
        }
        this.name = name;
        this.label = name;
    }

    public abstract RenderableSeries.LegendRenderType getLegendRenderType();

    public Color getFillColor() {
        return this.fillColor;
    }

    public Series setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public Series setLabel(String label) {
        this.label = label;
        return this;
    }

    public boolean isShowInLegend() {
        return this.showInLegend;
    }

    public Series setShowInLegend(boolean showInLegend) {
        this.showInLegend = showInLegend;
        return this;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Series setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public int getYAxisGroup() {
        return this.yAxisGroup;
    }

    public Series setYAxisGroup(int yAxisGroup) {
        this.yAxisGroup = yAxisGroup;
        return this;
    }

    public String getYAxisDecimalPattern() {
        return this.yAxisDecimalPattern;
    }

    public Series setYAxisDecimalPattern(String yAxisDecimalPattern) {
        this.yAxisDecimalPattern = yAxisDecimalPattern;
        return this;
    }

    public static enum DataType {
        Number,
        Date,
        String;

    }
}

