/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;
import org.chocosolver.util.tools.ArrayUtils;
import org.chocosolver.util.tools.MathUtils;

public class PropSquare
extends Propagator<IntVar> {
    private final IntIterableBitSet vrms;
    private final boolean bothEnum;

    public PropSquare(IntVar X, IntVar Y) {
        super((Variable[])ArrayUtils.toArray(X, Y), (Priority)PropagatorPriority.BINARY, false);
        this.bothEnum = X.hasEnumeratedDomain() && Y.hasEnumeratedDomain();
        this.vrms = new IntIterableBitSet();
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return this.bothEnum ? IntEventType.all() : IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        do {
            this.setBounds();
        } while (this.updateHolesinX() | this.updateHolesinY());
        if (((IntVar[])this.vars)[1].isInstantiated()) {
            ((IntVar[])this.vars)[0].instantiateTo(PropSquare.sqr(((IntVar[])this.vars)[1].getValue()), (ICause)this);
        }
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].getUB() < 0) {
            return ESat.FALSE;
        }
        if (((IntVar[])this.vars)[0].isInstantiated()) {
            if (((IntVar[])this.vars)[1].isInstantiated()) {
                return ESat.eval(((IntVar[])this.vars)[0].getValue() == PropSquare.sqr(((IntVar[])this.vars)[1].getValue()));
            }
            if (((IntVar[])this.vars)[1].getDomainSize() == 2 && ((IntVar[])this.vars)[1].contains(-PropSquare.floor_sqrt(((IntVar[])this.vars)[0].getValue())) && ((IntVar[])this.vars)[1].contains(-PropSquare.floor_sqrt(((IntVar[])this.vars)[0].getValue()))) {
                return ESat.TRUE;
            }
            if (!((IntVar[])this.vars)[1].contains(PropSquare.floor_sqrt(((IntVar[])this.vars)[0].getValue())) && !((IntVar[])this.vars)[1].contains(-PropSquare.floor_sqrt(((IntVar[])this.vars)[0].getValue()))) {
                return ESat.FALSE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return String.format("%s = %s^2", ((IntVar[])this.vars)[0].toString(), ((IntVar[])this.vars)[1].toString());
    }

    private void setBounds() throws ContradictionException {
        this.updateLowerBoundofX();
        this.updateUpperBoundofX();
        if (this.updateLowerBoundofY() | this.updateUpperBoundofY()) {
            this.setBounds();
        }
    }

    private static int floor_sqrt(int n) {
        if (n < 0) {
            return 0;
        }
        return (int)Math.floor(Math.sqrt(n));
    }

    private static int ceil_sqrt(int n) {
        if (n < 0) {
            return 0;
        }
        return (int)Math.ceil(Math.sqrt(n));
    }

    private static int sqr(int n) {
        if (n > 0x3FFFFFFF || n < -1073741824) {
            return Integer.MAX_VALUE;
        }
        return n * n;
    }

    protected void updateLowerBoundofX() throws ContradictionException {
        int a0 = ((IntVar[])this.vars)[1].nextValue(-1);
        int b0 = Math.max(-2147483647, ((IntVar[])this.vars)[1].previousValue(1));
        ((IntVar[])this.vars)[0].updateLowerBound(Math.min(PropSquare.sqr(a0), PropSquare.sqr(b0)), (ICause)this);
    }

    protected void updateUpperBoundofX() throws ContradictionException {
        ((IntVar[])this.vars)[0].updateUpperBound(Math.max(PropSquare.sqr(((IntVar[])this.vars)[1].getLB()), PropSquare.sqr(((IntVar[])this.vars)[1].getUB())), (ICause)this);
    }

    protected boolean updateHolesinX() throws ContradictionException {
        if (this.bothEnum) {
            int ub = ((IntVar[])this.vars)[0].getUB();
            this.vrms.clear();
            this.vrms.setOffset(((IntVar[])this.vars)[0].getLB());
            int value = ((IntVar[])this.vars)[0].getLB();
            while (value <= ub) {
                if (!MathUtils.isPerfectSquare(value) || !((IntVar[])this.vars)[1].contains(PropSquare.floor_sqrt(value)) && !((IntVar[])this.vars)[1].contains(-PropSquare.floor_sqrt(value))) {
                    this.vrms.add(value);
                }
                value = ((IntVar[])this.vars)[0].nextValue(value);
            }
            return ((IntVar[])this.vars)[0].removeValues(this.vrms, this);
        }
        if (((IntVar[])this.vars)[0].hasEnumeratedDomain()) {
            int value = ((IntVar[])this.vars)[0].getLB();
            int nlb = value - 1;
            while (nlb == value - 1) {
                if (!((IntVar[])this.vars)[1].contains(PropSquare.floor_sqrt(value)) && !((IntVar[])this.vars)[1].contains(-PropSquare.floor_sqrt(value))) {
                    nlb = value;
                }
                value = ((IntVar[])this.vars)[0].nextValue(value);
            }
            boolean filter = ((IntVar[])this.vars)[0].updateLowerBound(nlb, (ICause)this);
            value = ((IntVar[])this.vars)[0].getUB();
            int nub = value + 1;
            while (nub == value + 1) {
                if (!((IntVar[])this.vars)[1].contains(PropSquare.floor_sqrt(value)) && !((IntVar[])this.vars)[1].contains(-PropSquare.floor_sqrt(value))) {
                    nub = value;
                }
                value = ((IntVar[])this.vars)[0].previousValue(value);
            }
            return filter | ((IntVar[])this.vars)[0].updateUpperBound(nub, (ICause)this);
        }
        return false;
    }

    protected boolean updateLowerBoundofY() throws ContradictionException {
        return ((IntVar[])this.vars)[1].updateLowerBound(-PropSquare.ceil_sqrt(((IntVar[])this.vars)[0].getUB()), (ICause)this);
    }

    protected boolean updateUpperBoundofY() throws ContradictionException {
        return ((IntVar[])this.vars)[1].updateUpperBound(PropSquare.floor_sqrt(((IntVar[])this.vars)[0].getUB()), (ICause)this);
    }

    protected boolean updateHolesinY() throws ContradictionException {
        if (this.bothEnum) {
            int ub = ((IntVar[])this.vars)[1].getUB();
            this.vrms.clear();
            this.vrms.setOffset(((IntVar[])this.vars)[1].getLB());
            int value = ((IntVar[])this.vars)[1].getLB();
            while (value <= ub) {
                if (!((IntVar[])this.vars)[0].contains(PropSquare.sqr(value))) {
                    this.vrms.add(value);
                }
                value = ((IntVar[])this.vars)[1].nextValue(value);
            }
            return ((IntVar[])this.vars)[1].removeValues(this.vrms, this);
        }
        if (((IntVar[])this.vars)[1].hasEnumeratedDomain()) {
            int lb = ((IntVar[])this.vars)[1].getLB();
            int ub = ((IntVar[])this.vars)[1].getUB();
            while (!((IntVar[])this.vars)[0].contains(PropSquare.sqr(lb)) && (lb = ((IntVar[])this.vars)[1].nextValue(lb)) <= ub) {
            }
            boolean filter = ((IntVar[])this.vars)[1].updateLowerBound(lb, (ICause)this);
            while (!((IntVar[])this.vars)[0].contains(PropSquare.sqr(ub)) && (ub = ((IntVar[])this.vars)[1].nextValue(ub)) >= lb) {
            }
            return filter | ((IntVar[])this.vars)[1].updateUpperBound(ub, (ICause)this);
        }
        return false;
    }
}

