/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.stereo.AbstractStereo;

public final class SquarePlanar
extends AbstractStereo<IAtom, IAtom> {
    private static final int[][] PERMUTATIONS = new int[][]{{0, 1, 2, 3, 0, 3, 2, 1, 1, 2, 3, 0, 1, 0, 3, 2, 2, 3, 0, 1, 2, 1, 0, 3, 3, 2, 1, 0, 3, 0, 1, 2}, {0, 2, 1, 3, 0, 3, 1, 2, 1, 3, 0, 2, 1, 2, 0, 3, 2, 0, 3, 1, 2, 1, 3, 0, 3, 1, 2, 0, 3, 0, 2, 1}, {0, 1, 3, 2, 0, 2, 3, 1, 1, 0, 2, 3, 1, 3, 2, 0, 2, 3, 1, 0, 2, 0, 1, 3, 3, 2, 0, 1, 3, 1, 0, 2}};

    public SquarePlanar(IAtom focus, IAtom[] carriers, int order) {
        super((IChemObject)focus, (IChemObject[])carriers, 0x4500 | order & 0xFF);
        if (this.getConfigOrder() < 0 || this.getConfigOrder() > 3) {
            throw new IllegalArgumentException("Invalid configuration order,should be between 1-3");
        }
    }

    public SquarePlanar normalize() {
        int cfg = this.getConfigOrder();
        if (cfg == 1) {
            return this;
        }
        IAtom[] carriers = SquarePlanar.invapply(this.getCarriers().toArray(new IAtom[4]), PERMUTATIONS[cfg - 1]);
        return new SquarePlanar((IAtom)this.getFocus(), carriers, 17665);
    }

    protected SquarePlanar create(IAtom focus, List<IAtom> carriers, int cfg) {
        return new SquarePlanar(focus, carriers.toArray(new IAtom[4]), cfg);
    }
}

