## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, eval=TRUE---------------------------------------------------------
library(mindr)

## -----------------------------------------------------------------------------
input <- system.file('examples/mindr-md.Rmd', package = 'mindr')
input_txt <- readLines(input, encoding = 'UTF-8')
mm_output <- mm(input_txt, output_type = c('mindmap', 'markdown', 'R', 'widget', 'mermaid'))

## -----------------------------------------------------------------------------
mm_output$markdown

## ----eval=FALSE---------------------------------------------------------------
# output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".mm")
# writeLines(mm_output$mindmap, output, useBytes = TRUE)
# file.show(output) # Open the output file with the default program, if any

## ----eval=FALSE---------------------------------------------------------------
# cat(mm_output$mermaid, sep = '\n')

## ----eval=FALSE---------------------------------------------------------------
# output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".R")
# writeLines(mm_output$r, output, useBytes = TRUE)

## -----------------------------------------------------------------------------
mm_output$widget
# output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".html")
# htmlwidgets::saveWidget(mm_output$widget, file = output)

## ----eval=FALSE---------------------------------------------------------------
# temp_dir <- file.path(tempdir(), 'mindr')
# mm_output <- mm(input_txt, output_type = 'dir', root = 'mindr',
#                 md_list = TRUE, md_braces = TRUE, md_bookdown = TRUE,
#                 dir_to = temp_dir)
# system2('open', temp_dir) # Open the generated directory

## ----eval=FALSE---------------------------------------------------------------
# ## Source document ####
# input <- system.file('examples/mindr-mm.mm', package = 'mindr')
# 
# ## file.show(input) # Open the input file with the default program, if any
# input_txt <- readLines(input, encoding = 'UTF-8')
# 
# ## Convert markdown outline, R script, and HTML widget ####
# mm_output <- mm(input_txt, output_type = c('markdown', 'R', 'widget'))
# mm_output
# 
# ## Save the output texts as files ####
# 
# ### markdown outline ####
# output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".md")
# writeLines(mm_output$markdown, output, useBytes = TRUE)
# # file.show(output) # Open the output file with the default program
# message('Input:  ', input, '\nOutput: ', output)
# # file.remove(output) # remove the output file
# 
# ### R script ####
# output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".R")
# writeLines(mm_output$r, output, useBytes = TRUE)
# # file.show(output) # Open the output file with the default program
# message('Input:  ', input, '\nOutput: ', output)
# # file.remove(output) # remove the output file
# 
# ### Widget ####
# # output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".html")
# # htmlwidgets::saveWidget(mm_output$widget, file = output)
# # file.show(output) # Open the output file with the default program, if any
# # message('Input:  ', input, '\nOutput: ', output)
# # file.remove(output) # remove the output file
# 
# ## Generate directory according to the source document ####
# temp_dir <- file.path(tempdir(), 'mindr')
# mm_output <- mm(input_txt, output_type = 'dir', root = 'mindr',
#                 dir_to = temp_dir)
# # system2('open', temp_dir) # Open the generatecd directory
# # unlink(temp_dir, recursive = TRUE) # remove the generated directory

## ----eval=FALSE---------------------------------------------------------------
# ## Source document ####
# input <- system.file('examples/mindr-r.R', package = 'mindr')
# 
# ## file.show(input) # Open the input file with the default program, if any
# input_txt <- readLines(input, encoding = 'UTF-8')
# 
# ## Convert to mind map text, markdown text,  and HTML widget ####
# mm_output <- mm(input_txt, output_type = c('mindmap', 'markdown',  'widget'))
# mm_output
# 
# ## Save the output texts as files ####
# 
# ### mind map ####
# output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".mm")
# writeLines(mm_output$mindmap, output, useBytes = TRUE)
# # file.show(output) # Open the output file with the default program, if any
# message('Input:  ', input, '\nOutput: ', output)
# # file.remove(output) # remove the output file
# 
# ### R markdown ####
# output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".Rmd")
# writeLines(mm_output$markdown, output, useBytes = TRUE)
# # file.show(output) # Open the output file with the default program, if any
# message('Input:  ', input, '\nOutput: ', output)
# # file.remove(output) # remove the output file
# 
# ### Widget ####
# # output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".html")
# # htmlwidgets::saveWidget(mm_output$widget, file = output)
# # file.show(output) # Open the output file with the default program, if any
# # message('Input:  ', input, '\nOutput: ', output)
# # file.remove(output) # remove the output file
# 
# ## Generate directory according to the source document ####
# temp_dir <- file.path(tempdir(), 'mindr')
# mm_output <- mm(input_txt, output_type = 'dir', root = 'mindr',
#                 dir_to = temp_dir)
# # system2('open', temp_dir) # Open the generated directory
# # unlink(temp_dir, recursive = TRUE) # remove the generated directory

## ----eval=FALSE---------------------------------------------------------------
# ## Source directory ####
# input <- system.file(package = 'mindr')
# 
# ## Convert to mind map text, markdown outline, R script, and HTML widget ####
# mm_output <- mm(input, output_type = c('mindmap', 'markdown', 'R', 'widget'))
# mm_output
# 
# ## Save the output texts as files ####
# 
# ### mind map ####
# output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".mm")
# writeLines(mm_output$mindmap, output, useBytes = TRUE)
# # file.show(output) # Open the output file with the default program, if any
# message('Input:  ', input, '\nOutput: ', output)
# # file.remove(output) # remove the output file
# 
# ### markdown outline ####
# output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".md")
# writeLines(mm_output$markdown, output, useBytes = TRUE)
# # file.show(output) # Open the output file with the default program, if any
# message('Input:  ', input, '\nOutput: ', output)
# # file.remove(output) # remove the output file
# 
# ### R script ####
# output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".R")
# writeLines(mm_output$r, output, useBytes = TRUE)
# # file.show(output) # Open the output file with the default program, if any
# message('Input:  ', input, '\nOutput: ', output)
# # file.remove(output) # remove the output file
# 
# ### Widget ####
# # output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".html")
# # htmlwidgets::saveWidget(mm_output$widget, file = output)
# # file.show(output) # Open the output file with the default program, if any
# # message('Input:  ', input, '\nOutput: ', output)
# # file.remove(output) # remove the output file
# 
# ## Clone the source directory ####
# temp_dir <- file.path(tempdir(), 'mindr')
# mm_output <- mm(input, output_type = 'dir',
#                 dir_to = temp_dir)
# # system2('open', temp_dir) # Open the generated directory
# # unlink(temp_dir, recursive = TRUE) # remove the generated directory

## ----eval=FALSE---------------------------------------------------------------
# # HTML: here we use the R-FQA webpage
# myurl <- 'https://cran.r-project.org/doc/FAQ/R-FAQ.html'
# input <- tempfile(pattern = "file", tmpdir = tempdir())
# markdown_temp <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".md")
# download.file(myurl, destfile = input, method = 'curl')
# rmarkdown::pandoc_convert(input, from = 'html', to = "markdown", output = markdown_temp)
# input_txt <- readLines(markdown_temp, encoding = 'UTF-8')
# mindr::mm(input_txt)
# 
# # MS Word: here we use a .docx document shipped by the 'officer' package
# input <- system.file('doc_examples/example.docx', package = 'officer')
# markdown_temp <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".md")
# rmarkdown::pandoc_convert(input, to = "markdown", output = markdown_temp)
# input_txt <- readLines(markdown_temp, encoding = 'UTF-8')
# mindr::mm(input_txt, md_list = TRUE)
# 
# # pdf: here we use the pdf files in the R installation
# input <- file.path(R.home(), 'doc/manual/R-intro.pdf')
# mmm(input)
# input <- file.path(R.home(), 'doc/manual/R-data.pdf')
# mmm(input, root = 'R-data', md_maxlevel = 2)
# 
# # MS Word: here we use a .docx document shipped by the 'officer' package
# input <- system.file('doc_examples/example.docx', package = 'officer')
# mmm(input)
# 
# # HTML: here we use the R-FQA webpage
# input <- file.path(R.home(), 'doc/html/rw-FAQ.html')
# mmm(input)

## ----eval=FALSE---------------------------------------------------------------
# mdheadings <- c(
#   '# Heading 1',
#   '## Heading 1.1',
#   '## Heading 1.2',
#   '## Heading 1.3',
#   '# Heading 2',
#   '## Heading 2.1',
#   '## Heading 2.2',
#   '## Heading 2.3'
# )
# mmd <- mindr::mm(from = mdheadings,
#                  input_type = 'markdown', output_type = 'mermaid',
#                  mmd_shape = c('round', 'cloud'),
#                  root = 'Demo')
# cat(mmd$mermaid, sep = '\n')

## ----eval=FALSE---------------------------------------------------------------
# mmd <- mindr::mm(from = mdheadings,
#                  input_type = 'markdown', output_type = 'mermaid',
#                  root = 'Demo')
# cat(mmd$mermaid, sep = '\n')

## ----eval=FALSE---------------------------------------------------------------
# myurl <- 'https://yihui.org/litedown/index.html'
# temphtml <- tempfile(pattern = "file", tmpdir = tempdir())
# tempmd <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".md")
# download.file(myurl, destfile = temphtml, method = 'curl')
# rmarkdown::pandoc_convert(temphtml, from = 'html', to = "markdown", output = tempmd)
# input_txt <- readLines(tempmd, encoding = 'UTF-8')
# file.remove(temphtml, tempmd)
# headings <- mindr::outline(input_txt[-c(1:(grep('^# Preface', input_txt) - 1))], md_maxlevel = 2, md_braces = TRUE, md_bookdown = TRUE)
# headings <- gsub('^([#]+) .*\\}([^\\}]+) \\{.*\\}$', '\\1\\2', headings)
# headings[(grep('# Appendix', headings) + 1) : length(headings)] <- paste0('#', headings[(grep('# Appendix', headings) + 1) : length(headings)])
# mmd <- mindr::mm(from = headings, input_type = 'markdown', output_type = 'mermaid', root = 'litedown')
# 
# cat(mmd$mermaid, sep = '\n')

## ----eval=FALSE---------------------------------------------------------------
# pdffile <- 'my-demo.pdf'
# mmd <- mindr::mmm(input_file = pdffile, output_type = 'mermaid')
# cat(mmd$mermaid, sep = '\n')
# 
# mmd <- mindr::mmm(input_file = pdffile, output_type = 'mermaid', md_maxlevel = 2)
# cat(mmd$mermaid, sep = '\n')
# 
# mmd <- mindr::mmm(input_file = pdffile, output_type = 'mermaid', md_maxlevel = 1, mmd_shape = 'bang')
# cat(mmd$mermaid, sep = '\n')

## ----eval=FALSE---------------------------------------------------------------
# infile <- 'my-demo.docx'
# mmd <- mindr::mmm(input_file = infile, output_type = 'mermaid')
# cat(mmd$mermaid, sep = '\n')

