/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IIndividual;
import net.sf.jclec.ISystem;
import net.sf.jclec.base.DecoratedMutator;
import net.sf.jclec.util.random.IRandGen;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredMutator<I extends IIndividual>
extends DecoratedMutator<I> {
    private static final long serialVersionUID = 6949238978074907056L;
    protected double mutProb;
    protected IRandGen randgen;
    protected transient List<I> fertile = new ArrayList<I>();
    protected transient List<I> sterile = new ArrayList<I>();

    public FilteredMutator() {
    }

    public FilteredMutator(ISystem<I> context) {
        this.contextualize(context);
    }

    public final double getMutProb() {
        return this.mutProb;
    }

    public final void setMutProb(double mutProb) {
        this.mutProb = mutProb;
    }

    @Override
    public void contextualize(ISystem<I> context) {
        super.contextualize(context);
        this.randgen = context.createRandGen();
    }

    @Override
    public List<I> mutate(List<I> parents) {
        this.fertile.clear();
        this.sterile.clear();
        for (IIndividual ind : parents) {
            if (this.randgen.coin(this.mutProb)) {
                this.fertile.add(ind);
                continue;
            }
            this.sterile.add(ind);
        }
        return this.decorated.mutate(this.fertile);
    }

    public List<I> getSterile() {
        return this.sterile;
    }

    public List<I> getFertile() {
        return this.fertile;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        double mutProb = settings.getDouble("mutation-prob", 0.05);
        this.setMutProb(mutProb);
    }

    public boolean equals(Object other) {
        if (other instanceof FilteredMutator) {
            FilteredMutator o = (FilteredMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.decorated, o.decorated);
            eb.append(this.mutProb, o.mutProb);
            return eb.isEquals();
        }
        return false;
    }
}

