/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.DE;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class DEGenerator
extends PrototypeGenerator {
    private int k;
    private int PopulationSize;
    private int ParticleSize;
    private int MaxIter;
    private double ScalingFactor;
    private double CrossOverRate;
    private int Strategy;
    private String CrossoverType;
    protected int numberOfClass;
    protected int numberOfPrototypes;
    private String[] paramsOfInitialReducction = null;

    public DEGenerator(PrototypeSet _trainingDataSet, int neigbors, int poblacion, int perc, int iteraciones, double F, double CR, int strg) {
        super(_trainingDataSet);
        this.algorithmName = "DE";
        this.k = neigbors;
        this.PopulationSize = poblacion;
        this.ParticleSize = perc;
        this.MaxIter = iteraciones;
        this.numberOfPrototypes = this.getSetSizeFromPercentage(perc);
        this.ScalingFactor = F;
        this.CrossOverRate = CR;
        this.Strategy = strg;
    }

    public DEGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "DE";
        this.k = parameters.getNextAsInt();
        this.PopulationSize = parameters.getNextAsInt();
        this.ParticleSize = parameters.getNextAsInt();
        this.MaxIter = parameters.getNextAsInt();
        this.ScalingFactor = parameters.getNextAsDouble();
        this.CrossOverRate = parameters.getNextAsDouble();
        this.Strategy = parameters.getNextAsInt();
        this.CrossoverType = parameters.getNextAsString();
        this.numberOfPrototypes = this.getSetSizeFromPercentage(this.ParticleSize);
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        System.out.print("\nIsaac dice:  " + this.k + " Swar= " + this.PopulationSize + " Particle=  " + this.ParticleSize + " Maxiter= " + this.MaxIter + " CR=  " + this.CrossOverRate + " CrossverType = " + this.CrossoverType + "\n");
    }

    public PrototypeSet mutant(PrototypeSet[] population, int actual, int mejor) {
        PrototypeSet mutant = new PrototypeSet(population.length);
        int[] lista = new int[population.length];
        this.inic_vector_sin(lista, actual);
        this.desordenar_vector_sin(lista);
        PrototypeSet r1 = population[lista[0]];
        PrototypeSet r2 = population[lista[1]];
        PrototypeSet r3 = population[lista[2]];
        PrototypeSet r4 = population[lista[3]];
        PrototypeSet r5 = population[lista[4]];
        switch (this.Strategy) {
            case 1: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                mutant = producto.sumar(resta);
                break;
            }
            case 2: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                mutant = population[mejor].sumar(producto);
                break;
            }
            case 3: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = population[mejor].restar(population[actual]);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet result = population[actual].sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 4: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = r3.restar(r4);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet result = population[mejor].sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 5: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet resta2 = r4.restar(r5);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet result = r1.sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 6: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = r3.restar(r4);
                PrototypeSet resta3 = population[mejor].restar(population[actual]);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet producto3 = resta3.mulEscalar(this.ScalingFactor);
                PrototypeSet result = population[actual].sumar(producto);
                result = result.sumar(producto2);
                mutant = result.sumar(producto3);
            }
        }
        mutant.applyThresholds();
        return mutant;
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet nominalPopulation;
        int j;
        int i;
        System.out.print("\nThe algorithm  DE is starting...\n Computing...\n");
        System.out.println("Number of prototypes, result set = " + this.numberOfPrototypes + "\n");
        if (this.numberOfPrototypes < this.trainingDataSet.getPosibleValuesOfOutput().size()) {
            System.out.println("Number of prototypes less than the number of clases");
            this.numberOfPrototypes = this.trainingDataSet.getPosibleValuesOfOutput().size();
        }
        PrototypeSet[] population = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] mutation = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] crossover = new PrototypeSet[this.PopulationSize];
        double[] fitness = new double[this.PopulationSize];
        double[] fitness_bestPopulation = new double[this.PopulationSize];
        PrototypeSet bestParticle = new PrototypeSet();
        population[0] = this.selecRandomSet(this.numberOfPrototypes, true).clone();
        PrototypeSet[] clases = new PrototypeSet[this.numberOfClass];
        for (i = 0; i < this.numberOfClass; ++i) {
            clases[i] = new PrototypeSet(this.trainingDataSet.getFromClass(i));
        }
        for (i = 0; i < population[0].size(); ++i) {
            for (j = 0; j < this.numberOfClass; ++j) {
                if (population[0].getFromClass(j).size() != 0 || clases[j].size() == 0) continue;
                population[0].add(clases[j].getRandom());
            }
        }
        fitness[0] = DEGenerator.accuracy(population[0], this.trainingDataSet);
        for (i = 1; i < this.PopulationSize; ++i) {
            population[i] = new PrototypeSet();
            for (j = 0; j < population[0].size(); ++j) {
                population[i].add(this.trainingDataSet.getFromClass(((Prototype)population[0].get(j)).getOutput(0)).getRandom());
            }
            fitness[i] = DEGenerator.accuracy(population[i], this.trainingDataSet);
        }
        double bestFitness = fitness[0];
        int bestFitnessIndex = 0;
        for (int i2 = 1; i2 < this.PopulationSize; ++i2) {
            if (!(fitness[i2] > bestFitness)) continue;
            bestFitness = fitness[i2];
            bestFitnessIndex = i2;
        }
        for (int j2 = 0; j2 < this.PopulationSize; ++j2) {
            for (int i3 = 0; i3 < population[j2].size(); ++i3) {
                ((Prototype)population[j2].get(i3)).setIndex(i3);
            }
        }
        boolean[] cruceExp = new boolean[this.PopulationSize];
        for (int iter = 0; iter < this.MaxIter; ++iter) {
            int i4;
            if (this.CrossoverType.equals("Exponential")) {
                for (i4 = 0; i4 < this.PopulationSize; ++i4) {
                    cruceExp[i4] = false;
                }
            }
            for (i4 = 0; i4 < this.PopulationSize; ++i4) {
                mutation[i4] = new PrototypeSet(population[i4].size());
                mutation[i4] = this.mutant(population, i4, bestFitnessIndex).clone();
                crossover[i4] = new PrototypeSet(population[i4]);
                for (int j3 = 0; j3 < population[i4].size(); ++j3) {
                    if (this.CrossoverType.equals("Binomial")) {
                        double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
                        if (!(randNumber < this.CrossOverRate)) continue;
                        crossover[i4].set(j3, mutation[i4].get(j3));
                        continue;
                    }
                    if (this.CrossoverType.equals("Exponential")) {
                        int startingPoint = RandomGenerator.Randint(0, this.PopulationSize);
                        int L = 0;
                        while (RandomGenerator.Randdouble(0.0, 1.0) < this.CrossOverRate && ++L < population[i4].size()) {
                        }
                        for (int m = startingPoint; m < startingPoint + L; ++m) {
                            crossover[i4].set(m % population[i4].size(), mutation[i4].get(j3));
                        }
                        continue;
                    }
                    if (this.CrossoverType.equals("Arithmetic")) {
                        PrototypeSet resta = mutation[i4].restar(population[i4]);
                        crossover[i4] = population[i4].sumar(resta.mulEscalar(RandomGenerator.Randdouble(0.0, 1.0)));
                        continue;
                    }
                    System.err.println("ERROR, Crossover Type incorrect.");
                }
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(population[i4]);
                fitness[i4] = DEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(crossover[i4]);
                double trialVector = DEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
                if (trialVector > fitness[i4]) {
                    population[i4] = new PrototypeSet(crossover[i4]);
                    fitness[i4] = trialVector;
                }
                if (!(fitness[i4] > bestFitness)) continue;
                bestFitness = fitness[i4];
                bestFitnessIndex = i4;
                System.out.println("Iter=" + iter + " Acc= " + bestFitness);
            }
        }
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(population[bestFitnessIndex]);
        System.err.println("\n% de acierto en training Nominal " + (double)KNN.classficationAccuracy(nominalPopulation, this.trainingDataSet, 1) * 100.0 / (double)this.trainingDataSet.size());
        return nominalPopulation;
    }

    public static void main(String[] args) {
        Parameters.setUse("DE", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        DEGenerator.setSeed(seed);
        int k = Parameters.assertExtendedArgAsInt(args, 3, "number of neighbors", 1.0, 2.147483647E9);
        int swarm = Parameters.assertExtendedArgAsInt(args, 4, "swarm size", 1.0, 2.147483647E9);
        int particle = Parameters.assertExtendedArgAsInt(args, 5, "particle size", 1.0, 2.147483647E9);
        int iter = Parameters.assertExtendedArgAsInt(args, 6, "max iter", 1.0, 2.147483647E9);
        double c1 = Parameters.assertExtendedArgAsInt(args, 7, "c1", 1.0, Double.MAX_VALUE);
        double c2 = Parameters.assertExtendedArgAsInt(args, 8, "c2", 1.0, Double.MAX_VALUE);
        double vmax = Parameters.assertExtendedArgAsInt(args, 9, "vmax", 1.0, Double.MAX_VALUE);
        double wstart = Parameters.assertExtendedArgAsInt(args, 10, "wstart", 1.0, Double.MAX_VALUE);
        double wend = Parameters.assertExtendedArgAsInt(args, 11, "wend", 1.0, Double.MAX_VALUE);
        DEGenerator generator = new DEGenerator(training, k, swarm, particle, iter, 0.5, 0.5, 1);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

