/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import keel.Algorithms.Decision_Trees.M5.Distributions;
import keel.Algorithms.Decision_Trees.M5.M5StaticUtils;

public class M5Kernel {
    private double[] m_Values = new double[50];
    private double[] m_Weights = new double[50];
    private int m_NumValues = 0;
    private double m_SumOfWeights = 0.0;
    private double m_StandardDev;
    private double m_Precision;
    private boolean m_AllWeightsOne = true;
    private static double MAX_ERROR = 0.01;

    private int findNearestValue(double key) {
        int low = 0;
        int high = this.m_NumValues;
        int middle = 0;
        while (low < high) {
            middle = (low + high) / 2;
            double current = this.m_Values[middle];
            if (current == key) {
                return middle;
            }
            if (current > key) {
                high = middle;
                continue;
            }
            if (!(current < key)) continue;
            low = middle + 1;
        }
        return low;
    }

    private double round(double data) {
        return Math.rint(data / this.m_Precision) * this.m_Precision;
    }

    public M5Kernel(double precision) {
        this.m_Precision = precision;
        this.m_StandardDev = this.m_Precision / 6.0;
    }

    public void addValue(double data, double weight) {
        if (weight == 0.0) {
            return;
        }
        int insertIndex = this.findNearestValue(data = this.round(data));
        if (this.m_NumValues <= insertIndex || this.m_Values[insertIndex] != data) {
            if (this.m_NumValues < this.m_Values.length) {
                int left = this.m_NumValues - insertIndex;
                System.arraycopy(this.m_Values, insertIndex, this.m_Values, insertIndex + 1, left);
                System.arraycopy(this.m_Weights, insertIndex, this.m_Weights, insertIndex + 1, left);
                this.m_Values[insertIndex] = data;
                this.m_Weights[insertIndex] = weight;
                ++this.m_NumValues;
            } else {
                double[] newValues = new double[this.m_Values.length * 2];
                double[] newWeights = new double[this.m_Values.length * 2];
                int left = this.m_NumValues - insertIndex;
                System.arraycopy(this.m_Values, 0, newValues, 0, insertIndex);
                System.arraycopy(this.m_Weights, 0, newWeights, 0, insertIndex);
                newValues[insertIndex] = data;
                newWeights[insertIndex] = weight;
                System.arraycopy(this.m_Values, insertIndex, newValues, insertIndex + 1, left);
                System.arraycopy(this.m_Weights, insertIndex, newWeights, insertIndex + 1, left);
                ++this.m_NumValues;
                this.m_Values = newValues;
                this.m_Weights = newWeights;
            }
            if (weight != 1.0) {
                this.m_AllWeightsOne = false;
            }
        } else {
            int n = insertIndex;
            this.m_Weights[n] = this.m_Weights[n] + weight;
            this.m_AllWeightsOne = false;
        }
        this.m_SumOfWeights += weight;
        double range = this.m_Values[this.m_NumValues - 1] - this.m_Values[0];
        if (range > 0.0) {
            this.m_StandardDev = Math.max(range / Math.sqrt(this.m_SumOfWeights), this.m_Precision / 6.0);
        }
    }

    public double getProbability(double data) {
        int start;
        int i;
        double delta = 0.0;
        double sum = 0.0;
        double currentProb = 0.0;
        double zLower = 0.0;
        double zUpper = 0.0;
        if (this.m_NumValues == 0) {
            zLower = (data - this.m_Precision / 2.0) / this.m_StandardDev;
            zUpper = (data + this.m_Precision / 2.0) / this.m_StandardDev;
            return Distributions.normalProbability(zUpper) - Distributions.normalProbability(zLower);
        }
        double weightSum = 0.0;
        for (i = start = this.findNearestValue(data); i < this.m_NumValues; ++i) {
            delta = this.m_Values[i] - data;
            zLower = (delta - this.m_Precision / 2.0) / this.m_StandardDev;
            zUpper = (delta + this.m_Precision / 2.0) / this.m_StandardDev;
            currentProb = Distributions.normalProbability(zUpper) - Distributions.normalProbability(zLower);
            if (currentProb * (this.m_SumOfWeights - (weightSum += this.m_Weights[i])) < (sum += currentProb * this.m_Weights[i]) * MAX_ERROR) break;
        }
        for (i = start - 1; i >= 0; --i) {
            delta = this.m_Values[i] - data;
            zLower = (delta - this.m_Precision / 2.0) / this.m_StandardDev;
            zUpper = (delta + this.m_Precision / 2.0) / this.m_StandardDev;
            currentProb = Distributions.normalProbability(zUpper) - Distributions.normalProbability(zLower);
            if (currentProb * (this.m_SumOfWeights - (weightSum += this.m_Weights[i])) < (sum += currentProb * this.m_Weights[i]) * MAX_ERROR) break;
        }
        return sum / this.m_SumOfWeights;
    }

    public String toString() {
        String result = this.m_NumValues + " Normal Kernels. \nStandardDev = " + M5StaticUtils.doubleToString(this.m_StandardDev, 6, 4) + " Precision = " + this.m_Precision;
        if (this.m_NumValues == 0) {
            result = result + "  \nMean = 0";
        } else {
            int i;
            result = result + "  \nMeans =";
            for (i = 0; i < this.m_NumValues; ++i) {
                result = result + " " + this.m_Values[i];
            }
            if (!this.m_AllWeightsOne) {
                result = result + "\nWeights = ";
                for (i = 0; i < this.m_NumValues; ++i) {
                    result = result + " " + this.m_Weights[i];
                }
            }
        }
        return result + "\n";
    }

    public static void main(String[] argv) {
        try {
            if (argv.length < 2) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            M5Kernel newEst = new M5Kernel(0.01);
            for (int i = 0; i < argv.length - 3; i += 2) {
                newEst.addValue(Double.valueOf(argv[i]), Double.valueOf(argv[i + 1]));
            }
            System.out.println(newEst);
            double start = Double.valueOf(argv[argv.length - 2]);
            double finish = Double.valueOf(argv[argv.length - 1]);
            for (double current = start; current < finish; current += (finish - start) / 50.0) {
                System.out.println("Data: " + current + " " + newEst.getProbability(current));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

