/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Apriori;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Apriori.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Apriori.Item;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Apriori.myDataset;

public class AprioriProcess {
    private double minSupport;
    private double minConfidence;
    private myDataset dataset;
    private int nAttr;
    private int nTrans;
    private int pass;
    private int[][] transactions;
    private Item root;
    private int nFrequentItemsets;
    private int nCoveredRecords;

    public AprioriProcess(myDataset dataset, double minSupport, double minConfidence) {
        this.minSupport = minSupport;
        this.minConfidence = minConfidence;
        this.dataset = dataset;
        this.nAttr = dataset.getnVars();
        this.nTrans = dataset.getnTrans();
        this.pass = 1;
        this.transactions = dataset.getFakeTransactions();
        this.root = new Item(-1);
    }

    public void run() {
        int candidates = this.generateFirstCandidates();
        int pruned = this.checkMinSupport(this.root);
        this.nFrequentItemsets = candidates - pruned;
        System.out.println("\nPass: " + this.pass + "; Candidate Itemsets: " + candidates + "; Pruned Itemsets: " + pruned + "; Total Frequent Itemsets: " + this.nFrequentItemsets);
        while (candidates - pruned > 1 && this.pass < this.nAttr) {
            ++this.pass;
            candidates = this.generateCandidates(this.root, new ArrayList<Item>(), 1);
            this.countSupport();
            pruned = this.checkMinSupport(this.root);
            this.nFrequentItemsets += candidates - pruned;
            System.out.println("Pass: " + this.pass + "; Candidate Itemsets: " + candidates + "; Pruned Itemsets: " + pruned + "; Total Frequent Itemsets: " + this.nFrequentItemsets);
        }
    }

    public ArrayList<AssociationRule> generateRulesSet() {
        ArrayList<AssociationRule> rules = new ArrayList<AssociationRule>();
        HashSet<Integer> covered_records = new HashSet<Integer>();
        this.generateRules(this.root, new ArrayList<Item>(), rules, covered_records);
        this.nCoveredRecords = covered_records.size();
        return rules;
    }

    public void printReport(ArrayList<AssociationRule> rules) {
        double avg_sup = 0.0;
        double avg_yulesQ = 0.0;
        double avg_conf = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        double avg_ant_length = 0.0;
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule ar = rules.get(r);
            avg_sup += ar.getRuleSupport();
            avg_conf += ar.getConfidence();
            avg_lift += ar.getLift();
            avg_conv += ar.getConv();
            avg_CF += ar.getCF();
            avg_netConf += ar.getNetConf();
            avg_yulesQ += ar.getYulesQ();
            avg_ant_length += (double)(ar.getAntecedent().size() + ar.getConsequent().size());
        }
        System.out.println("\nNumber of Frequent Itemsets found: " + this.nFrequentItemsets);
        System.out.println("Number of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            System.out.println("Average Support: " + AprioriProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            System.out.println("Average Confidence: " + AprioriProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            System.out.println("Average Lift: " + AprioriProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            System.out.println("Average Conviction: " + AprioriProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            System.out.println("Average Certain Factor: " + AprioriProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            System.out.println("Average Netconf: " + AprioriProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            System.out.println("Average YulesQ: " + AprioriProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            System.out.println("Average Number of Antecedents: " + AprioriProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            System.out.println("Number of Covered Records (%): " + AprioriProcess.roundDouble(100.0 * (double)this.nCoveredRecords / (double)this.nTrans, 2));
        }
    }

    public void saveReport(ArrayList<AssociationRule> rules, PrintWriter w) {
        double avg_sup = 0.0;
        double avg_yulesQ = 0.0;
        double avg_conf = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        double avg_ant_length = 0.0;
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule ar = rules.get(r);
            avg_sup += ar.getRuleSupport();
            avg_conf += ar.getConfidence();
            avg_lift += ar.getLift();
            avg_conv += ar.getConv();
            avg_CF += ar.getCF();
            avg_netConf += ar.getNetConf();
            avg_yulesQ += ar.getYulesQ();
            avg_ant_length += (double)(ar.getAntecedent().size() + ar.getConsequent().size());
        }
        w.println("\nNumber of Frequent Itemsets found: " + this.nFrequentItemsets);
        System.out.println("\nNumber of Frequent Itemsets found: " + this.nFrequentItemsets);
        w.println("\nNumber of Association Rules generated: " + rules.size());
        System.out.println("Number of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            w.println("Average Support: " + AprioriProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            System.out.println("Average Support: " + AprioriProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            w.println("Average Confidence: " + AprioriProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            System.out.println("Average Confidence: " + AprioriProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            w.println("Average Lift: " + AprioriProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            System.out.println("Average Lift: " + AprioriProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            w.println("Average Conviction: " + AprioriProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            System.out.println("Average Conviction: " + AprioriProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            w.println("Average Certain Factor: " + AprioriProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            System.out.println("Average Certain Factor: " + AprioriProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            w.println("Average Netconf: " + AprioriProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            System.out.println("Average Netconf: " + AprioriProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            w.println("Average YulesQ: " + AprioriProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            System.out.println("Average YulesQ: " + AprioriProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            w.println("Average Number of Antecedents: " + AprioriProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            System.out.println("Average Number of Antecedents: " + AprioriProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            w.println("Number of Covered Records (%): " + AprioriProcess.roundDouble(100.0 * (double)this.nCoveredRecords / (double)this.nTrans, 2));
            System.out.println("Number of Covered Records (%): " + AprioriProcess.roundDouble(100.0 * (double)this.nCoveredRecords / (double)this.nTrans, 2));
        } else {
            w.println("Average Support: 0.0");
            System.out.println("Average Support: 0.0");
            w.println("Average Confidence: 0.0");
            System.out.println("Average Confidence: 0.0");
            w.println("Average Lift: 0.0");
            System.out.println("Average Lift: 0.0");
            w.println("Average Conviction: 0.0");
            System.out.println("Average Conviction: 0.0");
            w.println("Average Certain Factor: 0.0");
            System.out.println("Average Certain Factor: 0.0");
            w.println("Average Netconf: 0.0");
            System.out.println("Average Netconf: 0.0");
            w.println("Average YulesQ: 0.0");
            System.out.println("Average YulesQ: 0.0");
            w.println("Average Number of Antecedents: 0.0");
            System.out.println("Average Number of Antecedents: 0.0");
            w.println("Number of Covered Records (%): 0.0");
            System.out.println("Number of Covered Records (%): 0.0");
        }
    }

    private int generateFirstCandidates() {
        int generated = 0;
        ArrayList<Item> v = this.root.getChildren();
        for (int i = 0; i < this.nTrans; ++i) {
            for (int j = 0; j < this.nAttr; ++j) {
                Item child = new Item(this.transactions[i][j]);
                int index = v.indexOf(child);
                if (index == -1) {
                    child.incSupport();
                    this.root.addChild(child);
                    ++generated;
                    continue;
                }
                v.get(index).incSupport();
            }
        }
        return generated;
    }

    private int checkMinSupport(Item item) {
        int pruned = 0;
        ArrayList<Item> v = item.getChildren();
        ArrayList<Item> v_tmp = new ArrayList<Item>(v);
        for (int i = 0; i < v_tmp.size(); ++i) {
            Item child = v_tmp.get(i);
            if ((double)child.getSupport() / (double)this.nTrans < this.minSupport) {
                v.remove(child);
                ++pruned;
                continue;
            }
            pruned += this.checkMinSupport(child);
        }
        return pruned;
    }

    private int generateCandidates(Item item, ArrayList<Item> current, int depth) {
        int generated = 0;
        ArrayList<Item> v = item.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Item child = v.get(i);
            current.add(child);
            generated = depth == this.pass - 1 ? (generated += this.copySiblings(child, v, current)) : (generated += this.generateCandidates(child, current, depth + 1));
            current.remove(child);
        }
        return generated;
    }

    private int copySiblings(Item item, ArrayList<Item> siblings, ArrayList<Item> current) {
        int copied = 0;
        Item parent = item;
        int mod_item = item.getLabel() % this.nAttr;
        for (int i = 0; i < siblings.size(); ++i) {
            Item sibling = siblings.get(i);
            int mod_sibling = sibling.getLabel() % this.nAttr;
            if (mod_sibling <= mod_item) continue;
            current.add(sibling);
            if (this.checkSubsets(current, this.root.getChildren(), 0, 1)) {
                parent.addChild(new Item(sibling.getLabel()));
                ++copied;
            }
            current.remove(sibling);
        }
        return copied;
    }

    private boolean checkSubsets(ArrayList<Item> current, ArrayList<Item> children, int mark, int depth) {
        boolean ok = true;
        if (children.isEmpty()) {
            ok = false;
        }
        for (int i = depth; ok && mark <= i; --i) {
            int index = children.indexOf(current.get(i));
            if (index >= 0) {
                if (depth >= this.pass - 1) continue;
                Item child = children.get(index);
                ok = this.checkSubsets(current, child.getChildren(), i + 1, depth + 1);
                continue;
            }
            ok = false;
        }
        return ok;
    }

    private void countSupport() {
        for (int i = 0; i < this.nTrans; ++i) {
            this.countSupport(this.root, this.transactions[i], 1, i);
        }
    }

    private void countSupport(Item item, int[] items, int depth, int id_trans) {
        ArrayList<Item> v = item.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Item child = v.get(i);
            int mod_child = child.getLabel() % this.nAttr;
            if (child.getLabel() != items[mod_child]) continue;
            if (depth == this.pass) {
                child.incSupport();
                continue;
            }
            this.countSupport(child, items, depth + 1, id_trans);
        }
    }

    public static double roundDouble(double number, int decimalPlace) {
        if (!Double.isInfinite(number) && !Double.isNaN(number)) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(decimalPlace, 0);
            double numberRound = bd.doubleValue();
            return numberRound;
        }
        return number;
    }

    private void generateRules(Item item, ArrayList<Item> itemset, ArrayList<AssociationRule> rules, HashSet<Integer> cov_recs) {
        ArrayList<Item> v = item.getChildren();
        for (int f = 0; f < v.size(); ++f) {
            item = v.get(f);
            itemset.add(item);
            if (itemset.size() > 1) {
                for (int i = 0; i < itemset.size(); ++i) {
                    int j;
                    ArrayList<Item> ant = new ArrayList<Item>();
                    for (j = 0; j < itemset.size(); ++j) {
                        if (i == j) continue;
                        ant.add(itemset.get(j));
                    }
                    double rule_sup = (double)item.getSupport() / (double)this.nTrans;
                    double ant_sup = (double)this.searchItemsetIntoTrie(this.root, ant, 0) / (double)this.nTrans;
                    double cons_sup = (double)itemset.get(i).getSupport() / (double)this.nTrans;
                    double conf = rule_sup / ant_sup;
                    double lift = cons_sup == 0.0 || ant_sup == 0.0 ? 1.0 : rule_sup / (ant_sup * cons_sup);
                    double conv = cons_sup == 1.0 || ant_sup == 0.0 ? 1.0 : ant_sup * (1.0 - cons_sup) / (ant_sup - rule_sup);
                    double netConf = ant_sup == 0.0 || ant_sup == 1.0 || Math.abs(ant_sup * (1.0 - ant_sup)) <= 0.001 ? 0.0 : (rule_sup - ant_sup * cons_sup) / (ant_sup * (1.0 - ant_sup));
                    double numeratorYules = rule_sup * (1.0 - cons_sup - ant_sup + rule_sup) - (ant_sup - rule_sup) * (cons_sup - rule_sup);
                    double denominatorYules = rule_sup * (1.0 - cons_sup - ant_sup + rule_sup) + (ant_sup - rule_sup) * (cons_sup - rule_sup);
                    double yulesQ = ant_sup == 0.0 || ant_sup == 1.0 || cons_sup == 0.0 || cons_sup == 1.0 || Math.abs(denominatorYules) <= 0.001 ? 0.0 : numeratorYules / denominatorYules;
                    double CF = 0.0;
                    if (conf > cons_sup) {
                        CF = (conf - cons_sup) / (1.0 - cons_sup);
                    } else if (conf < cons_sup) {
                        CF = (conf - cons_sup) / cons_sup;
                    }
                    if (!(conf >= this.minConfidence)) continue;
                    AssociationRule ar = new AssociationRule();
                    for (j = 0; j < ant.size(); ++j) {
                        ar.addAntecedent(ant.get(j).getLabel());
                    }
                    ar.addConsequent(itemset.get(i).getLabel());
                    ar.setRuleSupport(rule_sup);
                    ar.setAntecedentSupport(ant_sup);
                    ar.setConsequentSupport(cons_sup);
                    ar.setConfidence(conf);
                    ar.setLift(lift);
                    ar.setConv(conv);
                    ar.setCF(CF);
                    ar.setNetConf(netConf);
                    ar.setYulesQ(yulesQ);
                    cov_recs.addAll(this.countCoveredRecords(itemset));
                    rules.add(ar);
                }
            }
            if (item.hasChildren()) {
                this.generateRules(item, itemset, rules, cov_recs);
            }
            itemset.remove(item);
        }
    }

    private int searchItemsetIntoTrie(Item item, ArrayList<Item> itemset, int index) {
        int support = 0;
        ArrayList<Item> v = item.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            item = v.get(i);
            if (!item.equals(itemset.get(index))) continue;
            if (index == itemset.size() - 1) {
                return item.getSupport();
            }
            if (!item.hasChildren()) break;
            support = this.searchItemsetIntoTrie(item, itemset, index + 1);
            break;
        }
        return support;
    }

    private HashSet<Integer> countCoveredRecords(ArrayList<Item> itemset) {
        ArrayList<HashSet<Integer>> v_tid_lst = new ArrayList<HashSet<Integer>>();
        for (int i = 0; i < itemset.size(); ++i) {
            Item item = itemset.get(i);
            v_tid_lst.add(this.dataset.getTIDList().get(item.getLabel()));
        }
        HashSet<Integer> toIntersect = new HashSet<Integer>((Collection)v_tid_lst.get(0));
        for (int k = 1; k < v_tid_lst.size(); ++k) {
            toIntersect.retainAll((Collection)v_tid_lst.get(k));
            if (toIntersect.isEmpty()) break;
        }
        return toIntersect;
    }
}

