/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD;

import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.RuleBase;
import org.core.Randomize;

public class Individual
implements Comparable {
    double[] gene;
    int[] geneR;
    double fitness;
    double accuracy;
    double w1;
    int n_e;
    int nGenes;
    RuleBase ruleBase;

    public Individual() {
    }

    public Individual(RuleBase ruleBase, DataBase dataBase, double w1) {
        this.ruleBase = ruleBase;
        this.w1 = w1;
        this.fitness = Double.NEGATIVE_INFINITY;
        this.accuracy = 0.0;
        this.n_e = 0;
        this.nGenes = dataBase.getnLabelsReal();
        if (this.nGenes > 0) {
            this.gene = new double[this.nGenes];
        }
        this.geneR = new int[this.ruleBase.size()];
    }

    public Individual clone() {
        int j;
        Individual ind = new Individual();
        ind.ruleBase = this.ruleBase;
        ind.w1 = this.w1;
        ind.fitness = this.fitness;
        ind.accuracy = this.accuracy;
        ind.n_e = this.n_e;
        ind.nGenes = this.nGenes;
        if (this.nGenes > 0) {
            ind.gene = new double[this.nGenes];
            for (j = 0; j < this.nGenes; ++j) {
                ind.gene[j] = this.gene[j];
            }
        }
        ind.geneR = new int[this.geneR.length];
        for (j = 0; j < this.geneR.length; ++j) {
            ind.geneR[j] = this.geneR[j];
        }
        return ind;
    }

    public void reset() {
        int i;
        if (this.nGenes > 0) {
            for (i = 0; i < this.nGenes; ++i) {
                this.gene[i] = 0.5;
            }
        }
        for (i = 0; i < this.geneR.length; ++i) {
            this.geneR[i] = 1;
        }
    }

    public void randomValues() {
        int i;
        if (this.nGenes > 0) {
            for (i = 0; i < this.nGenes; ++i) {
                this.gene[i] = Randomize.Rand();
            }
        }
        for (i = 0; i < this.geneR.length; ++i) {
            this.geneR[i] = Randomize.Rand() < 0.5 ? 0 : 1;
        }
    }

    public int size() {
        return this.geneR.length;
    }

    public int getnSelected() {
        int count = 0;
        for (int i = 0; i < this.geneR.length; ++i) {
            if (this.geneR[i] <= 0) continue;
            ++count;
        }
        return count;
    }

    public boolean isNew() {
        return this.n_e == 1;
    }

    public void onNew() {
        this.n_e = 1;
    }

    public void offNew() {
        this.n_e = 0;
    }

    public void setw1(double value) {
        this.w1 = value;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public double getFitness() {
        return this.fitness;
    }

    private int StringRep(Individual indiv, int BITS_GEN) {
        char last;
        int j;
        long n;
        int i;
        int length = this.nGenes * BITS_GEN;
        char[] stringIndiv1 = new char[length];
        char[] stringIndiv2 = new char[length];
        char[] stringAux = new char[length];
        double INCREMENTO = 1.0 / (Math.pow(2.0, BITS_GEN) - 1.0);
        int pos = 0;
        for (i = 0; i < this.nGenes; ++i) {
            n = (int)(this.gene[i] / INCREMENTO + 0.5);
            for (j = BITS_GEN - 1; j >= 0; --j) {
                stringAux[j] = (char)(48L + (n & 1L));
                n >>= 1;
            }
            last = '0';
            j = 0;
            while (j < BITS_GEN) {
                stringIndiv1[pos] = stringAux[j] != last ? 49 : 48;
                last = stringAux[j];
                ++j;
                ++pos;
            }
        }
        pos = 0;
        for (i = 0; i < this.nGenes; ++i) {
            n = (int)(indiv.gene[i] / INCREMENTO + 0.5);
            for (j = BITS_GEN - 1; j >= 0; --j) {
                stringAux[j] = (char)(48L + (n & 1L));
                n >>= 1;
            }
            last = '0';
            j = 0;
            while (j < BITS_GEN) {
                stringIndiv2[pos] = stringAux[j] != last ? 49 : 48;
                last = stringAux[j];
                ++j;
                ++pos;
            }
        }
        int count = 0;
        for (i = 0; i < length; ++i) {
            if (stringIndiv1[i] == stringIndiv2[i]) continue;
            ++count;
        }
        return count;
    }

    public int distHamming(Individual ind, int BITS_GEN) {
        int count = 0;
        for (int i = 0; i < this.geneR.length; ++i) {
            if (this.geneR[i] == ind.geneR[i]) continue;
            ++count;
        }
        if (this.nGenes > 0) {
            count += this.StringRep(ind, BITS_GEN);
        }
        return count;
    }

    public void Hux(Individual indiv) {
        int i;
        int[] position = new int[this.geneR.length];
        int dist = 0;
        for (i = 0; i < this.geneR.length; ++i) {
            if (this.geneR[i] == indiv.geneR[i]) continue;
            position[dist] = i;
            ++dist;
        }
        int nPos = dist / 2;
        for (i = 0; i < nPos; ++i) {
            int random = Randomize.Randint(0, dist);
            int aux = this.geneR[position[random]];
            this.geneR[position[random]] = indiv.geneR[position[random]];
            indiv.geneR[position[random]] = aux;
            aux = position[--dist];
            position[dist] = position[random];
            position[random] = aux;
        }
    }

    public void xPC_BLX(Individual indiv, double d) {
        for (int i = 0; i < this.nGenes; ++i) {
            double C1;
            double I = d * Math.abs(this.gene[i] - indiv.gene[i]);
            double A1 = this.gene[i] - I;
            if (A1 < 0.0) {
                A1 = 0.0;
            }
            if ((C1 = this.gene[i] + I) > 1.0) {
                C1 = 1.0;
            }
            this.gene[i] = A1 + Randomize.Rand() * (C1 - A1);
            A1 = indiv.gene[i] - I;
            if (A1 < 0.0) {
                A1 = 0.0;
            }
            if ((C1 = indiv.gene[i] + I) > 1.0) {
                C1 = 1.0;
            }
            indiv.gene[i] = A1 + Randomize.Rand() * (C1 - A1);
        }
    }

    public RuleBase generateRB() {
        RuleBase ruleBase = this.ruleBase.clone();
        ruleBase.evaluate(this.gene, this.geneR);
        ruleBase.setDefaultRule();
        for (int i = this.geneR.length - 1; i >= 0; --i) {
            if (this.geneR[i] >= 1) continue;
            ruleBase.remove(i);
        }
        return ruleBase;
    }

    public void evaluate() {
        this.ruleBase.evaluate(this.gene, this.geneR);
        this.accuracy = this.ruleBase.getAccuracy();
        this.fitness = this.accuracy - this.w1 / ((double)(this.ruleBase.size() - this.getnSelected()) + 1.0) - 5.0 * (double)this.ruleBase.getUncover() - 5.0 * (double)this.ruleBase.hasClassUncovered(this.geneR);
    }

    public int compareTo(Object a) {
        if (((Individual)a).fitness < this.fitness) {
            return -1;
        }
        if (((Individual)a).fitness > this.fitness) {
            return 1;
        }
        return 0;
    }
}

