/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.sax;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import javolution.lang.Reusable;
import javolution.xml.pull.XmlPullParserException;
import javolution.xml.pull.XmlPullParserImpl;
import javolution.xml.sax.Attributes;
import javolution.xml.sax.ContentHandler;
import javolution.xml.sax.DefaultHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class XmlSaxParserImpl
implements Reusable {
    private static DefaultHandler DEFAULT_HANDLER = new DefaultHandler();
    private ContentHandler _contentHandler;
    private ErrorHandler _errorHandler;
    private final XmlPullParserImpl _pullParser = new XmlPullParserImpl();
    private final LocatorImpl _locator = new LocatorImpl();
    private EntityResolver _entityResolver;
    private DTDHandler _dtdHandler;
    int[] _startLength = new int[2];

    public XmlSaxParserImpl() {
        this.setContentHandler(DEFAULT_HANDLER);
        this.setErrorHandler(DEFAULT_HANDLER);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException();
        }
        this._contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler == DEFAULT_HANDLER ? null : this._contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException();
        }
        this._errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler == DEFAULT_HANDLER ? null : this._errorHandler;
    }

    public void parse(InputStream inputStream) throws IOException, SAXException {
        this._pullParser.setInput(inputStream);
        this.parseAll();
    }

    public void parse(ByteBuffer byteBuffer) throws IOException, SAXException {
        this._pullParser.setInput(byteBuffer);
        this.parseAll();
    }

    public void parse(Reader reader) throws IOException, SAXException {
        this._pullParser.setInput(reader);
        this.parseAll();
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return true;
        }
        throw new SAXNotRecognizedException("Feature " + string + " not recognized");
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces") || string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return;
        }
        throw new SAXNotRecognizedException("Feature " + string + " not recognized");
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property " + string + " not recognized");
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property " + string + " not recognized");
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this._dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    public void reset() {
        this.setContentHandler(DEFAULT_HANDLER);
        this.setErrorHandler(DEFAULT_HANDLER);
        this._pullParser.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAll() throws IOException, SAXException {
        try {
            int n = this._pullParser.getEventType();
            if (n != 0) {
                throw new SAXException("Currently parsing");
            }
            this._contentHandler.startDocument();
            block5: while (true) {
                if ((n = this._pullParser.nextToken()) == 2) {
                    CharSequence charSequence;
                    CharSequence charSequence2;
                    int n2 = this._pullParser.getDepth();
                    int n3 = this._pullParser.getNamespaceCount(n2 - 1);
                    int n4 = this._pullParser.getNamespaceCount(n2);
                    for (int i = n3; i < n4; ++i) {
                        charSequence2 = this._pullParser.getNamespacePrefix(i);
                        charSequence = this._pullParser.getNamespaceUri(i);
                        this._contentHandler.startPrefixMapping(charSequence2, charSequence);
                    }
                    CharSequence charSequence3 = this._pullParser.getName();
                    charSequence2 = this._pullParser.getNamespace();
                    charSequence = this._pullParser.getQName();
                    Attributes attributes = this._pullParser.getSaxAttributes();
                    this._contentHandler.startElement(charSequence2, charSequence3, charSequence, attributes);
                    continue;
                }
                if (n == 3) {
                    CharSequence charSequence = this._pullParser.getName();
                    CharSequence charSequence4 = this._pullParser.getNamespace();
                    CharSequence charSequence5 = this._pullParser.getQName();
                    this._contentHandler.endElement(charSequence4, charSequence, charSequence5);
                    int n5 = this._pullParser.getDepth();
                    int n6 = this._pullParser.getNamespaceCount(n5);
                    int n7 = this._pullParser.getNamespaceCount(n5 + 1);
                    int n8 = n6;
                    while (true) {
                        if (n8 >= n7) continue block5;
                        CharSequence charSequence6 = this._pullParser.getNamespacePrefix(n8);
                        this._contentHandler.endPrefixMapping(charSequence6);
                        ++n8;
                    }
                }
                if (n == 4 || n == 5) {
                    if (this._pullParser.isWhitespace()) {
                        char[] cArray = this._pullParser.getTextCharacters(this._startLength);
                        this._contentHandler.ignorableWhitespace(cArray, this._startLength[0], this._startLength[1]);
                        continue;
                    }
                    char[] cArray = this._pullParser.getTextCharacters(this._startLength);
                    this._contentHandler.characters(cArray, this._startLength[0], this._startLength[1]);
                    continue;
                }
                if (n == 1) break;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            SAXParseException sAXParseException = new SAXParseException(xmlPullParserException.getMessage(), this._locator);
            this._errorHandler.fatalError(sAXParseException);
        }
        finally {
            this._contentHandler.endDocument();
            this.reset();
        }
    }

    private class LocatorImpl
    implements Locator {
        private LocatorImpl() {
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }

        public int getLineNumber() {
            return XmlSaxParserImpl.this._pullParser.getLineNumber();
        }

        public int getColumnNumber() {
            return XmlSaxParserImpl.this._pullParser.getColumnNumber();
        }
    }
}

