/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import java.io.Serializable;
import javolution.lang.Reference;
import javolution.realtime.Context;
import javolution.realtime.LocalContext;
import javolution.util.FastMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalReference<T>
implements Reference<T>,
Serializable {
    private T _defaultValue;
    private boolean _hasBeenLocallyOverriden;

    public LocalReference() {
        this(null);
    }

    public LocalReference(T t) {
        this._defaultValue = t;
    }

    @Override
    public final T get() {
        return this._hasBeenLocallyOverriden ? this.retrieveValue() : this._defaultValue;
    }

    private T retrieveValue() {
        LocalContext localContext = Context.current().inheritedLocalContext;
        while (localContext != null) {
            Object v = localContext._references.get(this);
            if (v != null) {
                return (T)v;
            }
            localContext = localContext.getOuter().inheritedLocalContext;
        }
        return this._defaultValue;
    }

    @Override
    public void set(T t) {
        LocalContext localContext = Context.current().inheritedLocalContext;
        if (localContext != null) {
            FastMap fastMap = localContext._references;
            fastMap.put(this, t);
            this._hasBeenLocallyOverriden = true;
            return;
        }
        this._defaultValue = t;
    }

    public T getDefault() {
        return this._defaultValue;
    }

    public T getLocal() {
        LocalContext localContext = Context.current().inheritedLocalContext;
        return (T)(localContext != null ? localContext._references.get(this) : this._defaultValue);
    }

    public void setDefault(T t) {
        this._defaultValue = t;
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

