/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.algorithm.implementation;

import ec.satoolkit.DefaultPreprocessingFilter;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.satoolkit.GenericSaDiagnostics;
import ec.satoolkit.GenericSaProcessingFactory;
import ec.satoolkit.GenericSaResults;
import ec.satoolkit.benchmarking.SaBenchmarkingResults;
import ec.satoolkit.seats.SeatsResults;
import ec.satoolkit.tramoseats.SeatsDecomposer;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.SequentialProcessing;
import ec.tstoolkit.design.Singleton;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.tramo.TransformSpec;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@Singleton
public class TramoSeatsProcessingFactory
extends GenericSaProcessingFactory
implements IProcessingFactory<TramoSeatsSpecification, TsData, CompositeResults> {
    public static final String METHOD = "tramoseats";
    public static final String VERSION = "0.1.0.0";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Seasonal adjustment", "tramoseats", "0.1.0.0");
    public static final TramoSeatsProcessingFactory instance = new TramoSeatsProcessingFactory();

    private static SequentialProcessing<TsData> create(TramoSeatsSpecification xspec, ProcessingContext context) {
        SequentialProcessing<TsData> processing = new SequentialProcessing<TsData>();
        DefaultPreprocessingFilter filter = new DefaultPreprocessingFilter();
        TransformSpec transform = xspec.getTramoSpecification().getTransform();
        TramoSeatsProcessingFactory.addInitialStep(transform.getSpan(), transform.isPreliminaryCheck(), processing);
        TramoSeatsProcessingFactory.addPreprocessingStep(xspec.getTramoSpecification().build(context), xspec.getSeatsSpecification().getPredictionLength(), processing);
        TramoSeatsProcessingFactory.addDecompositionStep(new SeatsDecomposer(xspec.getSeatsSpecification()), filter, processing);
        TramoSeatsProcessingFactory.addFinalStep(filter, processing);
        TramoSeatsProcessingFactory.addBenchmarkingStep(xspec.getBenchmarkingSpecification(), processing);
        TramoSeatsProcessingFactory.addGeneralStep(processing);
        TramoSeatsProcessingFactory.addDiagnosticsStep(processing);
        return processing;
    }

    protected TramoSeatsProcessingFactory() {
    }

    public static CompositeResults process(TsData s, TramoSeatsSpecification xspec, ProcessingContext context) {
        SequentialProcessing<TsData> processing = TramoSeatsProcessingFactory.create(xspec, context);
        return processing.process((Object)s);
    }

    public static CompositeResults process(TsData s, TramoSeatsSpecification xspec) {
        return TramoSeatsProcessingFactory.process(s, xspec, null);
    }

    public SequentialProcessing<TsData> generateProcessing(TramoSeatsSpecification xspec, ProcessingContext context) {
        return TramoSeatsProcessingFactory.create(xspec, context);
    }

    public SequentialProcessing<TsData> generateProcessing(TramoSeatsSpecification xspec) {
        return TramoSeatsProcessingFactory.create(xspec, null);
    }

    @Override
    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof TramoSeatsSpecification;
    }

    @Override
    public Map<String, Class> getSpecificationDictionary(Class<TramoSeatsSpecification> specClass) {
        HashMap<String, Class> dic = new HashMap<String, Class>();
        TramoSeatsSpecification.fillDictionary(null, dic);
        return dic;
    }

    @Override
    public Map<String, Class> getOutputDictionary(boolean compact) {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        PreprocessingModel.fillDictionary(null, dic, compact);
        SeatsResults.fillDictionary("decomposition", dic, compact);
        DefaultSeriesDecomposition.fillDictionary(null, dic, compact);
        SaBenchmarkingResults.fillDictionary("benchmarking", dic, compact);
        GenericSaResults.fillDictionary(null, dic, compact);
        GenericSaDiagnostics.fillDictionary("diagnostics", dic, compact);
        return dic;
    }
}

