/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tdouble;

import cern.jet.math.tdouble.DoubleConstants;
import cern.jet.math.tdouble.Polynomial;
import cern.jet.stat.tdouble.Gamma;

public class Probability
extends DoubleConstants {
    protected static final double[] P0 = new double[]{-59.96335010141079, 98.00107541859997, -56.67628574690703, 13.931260938727968, -1.2391658386738125};
    protected static final double[] Q0 = new double[]{1.9544885833814176, 4.676279128988815, 86.36024213908905, -225.46268785411937, 200.26021238006066, -82.03722561683334, 15.90562251262117, -1.1833162112133};
    protected static final double[] P1 = new double[]{4.0554489230596245, 31.525109459989388, 57.16281922464213, 44.08050738932008, 14.684956192885803, 2.1866330685079025, -0.1402560791713545, -0.03504246268278482, -8.574567851546854E-4};
    protected static final double[] Q1 = new double[]{15.779988325646675, 45.39076351288792, 41.3172038254672, 15.04253856929075, 2.504649462083094, -0.14218292285478779, -0.03808064076915783, -9.332594808954574E-4};
    protected static final double[] P2 = new double[]{3.2377489177694603, 6.915228890689842, 3.9388102529247444, 1.3330346081580755, 0.20148538954917908, 0.012371663481782003, 3.0158155350823543E-4, 2.6580697468673755E-6, 6.239745391849833E-9};
    protected static final double[] Q2 = new double[]{6.02427039364742, 3.6798356385616087, 1.3770209948908132, 0.21623699359449663, 0.013420400608854318, 3.2801446468212774E-4, 2.8924786474538068E-6, 6.790194080099813E-9};

    protected Probability() {
    }

    public static double beta(double d, double d2, double d3) {
        return Gamma.incompleteBeta(d, d2, d3);
    }

    public static double betaComplemented(double d, double d2, double d3) {
        return Gamma.incompleteBeta(d2, d, d3);
    }

    public static double binomial(int n, int n2, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException();
        }
        if (n == n2) {
            return 1.0;
        }
        if (n == 0) {
            return Math.pow(1.0 - d, n2 - n);
        }
        return Gamma.incompleteBeta(n2 - n, n + 1, 1.0 - d);
    }

    public static double binomialComplemented(int n, int n2, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException();
        }
        if (n == n2) {
            return 0.0;
        }
        if (n == 0) {
            return 1.0 - Math.pow(1.0 - d, n2 - n);
        }
        return Gamma.incompleteBeta(n + 1, n2 - n, d);
    }

    public static double chiSquare(double d, double d2) throws ArithmeticException {
        if (d2 < 0.0 || d < 1.0) {
            return 0.0;
        }
        return Gamma.incompleteGamma(d / 2.0, d2 / 2.0);
    }

    public static double chiSquareComplemented(double d, double d2) throws ArithmeticException {
        if (d2 < 0.0 || d < 1.0) {
            return 0.0;
        }
        return Gamma.incompleteGammaComplement(d / 2.0, d2 / 2.0);
    }

    public static double errorFunction(double d) throws ArithmeticException {
        double[] dArray = new double[]{9.604973739870516, 90.02601972038427, 2232.005345946843, 7003.325141128051, 55592.30130103949};
        double[] dArray2 = new double[]{33.56171416475031, 521.3579497801527, 4594.323829709801, 22629.000061389095, 49267.39426086359};
        if (Math.abs(d) > 1.0) {
            return 1.0 - Probability.errorFunctionComplemented(d);
        }
        double d2 = d * d;
        double d3 = d * Polynomial.polevl(d2, dArray, 4) / Polynomial.p1evl(d2, dArray2, 5);
        return d3;
    }

    public static double errorFunctionComplemented(double d) throws ArithmeticException {
        double d2;
        double d3;
        double[] dArray = new double[]{2.461969814735305E-10, 0.5641895648310689, 7.463210564422699, 48.63719709856814, 196.5208329560771, 526.4451949954773, 934.5285271719576, 1027.5518868951572, 557.5353353693994};
        double[] dArray2 = new double[]{13.228195115474499, 86.70721408859897, 354.9377788878199, 975.7085017432055, 1823.9091668790973, 2246.3376081871097, 1656.6630919416134, 557.5353408177277};
        double[] dArray3 = new double[]{0.5641895835477551, 1.275366707599781, 5.019050422511805, 6.160210979930536, 7.4097426995044895, 2.9788666537210022};
        double[] dArray4 = new double[]{2.2605286322011726, 9.396035249380015, 12.048953980809666, 17.08144507475659, 9.608968090632859, 3.369076451000815};
        double d4 = d < 0.0 ? -d : d;
        if (d4 < 1.0) {
            return 1.0 - Probability.errorFunction(d);
        }
        double d5 = -d * d;
        if (d5 < -709.782712893384) {
            if (d < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        d5 = Math.exp(d5);
        if (d4 < 8.0) {
            d3 = Polynomial.polevl(d4, dArray, 8);
            d2 = Polynomial.p1evl(d4, dArray2, 8);
        } else {
            d3 = Polynomial.polevl(d4, dArray3, 5);
            d2 = Polynomial.p1evl(d4, dArray4, 6);
        }
        double d6 = d5 * d3 / d2;
        if (d < 0.0) {
            d6 = 2.0 - d6;
        }
        if (d6 == 0.0) {
            if (d < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        return d6;
    }

    public static double gamma(double d, double d2, double d3) {
        if (d3 < 0.0) {
            return 0.0;
        }
        return Gamma.incompleteGamma(d2, d * d3);
    }

    public static double gammaComplemented(double d, double d2, double d3) {
        if (d3 < 0.0) {
            return 0.0;
        }
        return Gamma.incompleteGammaComplement(d2, d * d3);
    }

    public static double negativeBinomial(int n, int n2, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            return 0.0;
        }
        return Gamma.incompleteBeta(n2, n + 1, d);
    }

    public static double negativeBinomialComplemented(int n, int n2, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            return 0.0;
        }
        return Gamma.incompleteBeta(n + 1, n2, 1.0 - d);
    }

    public static double normal(double d) throws ArithmeticException {
        double d2;
        double d3 = d * 0.7071067811865476;
        double d4 = Math.abs(d3);
        if (d4 < 0.7071067811865476) {
            d2 = 0.5 + 0.5 * Probability.errorFunction(d3);
        } else {
            d2 = 0.5 * Probability.errorFunctionComplemented(d4);
            if (d3 > 0.0) {
                d2 = 1.0 - d2;
            }
        }
        return d2;
    }

    public static double normal(double d, double d2, double d3) throws ArithmeticException {
        if (d3 > 0.0) {
            return 0.5 + 0.5 * Probability.errorFunction((d3 - d) / Math.sqrt(2.0 * d2));
        }
        return 0.5 - 0.5 * Probability.errorFunction(-(d3 - d) / Math.sqrt(2.0 * d2));
    }

    public static double normalInverse(double d) throws ArithmeticException {
        double d2 = Math.sqrt(Math.PI * 2);
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (d >= 1.0) {
            throw new IllegalArgumentException();
        }
        boolean bl = true;
        double d3 = d;
        if (d3 > 0.8646647167633873) {
            d3 = 1.0 - d3;
            bl = false;
        }
        if (d3 > 0.1353352832366127) {
            double d4 = (d3 -= 0.5) * d3;
            double d5 = d3 + d3 * (d4 * Polynomial.polevl(d4, P0, 4) / Polynomial.p1evl(d4, Q0, 8));
            return d5 *= d2;
        }
        double d6 = Math.sqrt(-2.0 * Math.log(d3));
        double d7 = d6 - Math.log(d6) / d6;
        double d8 = 1.0 / d6;
        double d9 = d6 < 8.0 ? d8 * Polynomial.polevl(d8, P1, 8) / Polynomial.p1evl(d8, Q1, 8) : d8 * Polynomial.polevl(d8, P2, 8) / Polynomial.p1evl(d8, Q2, 8);
        d6 = d7 - d9;
        if (bl) {
            d6 = -d6;
        }
        return d6;
    }

    public static double poisson(int n, double d) throws ArithmeticException {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            return 0.0;
        }
        return Gamma.incompleteGammaComplement(n + 1, d);
    }

    public static double poissonComplemented(int n, double d) throws ArithmeticException {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        if (n < -1) {
            return 0.0;
        }
        return Gamma.incompleteGamma(n + 1, d);
    }

    public static double studentT(double d, double d2) throws ArithmeticException {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (d2 == 0.0) {
            return 0.5;
        }
        double d3 = 0.5 * Gamma.incompleteBeta(0.5 * d, 0.5, d / (d + d2 * d2));
        if (d2 >= 0.0) {
            d3 = 1.0 - d3;
        }
        return d3;
    }

    public static double studentTInverse(double d, int n) {
        double d2 = 1.0 - d / 2.0;
        d2 = 1.0 - d / 2.0;
        double d3 = Probability.normalInverse(d2);
        if (n > 200) {
            return d3;
        }
        double d4 = Probability.studentT(n, d3) - d2;
        double d5 = d3;
        double d6 = d4;
        do {
            if (d4 > 0.0) {
                d5 /= 2.0;
                continue;
            }
            d5 += d3;
        } while (d4 * (d6 = Probability.studentT(n, d5) - d2) > 0.0);
        do {
            double d7;
            double d8;
            double d9;
            if (Math.abs(d9 = Probability.studentT(n, d8 = d5 - d6 / (d7 = (d6 - d4) / (d5 - d3))) - d2) < 1.0E-8) {
                return d8;
            }
            if (d9 * d6 < 0.0) {
                d3 = d5;
                d4 = d6;
                d5 = d8;
                d6 = d9;
                continue;
            }
            double d10 = d6 / (d6 + d9);
            d4 = d10 * d4;
            d5 = d8;
            d6 = d9;
        } while (Math.abs(d5 - d3) > 0.001);
        if (Math.abs(d6) <= Math.abs(d4)) {
            return d5;
        }
        return d3;
    }
}

