/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatBiCG
extends AbstractFloatIterativeSolver {
    private FloatMatrix1D z;
    private FloatMatrix1D p;
    private FloatMatrix1D q;
    private FloatMatrix1D r;
    private FloatMatrix1D ztilde;
    private FloatMatrix1D ptilde;
    private FloatMatrix1D qtilde;
    private FloatMatrix1D rtilde;

    public FloatBiCG(FloatMatrix1D floatMatrix1D) {
        this.z = floatMatrix1D.copy();
        this.p = floatMatrix1D.copy();
        this.q = floatMatrix1D.copy();
        this.r = floatMatrix1D.copy();
        this.ztilde = floatMatrix1D.copy();
        this.ptilde = floatMatrix1D.copy();
        this.qtilde = floatMatrix1D.copy();
        this.rtilde = floatMatrix1D.copy();
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(floatMatrix2D, floatMatrix1D, floatMatrix1D2);
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        floatMatrix2D.zMult(floatMatrix1D2, this.r.assign(floatMatrix1D), -1.0f, 1.0f, false);
        this.rtilde.assign(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, floatMatrix1D2)) {
            this.M.apply(this.r, this.z);
            this.M.transApply(this.rtilde, this.ztilde);
            f = this.z.zDotProduct(this.rtilde);
            if ((double)f == 0.0) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (this.iter.isFirst()) {
                this.p.assign(this.z);
                this.ptilde.assign(this.ztilde);
            } else {
                f4 = f / f2;
                this.p.assign(this.z, FloatFunctions.plusMultFirst(f4));
                this.ptilde.assign(this.ztilde, FloatFunctions.plusMultFirst(f4));
            }
            floatMatrix2D.zMult(this.p, this.q);
            floatMatrix2D.zMult(this.ptilde, this.qtilde, 1.0f, 0.0f, true);
            f3 = f / this.ptilde.zDotProduct(this.q);
            floatMatrix1D2.assign(this.p, FloatFunctions.plusMultSecond(f3));
            this.r.assign(this.q, FloatFunctions.plusMultSecond(-f3));
            this.rtilde.assign(this.qtilde, FloatFunctions.plusMultSecond(-f3));
            f2 = f;
            this.iter.next();
        }
        return floatMatrix1D2;
    }
}

