/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.continuous.TopographicalMap;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class BivariateDiscreteDiffusionModel
extends MultivariateDiffusionModel {
    public static final String DISCRETE_DIFFUSION_PROCESS = "multivariateDiscreteDiffusionModel";
    public static final String GRID_X_DIMENSION = "xGridDimension";
    public static final String GRID_Y_DIMENSION = "yGridDimension";
    public static final String EVEC_NAME = "eigenvectorsFileName";
    public static final String EVAL_NAME = "eigenvaluesFileName";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("eigenvectorsFileName"), AttributeRule.newStringRule("eigenvaluesFileName"), AttributeRule.newIntegerRule("xGridDimension"), AttributeRule.newIntegerRule("yGridDimension"), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return BivariateDiscreteDiffusionModel.DISCRETE_DIFFUSION_PROCESS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Object object;
            Object object2;
            Object object3;
            int n;
            int n2;
            block9: {
                File file;
                File file2;
                n2 = xMLObject.getIntegerAttribute(BivariateDiscreteDiffusionModel.GRID_X_DIMENSION);
                n = xMLObject.getIntegerAttribute(BivariateDiscreteDiffusionModel.GRID_Y_DIMENSION);
                String string = xMLObject.getStringAttribute(BivariateDiscreteDiffusionModel.EVEC_NAME);
                String string2 = xMLObject.getStringAttribute(BivariateDiscreteDiffusionModel.EVAL_NAME);
                try {
                    object3 = new File(string);
                    object2 = ((File)object3).getName();
                    object = ((File)object3).getParent();
                    if (!((File)object3).isAbsolute()) {
                        object = System.getProperty("user.dir");
                    }
                    file2 = new File((String)object, (String)object2);
                    new FileReader(file2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new XMLParseException("File '" + string + "' can not be opened for " + this.getParserName() + " element.");
                }
                try {
                    object3 = new File(string2);
                    object2 = ((File)object3).getName();
                    object = ((File)object3).getParent();
                    if (!((File)object3).isAbsolute()) {
                        object = System.getProperty("user.dir");
                    }
                    file = new File((String)object, (String)object2);
                    new FileReader(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new XMLParseException("File '" + string2 + "' can not be opened for " + this.getParserName() + " element.");
                }
                object3 = null;
                object2 = null;
                try {
                    object3 = TopographicalMap.readEigenvalues(file.getAbsolutePath());
                    object2 = TopographicalMap.readEigenvectors(file2.getAbsolutePath());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
            object = (Parameter)xMLObject.getChild(Parameter.class);
            int n3 = n2 * n;
            if (n3 != ((Object)object2).length || n3 != ((Object)object3).length) {
                throw new XMLParseException("Number of eigenvalues and eigenvectors must match the map grid dimensions");
            }
            return new BivariateDiscreteDiffusionModel((Parameter)object, n2, n, (double[])object3, (double[][])object2);
        }

        @Override
        public String getParserDescription() {
            return "Describes a multivariate discrete diffusion process.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return BivariateDiscreteDiffusionModel.class;
        }
    };
    private final Parameter graphRate;
    private final int xDim;
    private final int yDim;
    private final int totalDim;
    HashMap<Integer, Double> probabilityCache;
    private final double[] eVal;
    private final double[][] eVec;

    public BivariateDiscreteDiffusionModel(Parameter parameter, int n, int n2, double[] dArray, double[][] dArray2) {
        this.graphRate = parameter;
        this.xDim = n;
        this.yDim = n2;
        this.totalDim = n * n2;
        this.eVal = dArray;
        this.eVec = dArray2;
        this.addVariable(parameter);
        System.err.println("TEST00 = " + this.getCTMCProbability(0, 0, 0.0));
        System.err.println("TEST01 = " + this.getCTMCProbability(0, 1, 0.0));
    }

    private int getIndex(int n, int n2) {
        return n * this.yDim + n2;
    }

    private int[] getXY(int n) {
        int[] nArray;
        nArray = new int[]{n / this.yDim, n - nArray[0] * this.yDim};
        return nArray;
    }

    private double getProbability(int n, int n2, double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.totalDim; ++i) {
            d2 += this.eVec[n][i] * Math.exp(d * this.eVal[i]) * this.eVec[n2][i];
        }
        return d2;
    }

    public void handleParameterChangedEvent(Parameter parameter, int n) {
    }

    private double getCTMCProbability(int n, int n2, double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.totalDim; ++i) {
            d2 += this.eVec[n][i] * Math.exp(d * this.eVal[i]) * this.eVec[n2][i];
        }
        return d2;
    }

    @Override
    public double getLogLikelihood(double[] dArray, double[] dArray2, double d) {
        int n = this.getIndex((int)dArray[0], (int)dArray[1]);
        int n2 = this.getIndex((int)dArray2[0], (int)dArray2[1]);
        return Math.log(this.getCTMCProbability(n, n2, d));
    }
}

