/*
 * Decompiled with CFR 0.152.
 */
package beagle;

import beagle.Beagle;
import beagle.BeagleException;
import beagle.BeagleFlag;
import beagle.InstanceDetails;

public class GeneralBeagleImpl
implements Beagle {
    public static final boolean DEBUG = false;
    public static final boolean SCALING = true;
    public static final int SCALING_FACTOR_COUNT = 254;
    public static final int SCALING_FACTOR_OFFSET = 126;
    private static final int SCALING_EXPONENT_THRESHOLD = 2;
    protected final int tipCount;
    protected final int partialsBufferCount;
    protected final int compactBufferCount;
    protected final int stateCount;
    protected final int patternCount;
    protected final int eigenBufferCount;
    protected final int matrixBufferCount;
    protected final int categoryCount;
    protected int partialsSize;
    protected int matrixSize;
    protected double[][] cMatrices;
    protected double[][] eigenValues;
    protected double[][] stateFrequencies;
    protected double[] categoryRates;
    protected double[][] categoryWeights;
    protected double[] patternWeights;
    protected double[][] partials;
    protected int[][] scalingFactorCounts;
    protected int[][] tipStates;
    protected double[][] matrices;
    double[] tmpPartials;
    protected double[] scalingFactors;
    protected double[] logScalingFactors;

    public GeneralBeagleImpl(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        this.tipCount = n;
        this.partialsBufferCount = n2;
        this.compactBufferCount = n3;
        this.stateCount = n4;
        this.patternCount = n5;
        this.eigenBufferCount = n6;
        this.matrixBufferCount = n7;
        this.categoryCount = n8;
        if (n5 < 1) {
            throw new IllegalArgumentException("Pattern count must be at least 1");
        }
        if (n8 < 1) {
            throw new IllegalArgumentException("Category count must be at least 1");
        }
        this.cMatrices = new double[n6][n4 * n4 * n4];
        this.eigenValues = new double[n6][n4];
        this.stateFrequencies = new double[n6][n4];
        this.categoryWeights = new double[n6][n8];
        this.categoryRates = new double[n8];
        this.partialsSize = n5 * n4 * n8;
        this.patternWeights = new double[n5];
        this.tipStates = new int[n3][];
        this.partials = new double[n2][];
        for (n10 = 0; n10 < n2; ++n10) {
            this.partials[n10] = new double[this.partialsSize];
        }
        this.scalingFactorCounts = new int[n2][];
        for (n10 = 0; n10 < n2; ++n10) {
            this.scalingFactorCounts[n10] = new int[254];
        }
        this.scalingFactors = new double[254];
        this.logScalingFactors = new double[254];
        n10 = -126;
        for (int i = 0; i < 254; ++i) {
            this.scalingFactors[i] = Math.pow(2.0, n10);
            this.logScalingFactors[i] = Math.log(this.scalingFactors[i]);
            ++n10;
        }
        this.tmpPartials = new double[n5 * n4];
        this.matrixSize = n4 * n4;
        this.matrices = new double[n7][n8 * this.matrixSize];
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public void setPatternWeights(double[] dArray) {
        System.arraycopy(dArray, 0, this.patternWeights, 0, this.patternWeights.length);
    }

    @Override
    public void setPatternPartitions(int n, int[] nArray) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void setTipStates(int n, int[] nArray) {
        assert (n >= 0 && n < this.tipCount);
        if (this.tipStates[n] == null) {
            this.tipStates[n] = new int[this.patternCount];
        }
        int n2 = 0;
        for (int n3 : nArray) {
            this.tipStates[n][n2] = n3 < this.stateCount ? n3 : this.stateCount;
            ++n2;
        }
    }

    @Override
    public void getTipStates(int n, int[] nArray) {
        assert (n >= 0 && n < this.tipCount);
        if (this.tipStates[n] == null) {
            throw new RuntimeException("Unset tip states");
        }
        System.arraycopy(this.tipStates[n], 0, nArray, 0, nArray.length);
    }

    @Override
    public void setTipPartials(int n, double[] dArray) {
        assert (n >= 0 && n < this.tipCount);
        if (this.partials[n] == null) {
            this.partials[n] = new double[this.partialsSize];
        }
        int n2 = 0;
        for (int i = 0; i < this.categoryCount; ++i) {
            System.arraycopy(dArray, 0, this.partials[n], n2, dArray.length);
            n2 += dArray.length;
        }
    }

    @Override
    public void setRootPrePartials(int[] nArray, int[] nArray2, int n) {
        if (n == 1) {
            int n2 = nArray2[0];
            int n3 = nArray[0];
            if (this.partials[n3] == null) {
                this.partials[n3] = new double[this.partialsSize];
            }
            int n4 = 0;
            for (int i = 0; i < this.categoryCount; ++i) {
                for (int j = 0; j < this.patternCount; ++j) {
                    System.arraycopy(this.stateFrequencies[n2], 0, this.partials[n3], n4, this.stateCount);
                    n4 += this.stateCount;
                }
            }
        }
    }

    @Override
    public void setPartials(int n, double[] dArray) {
        assert (this.partials[n] != null);
        System.arraycopy(dArray, 0, this.partials[n], 0, this.partialsSize);
    }

    @Override
    public void getPartials(int n, int n2, double[] dArray) {
        System.arraycopy(this.partials[n], 0, dArray, 0, this.partialsSize);
    }

    @Override
    public void getLogScaleFactors(int n, double[] dArray) {
        throw new UnsupportedOperationException("Not implemented. Email Marc Suchard if required (offer coauthorship for enhanced service)");
    }

    public void getScaleFactors(int n, double[] dArray) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void setEigenDecomposition(int n, double[] dArray, double[] dArray2, double[] dArray3) {
        int n2 = 0;
        for (int i = 0; i < this.stateCount; ++i) {
            for (int j = 0; j < this.stateCount; ++j) {
                for (int k = 0; k < this.stateCount; ++k) {
                    this.cMatrices[n][n2] = dArray[i * this.stateCount + k] * dArray2[k * this.stateCount + j];
                    ++n2;
                }
            }
        }
        System.arraycopy(dArray3, 0, this.eigenValues[n], 0, dArray3.length);
    }

    @Override
    public void setStateFrequencies(int n, double[] dArray) {
        System.arraycopy(dArray, 0, this.stateFrequencies[n], 0, this.stateCount);
    }

    @Override
    public void setCategoryWeights(int n, double[] dArray) {
        System.arraycopy(dArray, 0, this.categoryWeights[n], 0, this.categoryCount);
    }

    @Override
    public void setCategoryRates(double[] dArray) {
        System.arraycopy(dArray, 0, this.categoryRates, 0, this.categoryRates.length);
    }

    @Override
    public void setCategoryRatesWithIndex(int n, double[] dArray) {
        throw new UnsupportedOperationException("setCategoryRatesWithIndex not implemented in GeneralBeagleImpl");
    }

    @Override
    public void setTransitionMatrix(int n, double[] dArray, double d) {
        System.arraycopy(dArray, 0, this.matrices[n], 0, this.matrixSize);
    }

    @Override
    public void setDifferentialMatrix(int n, double[] dArray) {
        this.setTransitionMatrix(n, dArray, 0.0);
    }

    @Override
    public void getTransitionMatrix(int n, double[] dArray) {
        System.arraycopy(this.matrices[n], 0, dArray, 0, dArray.length);
    }

    @Override
    public void convolveTransitionMatrices(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = nArray2[i];
            int n4 = nArray3[i];
            for (int j = 0; j < this.categoryCount; ++j) {
                for (int k = 0; k < this.stateCount; ++k) {
                    for (int i2 = 0; i2 < this.stateCount; ++i2) {
                        for (int i3 = 0; i3 < this.stateCount; ++i3) {
                        }
                    }
                }
            }
        }
    }

    @Override
    public void addTransitionMatrices(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void transposeTransitionMatrices(int[] nArray, int[] nArray2, int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void updateTransitionMatrices(int n, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            double[] dArray2 = new double[this.stateCount];
            int n4 = 0;
            for (int j = 0; j < this.categoryCount; ++j) {
                int n5;
                for (n5 = 0; n5 < this.stateCount; ++n5) {
                    dArray2[n5] = Math.exp(this.eigenValues[n][n5] * dArray[i] * this.categoryRates[j]);
                }
                n5 = 0;
                for (int k = 0; k < this.stateCount; ++k) {
                    for (int i2 = 0; i2 < this.stateCount; ++i2) {
                        double d = 0.0;
                        for (int i3 = 0; i3 < this.stateCount; ++i3) {
                            d += this.cMatrices[n][n5] * dArray2[i3];
                            ++n5;
                        }
                        this.matrices[n3][n4] = d > 0.0 ? d : 0.0;
                        ++n4;
                    }
                }
            }
        }
    }

    @Override
    public void updateTransitionMatricesWithMultipleModels(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, double[] dArray, int n) {
        throw new UnsupportedOperationException("updateTransitionMatricesWithMultipleModels not implemented in GeneralBeagleImpl");
    }

    @Override
    public void updatePartials(int[] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[n3];
            int n5 = nArray[n3 + 3];
            int n6 = nArray[n3 + 4];
            int n7 = nArray[n3 + 5];
            int n8 = nArray[n3 + 6];
            n3 += 7;
            int n9 = 0;
            n9 = this.compactBufferCount == 0 ? this.updatePartialsPartials(n5, n6, n7, n8, n4) : (n5 < this.tipCount && this.tipStates[n5] != null ? (n7 < this.tipCount && this.tipStates[n7] != null ? this.updateStatesStates(n5, n6, n7, n8, n4) : this.updateStatesPartials(n5, n6, n7, n8, n4)) : (n7 < this.tipCount && this.tipStates[n7] != null ? this.updateStatesPartials(n7, n8, n5, n6, n4) : this.updatePartialsPartials(n5, n6, n7, n8, n4)));
            if (n9 <= 2) continue;
            this.rescalePartials(n4);
        }
    }

    @Override
    public void updatePrePartials(int[] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[n3];
            int n5 = nArray[n3 + 3];
            int n6 = nArray[n3 + 4];
            int n7 = nArray[n3 + 5];
            int n8 = nArray[n3 + 6];
            n3 += 7;
            int n9 = 0;
            n9 = this.updatePrePartialsPartials(n5, n6, n7, n8, n4);
            if (n9 <= 2) continue;
            this.rescalePartials(n4);
        }
    }

    @Override
    public void updatePrePartialsByPartition(int[] nArray, int n) {
        throw new BeagleException("updatePrePartialsByPartition", -1);
    }

    @Override
    public void calculateEdgeDifferentials(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, double[] dArray, double[] dArray2, double[] dArray3) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void calculateCrossProductDifferentials(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double[] dArray, int n, double[] dArray2, double[] dArray3) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void calculateEdgeDerivative(int[] nArray, int[] nArray2, int n, int[] nArray3, int[] nArray4, int n2, int n3, int n4, int[] nArray5, int n5, double[] dArray, double[] dArray2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void updatePartialsByPartition(int[] nArray, int n) {
        throw new UnsupportedOperationException("updatePartialsByPartition not implemented in GeneralBeagleImpl");
    }

    private void rescalePartials(int n) {
        double[] dArray = this.partials[n];
        int[] nArray = this.scalingFactorCounts[n];
        int n2 = 0;
        for (int i = 0; i < this.categoryCount; ++i) {
            for (int j = 0; j < this.patternCount; ++j) {
                int n3;
                double d = dArray[n2];
                for (n3 = 1; n3 < this.stateCount; ++n3) {
                    if (!(dArray[n2 + n3] > d)) continue;
                    d = dArray[n2 + n3];
                }
                n3 = Math.getExponent(d);
                if (n3 == 0) continue;
                int n4 = 126 - n3;
                double d2 = this.scalingFactors[n4];
                int n5 = n4;
                nArray[n5] = (int)((double)nArray[n5] + this.patternWeights[j]);
                for (int k = 0; k < this.stateCount; ++k) {
                    int n6 = n2++;
                    dArray[n6] = dArray[n6] * d2;
                }
            }
        }
    }

    private void rescalePartialsByPartition(int n) {
        throw new UnsupportedOperationException("rescalePartialsByPartition not implemented in GeneralBeagleImpl");
    }

    @Override
    public void setCPUThreadCount(int n) {
        throw new UnsupportedOperationException("setCPUThreadCount not implemented in GeneralBeagleImpl");
    }

    @Override
    public void accumulateScaleFactors(int[] nArray, int n, int n2) {
    }

    @Override
    public void removeScaleFactors(int[] nArray, int n, int n2) {
    }

    @Override
    public void copyScaleFactors(int n, int n2) {
    }

    @Override
    public void resetScaleFactors(int n) {
    }

    @Override
    public void accumulateScaleFactorsByPartition(int[] nArray, int n, int n2, int n3) {
    }

    @Override
    public void removeScaleFactorsByPartition(int[] nArray, int n, int n2, int n3) {
    }

    @Override
    public void resetScaleFactorsByPartition(int n, int n2) {
    }

    protected int updateStatesStates(int n, int n2, int n3, int n4, int n5) {
        int n6;
        double[] dArray = this.matrices[n2];
        double[] dArray2 = this.matrices[n4];
        int[] nArray = this.tipStates[n];
        int[] nArray2 = this.tipStates[n3];
        double[] dArray3 = this.partials[n5];
        int[] nArray3 = this.scalingFactorCounts[n5];
        for (n6 = 0; n6 < nArray3.length; ++n6) {
            nArray3[n6] = 0;
        }
        int n7 = 0;
        for (n6 = 0; n6 < this.categoryCount; ++n6) {
            for (int i = 0; i < this.patternCount; ++i) {
                int n8;
                int n9 = nArray[i];
                int n10 = nArray2[i];
                int n11 = n6 * this.matrixSize;
                if (n9 < this.stateCount && n10 < this.stateCount) {
                    for (n8 = 0; n8 < this.stateCount; ++n8) {
                        dArray3[n7] = dArray[n11 + n9] * dArray2[n11 + n10];
                        ++n7;
                        n11 += this.stateCount;
                    }
                    continue;
                }
                if (n9 < this.stateCount) {
                    for (n8 = 0; n8 < this.stateCount; ++n8) {
                        dArray3[n7] = dArray[n11 + n9];
                        ++n7;
                        n11 += this.stateCount;
                    }
                    continue;
                }
                if (n10 < this.stateCount) {
                    for (n8 = 0; n8 < this.stateCount; ++n8) {
                        dArray3[n7] = dArray2[n11 + n10];
                        ++n7;
                        n11 += this.stateCount;
                    }
                    continue;
                }
                for (n8 = 0; n8 < this.stateCount; ++n8) {
                    dArray3[n7] = 1.0;
                    ++n7;
                }
            }
        }
        return 0;
    }

    protected int updateStatesPartials(int n, int n2, int n3, int n4, int n5) {
        double[] dArray = this.matrices[n2];
        double[] dArray2 = this.matrices[n4];
        int[] nArray = this.tipStates[n];
        double[] dArray3 = this.partials[n3];
        double[] dArray4 = this.partials[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int[] nArray2 = this.scalingFactorCounts[n3];
        int[] nArray3 = this.scalingFactorCounts[n5];
        System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
        for (int i = 0; i < this.categoryCount; ++i) {
            for (int j = 0; j < this.patternCount; ++j) {
                int n9;
                double d;
                int n10;
                int n11 = nArray[j];
                int n12 = i * this.matrixSize;
                if (n11 < this.stateCount) {
                    for (n10 = 0; n10 < this.stateCount; ++n10) {
                        double d2 = dArray[n12 + n11];
                        d = 0.0;
                        for (n9 = 0; n9 < this.stateCount; ++n9) {
                            d += dArray2[n12] * dArray3[n7 + n9];
                            ++n12;
                        }
                        dArray4[n6] = d2 * d;
                        n8 |= Math.abs(Math.getExponent(dArray4[n6]));
                        ++n6;
                    }
                    n7 += this.stateCount;
                    continue;
                }
                for (n10 = 0; n10 < this.stateCount; ++n10) {
                    d = 0.0;
                    for (n9 = 0; n9 < this.stateCount; ++n9) {
                        d += dArray2[n12] * dArray3[n7 + n9];
                        ++n12;
                    }
                    dArray4[n6] = d;
                    n8 |= Math.abs(Math.getExponent(dArray4[n6]));
                    ++n6;
                }
                n7 += this.stateCount;
            }
        }
        return n8;
    }

    protected int updatePartialsPartials(int n, int n2, int n3, int n4, int n5) {
        int n6;
        double[] dArray = this.matrices[n2];
        double[] dArray2 = this.matrices[n4];
        double[] dArray3 = this.partials[n];
        double[] dArray4 = this.partials[n3];
        double[] dArray5 = this.partials[n5];
        int n7 = 0;
        int[] nArray = this.scalingFactorCounts[n];
        int[] nArray2 = this.scalingFactorCounts[n3];
        int[] nArray3 = this.scalingFactorCounts[n5];
        for (n6 = 0; n6 < nArray.length; ++n6) {
            nArray3[n6] = nArray[n6] + nArray2[n6];
        }
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < this.categoryCount; ++i) {
            for (n6 = 0; n6 < this.patternCount; ++n6) {
                int n10 = i * this.matrixSize;
                for (int j = 0; j < this.stateCount; ++j) {
                    double d = 0.0;
                    double d2 = 0.0;
                    for (int k = 0; k < this.stateCount; ++k) {
                        d2 += dArray[n10] * dArray3[n9 + k];
                        d += dArray2[n10] * dArray4[n9 + k];
                        ++n10;
                    }
                    dArray5[n8] = d2 * d;
                    n7 |= Math.abs(Math.getExponent(dArray5[n8]));
                    ++n8;
                }
                n9 += this.stateCount;
            }
        }
        return n7;
    }

    protected int updatePrePartialsPartials(int n, int n2, int n3, int n4, int n5) {
        int n6;
        double[] dArray = this.matrices[n2];
        double[] dArray2 = this.matrices[n4];
        double[] dArray3 = this.partials[n];
        double[] dArray4 = this.partials[n3];
        double[] dArray5 = this.partials[n5];
        int n7 = 0;
        int[] nArray = this.scalingFactorCounts[n];
        int[] nArray2 = this.scalingFactorCounts[n3];
        int[] nArray3 = this.scalingFactorCounts[n5];
        for (n6 = 0; n6 < nArray.length; ++n6) {
            nArray3[n6] = nArray[n6] + nArray2[n6];
        }
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < this.categoryCount; ++i) {
            for (n6 = 0; n6 < this.patternCount; ++n6) {
                int n10 = i * this.matrixSize;
                for (int j = 0; j < this.stateCount; ++j) {
                    int n11;
                    double d = 0.0;
                    for (n11 = 0; n11 < this.stateCount; ++n11) {
                        d += dArray2[n10] * dArray4[n9 + n11];
                        ++n10;
                    }
                    double d2 = d * dArray3[n9 + j];
                    n10 = i * this.matrixSize;
                    for (n11 = 0; n11 < this.stateCount; ++n11) {
                        int n12 = n9 + n11;
                        dArray5[n12] = dArray5[n12] + dArray[n10] * d2;
                        ++n10;
                    }
                    ++n8;
                }
                n9 += this.stateCount;
            }
        }
        return n7;
    }

    @Override
    public void calculateRootLogLikelihoods(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, double[] dArray) {
        int n2;
        int n3;
        assert (n == 1);
        double[] dArray2 = this.partials[nArray[0]];
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < this.patternCount; ++n3) {
            for (n2 = 0; n2 < this.stateCount; ++n2) {
                this.tmpPartials[n4] = dArray2[n5] * this.categoryWeights[nArray2[0]][0];
                ++n4;
                ++n5;
            }
        }
        for (n3 = 1; n3 < this.categoryCount; ++n3) {
            n4 = 0;
            for (n2 = 0; n2 < this.patternCount; ++n2) {
                for (int i = 0; i < this.stateCount; ++i) {
                    int n6 = n4++;
                    this.tmpPartials[n6] = this.tmpPartials[n6] + dArray2[n5] * this.categoryWeights[nArray2[0]][n3];
                    ++n5;
                }
            }
        }
        n4 = 0;
        dArray[0] = 0.0;
        for (n3 = 0; n3 < this.patternCount; ++n3) {
            double d = 0.0;
            for (int i = 0; i < this.stateCount; ++i) {
                d += this.stateFrequencies[nArray3[0]][i] * this.tmpPartials[n4];
                ++n4;
            }
            dArray[0] = dArray[0] + Math.log(d) * this.patternWeights[n3];
        }
        int[] nArray5 = this.scalingFactorCounts[nArray[0]];
        for (int i = 0; i < 254; ++i) {
            dArray[0] = dArray[0] - this.logScalingFactors[i] * (double)nArray5[i];
        }
    }

    @Override
    public void calculateRootLogLikelihoodsByPartition(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n, int n2, double[] dArray, double[] dArray2) {
        throw new UnsupportedOperationException("calculateRootLogLikelihoodsByPartition not implemented in GeneralBeagleImpl");
    }

    public void calculateEdgeLogLikelihoods(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8, int n, double[] dArray, double[] dArray2, double[] dArray3) {
        throw new UnsupportedOperationException("calculateEdgeLogLikelihoods not implemented in GeneralBeagleImpl");
    }

    @Override
    public void getSiteLogLikelihoods(double[] dArray) {
        throw new UnsupportedOperationException("getSiteLogLikelihoods not implemented in GeneralBeagleImpl");
    }

    @Override
    public InstanceDetails getDetails() {
        InstanceDetails instanceDetails = new InstanceDetails();
        instanceDetails.setResourceNumber(0);
        instanceDetails.setFlags(BeagleFlag.PRECISION_DOUBLE.getMask());
        return instanceDetails;
    }
}

