/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks.meta;

import java.awt.Color;
import java.util.List;
import moa.tasks.MainTask;
import moa.tasks.TaskThread;

public abstract class MetaMainTask
extends MainTask {
    private static final long serialVersionUID = 1L;
    protected boolean[] isLastSubtaskOnLevel = new boolean[0];
    protected String nameSuffix = "";
    protected Color colorCoding = Color.BLACK;

    public abstract List<? extends TaskThread> getSubtaskThreads();

    public String getDisplayName() {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < this.getSubtaskLevel() - 1; ++i) {
            if (this.isLastSubtaskOnLevel[i]) {
                name.append("         ");
                continue;
            }
            name.append("\u2502      ");
        }
        if (this.getSubtaskLevel() > 0) {
            if (this.isLastSubtaskOnLevel[this.getSubtaskLevel() - 1]) {
                name.append("\u2514\u2500\u2500");
            } else {
                name.append("\u251c\u2500\u2500");
            }
        }
        name.append(this.getClass().getSimpleName());
        name.append(" ").append(this.nameSuffix);
        return name.toString();
    }

    public void setNameSuffix(String suffix) {
        this.nameSuffix = suffix;
    }

    public void setIsLastSubtaskOnLevel(boolean[] parentIsLastSubtaskList, boolean isLastSubtask) {
        this.isLastSubtaskOnLevel = new boolean[parentIsLastSubtaskList.length + 1];
        for (int i = 0; i < parentIsLastSubtaskList.length; ++i) {
            this.isLastSubtaskOnLevel[i] = parentIsLastSubtaskList[i];
        }
        this.isLastSubtaskOnLevel[parentIsLastSubtaskList.length] = isLastSubtask;
    }

    public int getSubtaskLevel() {
        return this.isLastSubtaskOnLevel.length;
    }

    public boolean isSubtask() {
        return this.getSubtaskLevel() > 0;
    }

    public void setColorCoding(Color newColorCoding) {
        this.colorCoding = newColorCoding;
    }

    public Color getColorCoding() {
        return this.colorCoding;
    }
}

