/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.files.ChoiceProvider;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class SmartCombo
extends JTextField {
    private ChoiceProvider choiceProvider;
    private JPopupMenu choiceMenu = new JPopupMenu();

    public SmartCombo(int n, ChoiceProvider choiceProvider, boolean bl) {
        super(n);
        this.choiceMenu.setLightWeightPopupEnabled(bl);
        this.choiceProvider = choiceProvider;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10 && SmartCombo.this.choiceMenu.isVisible()) {
                    SmartCombo.this.selectChoice();
                } else if ((n == 127 || n == 8) && keyEvent.getModifiers() == 0) {
                    SmartCombo.this.choiceMenu.setVisible(false);
                } else if ((n != 37 && n != 39 || keyEvent.getModifiers() != 0) && (n != 38 && n != 40 || keyEvent.getModifiers() != 0)) {
                    SmartCombo.this.checkNewProposals();
                }
            }
        });
    }

    protected void onChoiceChanged(String string) {
        this.setText(string);
        this.setCaretPosition(string.length());
    }

    protected String getStartString() {
        String string = this.getText();
        int n = this.getCaretPosition();
        string = string.substring(0, n);
        return string;
    }

    private void selectChoice() {
        AbstractButton abstractButton = null;
        for (int i = 0; i < this.choiceMenu.getComponentCount() && abstractButton == null; ++i) {
            JMenuItem jMenuItem = (JMenuItem)this.choiceMenu.getComponent(i);
            if (!jMenuItem.isArmed()) continue;
            abstractButton = jMenuItem;
        }
        if (abstractButton != null) {
            this.onChoiceChanged(abstractButton.getText());
            this.choiceMenu.setVisible(false);
        }
    }

    private void checkNewProposals() {
        this.choiceMenu.setVisible(false);
        String string = this.getStartString();
        if (string.length() > 0) {
            String[] stringArray = this.choiceProvider.getStringsLike(string);
            if (stringArray.length == 0) {
                this.onChoiceChanged(string);
            } else {
                this.choiceMenu.removeAll();
                for (int i = 0; i < stringArray.length; ++i) {
                    final JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            SmartCombo.this.onChoiceChanged(jMenuItem.getText());
                        }
                    });
                    this.choiceMenu.add(jMenuItem);
                }
                Dimension dimension = this.choiceMenu.getPreferredSize();
                int n = this.getSize().width;
                if (n > dimension.width) {
                    dimension.width = n;
                }
                this.choiceMenu.show(this, 0, this.getSize().height);
                this.requestFocusInWindow();
            }
        }
    }
}

