/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.variables.scheduling;

import choco.kernel.common.util.tools.TaskUtils;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.AbstractTask;
import choco.kernel.solver.variables.scheduling.ITask;

public final class HTask
extends AbstractTask {
    private final ITask task;
    private IntDomainVar usage;
    private final IStateInt estH;
    private final IStateInt lctH;

    public HTask(ITask task, IntDomainVar usage, IStateInt estH, IStateInt lctH) {
        this.task = task;
        this.usage = usage;
        this.estH = estH;
        this.lctH = lctH;
    }

    @Override
    public final boolean isPreemptionAllowed() {
        return this.task.isPreemptionAllowed();
    }

    @Override
    public int getECT() {
        int valR = this.task.getECT();
        if (TaskUtils.isRegular(this.usage)) {
            return valR;
        }
        int valH = this.estH.get() + this.task.getMinDuration();
        return valR > valH ? valR : valH;
    }

    @Override
    public int getEST() {
        int valR = this.task.getEST();
        if (TaskUtils.isRegular(this.usage)) {
            return valR;
        }
        int valH = this.estH.get();
        return valR > valH ? valR : valH;
    }

    @Override
    public int getID() {
        return this.task.getID();
    }

    @Override
    public int getLCT() {
        int valR = this.task.getLCT();
        if (TaskUtils.isRegular(this.usage)) {
            return valR;
        }
        int valH = this.lctH.get();
        return valR > valH ? valH : valR;
    }

    @Override
    public int getLST() {
        int valR = this.task.getLST();
        if (TaskUtils.isRegular(this.usage)) {
            return valR;
        }
        int valH = this.lctH.get() - this.task.getMinDuration();
        return valR > valH ? valH : valR;
    }

    @Override
    public int getMaxDuration() {
        int valR = this.task.getMaxDuration();
        if (TaskUtils.isRegular(this.usage)) {
            return valR;
        }
        int valH = this.lctH.get() - this.estH.get();
        return valR > valH ? valH : valR;
    }

    @Override
    public int getMinDuration() {
        return this.task.getMinDuration();
    }

    @Override
    public String getName() {
        return this.task.getName();
    }

    @Override
    public boolean hasConstantDuration() {
        return this.task.hasConstantDuration();
    }

    @Override
    public boolean isScheduled() {
        return this.task.isScheduled();
    }
}

