/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.C45Rules;

import keel.Algorithms.Rule_Learning.C45Rules.Algorithm;
import keel.Algorithms.Rule_Learning.C45Rules.Itemset;
import keel.Algorithms.Rule_Learning.C45Rules.MyDataset;
import keel.Algorithms.Rule_Learning.C45Rules.SelectCut;
import keel.Algorithms.Rule_Learning.C45Rules.Tree;
import keel.Algorithms.Rule_Learning.C45Rules.parseParameters;

public class C45
extends Algorithm {
    private Tree root;
    private boolean prune = false;
    private float confidence = 0.25f;
    private int minItemsets = 2;
    private double[] priorsProbabilities;
    private static int marginResolution = 500;
    private double[] marginCounts;
    private double classPriorsSum;

    public C45(parseParameters paramFile) throws Exception {
        try {
            long startTime = System.currentTimeMillis();
            modelFileName = paramFile.getTrainingInputFile();
            trainFileName = paramFile.getValidationInputFile();
            testFileName = paramFile.getTestInputFile();
            this.confidence = Float.parseFloat(paramFile.getParameter(1));
            this.minItemsets = Integer.parseInt(paramFile.getParameter(2));
            if (this.confidence < 0.0f || this.confidence > 1.0f) {
                this.confidence = 0.25f;
                System.err.println("Error: Confidence must be in the interval [0,1]");
                System.err.println("Using default value: 0.25");
            }
            if (this.minItemsets <= 0) {
                this.minItemsets = 2;
                System.err.println("Error: itemsetPerLeaf must be greater than 0");
                System.err.println("Using default value: 2");
            }
            this.prune = false;
            this.modelDataset = new MyDataset(modelFileName, true);
            this.trainDataset = new MyDataset(trainFileName, false);
            this.testDataset = new MyDataset(testFileName, false);
            this.priorsProbabilities = new double[this.modelDataset.numClasses()];
            this.priorsProbabilities();
            this.marginCounts = new double[marginResolution + 1];
            this.generateTree(this.modelDataset);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    public void generateTree(MyDataset itemsets) throws Exception {
        SelectCut selectCut = new SelectCut(this.minItemsets, itemsets);
        this.root = new Tree(selectCut, this.prune, this.confidence);
        this.root.buildTree(itemsets);
    }

    public double evaluateItemset(Itemset itemset) throws Exception {
        Itemset classMissing = (Itemset)itemset.copy();
        double prediction = 0.0;
        classMissing.setDataset(itemset.getDataset());
        classMissing.setClassMissing();
        double[] classification = this.classificationForItemset(classMissing);
        prediction = C45.maxIndex(classification);
        this.updateStats(classification, itemset, itemset.numClasses());
        return prediction;
    }

    private void updateStats(double[] predictedClassification, Itemset itemset, int nClasses) {
        int actualClass = (int)itemset.getClassValue();
        if (!itemset.classIsMissing()) {
            this.updateMargins(predictedClassification, actualClass, nClasses);
            int predictedClass = -1;
            double bestProb = 0.0;
            for (int i = 0; i < nClasses; ++i) {
                if (!(predictedClassification[i] > bestProb)) continue;
                predictedClass = i;
                bestProb = predictedClassification[i];
            }
            if (predictedClass < 0) {
                return;
            }
            double predictedProb = Math.max(Double.MIN_VALUE, predictedClassification[actualClass]);
            double priorProb = Math.max(Double.MIN_VALUE, this.priorsProbabilities[actualClass] / this.classPriorsSum);
        }
    }

    public final double[] classificationForItemset(Itemset itemset) throws Exception {
        return this.root.classificationForItemset(itemset);
    }

    private void updateMargins(double[] predictedClassification, int actualClass, int nClasses) {
        int bin;
        double probActual = predictedClassification[actualClass];
        double probNext = 0.0;
        for (int i = 0; i < nClasses; ++i) {
            if (i == actualClass || !(predictedClassification[i] > probNext)) continue;
            probNext = predictedClassification[i];
        }
        double margin = probActual - probNext;
        int n = bin = (int)((margin + 1.0) / 2.0 * (double)marginResolution);
        this.marginCounts[n] = this.marginCounts[n] + 1.0;
    }

    private boolean isBoolean(String value) {
        return value.equalsIgnoreCase("TRUE") || value.equalsIgnoreCase("FALSE");
    }

    public static int maxIndex(double[] doubles) {
        double maximum = 0.0;
        int maxIndex = 0;
        for (int i = 0; i < doubles.length; ++i) {
            if (i != 0 && !(doubles[i] > maximum)) continue;
            maxIndex = i;
            maximum = doubles[i];
        }
        return maxIndex;
    }

    public void priorsProbabilities() throws Exception {
        int i;
        for (i = 0; i < this.modelDataset.numClasses(); ++i) {
            this.priorsProbabilities[i] = 1.0;
        }
        this.classPriorsSum = this.modelDataset.numClasses();
        for (i = 0; i < this.modelDataset.numItemsets(); ++i) {
            if (this.modelDataset.itemset(i).classIsMissing()) continue;
            try {
                int n = (int)this.modelDataset.itemset(i).getClassValue();
                this.priorsProbabilities[n] = this.priorsProbabilities[n] + this.modelDataset.itemset(i).getWeight();
                this.classPriorsSum += this.modelDataset.itemset(i).getWeight();
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public String toString() {
        return this.root.toString();
    }

    public Tree getTree() {
        return this.root;
    }
}

