/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.DataB;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.EARMGAProcess;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.Intervals;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.myDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.parseParameters;
import keel.Dataset.Attributes;
import org.core.Files;
import org.core.Randomize;

public class EARMGA {
    myDataset trans;
    String assoc_rules_fname;
    String sup_rules_fname;
    String valuesOrderFilename;
    EARMGAProcess ap;
    DataB dataBase;
    ArrayList<AssociationRule> assoc_rules;
    private String fileTime;
    private String fileHora;
    private String namedataset;
    private int popsize;
    private int nTrials;
    private double alpha;
    private int nIntervals;
    private int kItemsets;
    private double ps;
    private double pc;
    private double pm;
    private double minSupport;
    long startTime;
    long totalTime;
    private boolean somethingWrong = false;

    public EARMGA() {
    }

    public EARMGA(parseParameters parameters) {
        this.startTime = System.currentTimeMillis();
        this.trans = new myDataset();
        try {
            this.namedataset = parameters.getTransactionsInputFile();
            System.out.println("\nReading the transaction set: " + parameters.getTransactionsInputFile());
            this.trans.readDataSet(parameters.getTransactionsInputFile());
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input transaction set: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.trans.hasMissingAttributes();
        this.assoc_rules_fname = parameters.getAssociationRulesFile();
        this.sup_rules_fname = parameters.getOutputFile(0);
        this.valuesOrderFilename = parameters.getOutputFile(1);
        this.fileTime = parameters.getOutputFile(0).substring(0, parameters.getOutputFile(0).lastIndexOf(47)) + "/time.txt";
        this.fileHora = parameters.getOutputFile(0).substring(0, parameters.getOutputFile(0).lastIndexOf(47)) + "/hora.txt";
        long seed = Long.parseLong(parameters.getParameter(0));
        this.kItemsets = Integer.parseInt(parameters.getParameter(1));
        this.popsize = Integer.parseInt(parameters.getParameter(2));
        this.nTrials = Integer.parseInt(parameters.getParameter(3));
        this.alpha = Double.parseDouble(parameters.getParameter(4));
        this.ps = Double.parseDouble(parameters.getParameter(5));
        this.pc = Double.parseDouble(parameters.getParameter(6));
        this.pm = Double.parseDouble(parameters.getParameter(7));
        this.nIntervals = Integer.parseInt(parameters.getParameter(8));
        if (this.kItemsets > this.trans.getnVars()) {
            this.kItemsets = this.trans.getnVars();
        }
        Randomize.setSeed(seed);
        this.minSupport = 0.001;
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found");
            System.err.println("Aborting the program");
        } else {
            this.dataBase = new DataB(this.nIntervals, this.trans);
            this.ap = new EARMGAProcess(this.trans, this.dataBase, this.nTrials, this.popsize, this.kItemsets, this.ps, this.pc, this.pm, this.alpha);
            this.ap.run();
            this.assoc_rules = this.ap.getSetRules(this.minSupport);
            try {
                PrintWriter rule_writer = new PrintWriter(this.assoc_rules_fname);
                PrintWriter sup_writer = new PrintWriter(this.sup_rules_fname);
                PrintWriter valuesOrder_writer = new PrintWriter(this.valuesOrderFilename);
                rule_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                rule_writer.println("<association_rules>");
                sup_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                sup_writer.println("<values>");
                valuesOrder_writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                valuesOrder_writer.println("<values>");
                for (int i = 0; i < this.assoc_rules.size(); ++i) {
                    int j;
                    AssociationRule a_r = this.assoc_rules.get(i);
                    ArrayList<Gene> ant = a_r.getAntecedent();
                    ArrayList<Gene> cons = a_r.getConsequent();
                    rule_writer.println("<rule id=\"" + i + "\">");
                    sup_writer.println("<rule id=\"" + i + "\" rule_support=\"" + EARMGAProcess.roundDouble(a_r.getAll_support(), 2) + "\" antecedent_support=\"" + EARMGAProcess.roundDouble(a_r.getSupport_Ant(), 2) + "\" consequent_support=\"" + EARMGAProcess.roundDouble(a_r.getSupport_cons(), 2) + "\" confidence=\"" + EARMGAProcess.roundDouble(a_r.getConfidence(), 2) + "\" lift=\"" + EARMGAProcess.roundDouble(a_r.getLift(), 2) + "\" conviction=\"" + EARMGAProcess.roundDouble(a_r.getConv(), 2) + "\" certainFactor=\"" + EARMGAProcess.roundDouble(a_r.getCF(), 2) + "\" netConf=\"" + EARMGAProcess.roundDouble(a_r.getNetConf(), 2) + "\" yulesQ=\"" + EARMGAProcess.roundDouble(a_r.getYulesQ(), 2) + "\" nAttributes=\"" + (a_r.getAntecedent().size() + a_r.getConsequent().size()) + "\"/>");
                    rule_writer.println("<antecedents>");
                    for (j = 0; j < ant.size(); ++j) {
                        Gene g_ant = ant.get(j);
                        this.createRule(g_ant, rule_writer);
                    }
                    rule_writer.println("</antecedents>");
                    rule_writer.println("<consequents>");
                    for (j = 0; j < cons.size(); ++j) {
                        Gene g_cons = cons.get(j);
                        this.createRule(g_cons, rule_writer);
                    }
                    rule_writer.println("</consequents>");
                    rule_writer.println("</rule>");
                }
                rule_writer.println("</association_rules>");
                sup_writer.println("</values>");
                rule_writer.close();
                sup_writer.close();
                valuesOrder_writer.print(this.ap.printRules(this.assoc_rules));
                valuesOrder_writer.println("</values>");
                valuesOrder_writer.close();
                this.totalTime = System.currentTimeMillis() - this.startTime;
                this.writeTime();
                System.out.println("Algorithm Finished");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeTime() {
        String stringOut = new String("");
        stringOut = "" + this.totalTime / 1000L + "  " + this.namedataset + this.assoc_rules_fname + "\n";
        Files.addToFile(this.fileTime, stringOut);
        this.totalTime /= 1000L;
        long seg = this.totalTime % 60L;
        this.totalTime /= 60L;
        long min = this.totalTime % 60L;
        long hor = this.totalTime / 60L;
        stringOut = "";
        stringOut = hor < 10L ? stringOut + "0" + hor + ":" : stringOut + hor + ":";
        stringOut = min < 10L ? stringOut + "0" + min + ":" : stringOut + min + ":";
        stringOut = seg < 10L ? stringOut + "0" + seg : stringOut + seg;
        stringOut = stringOut + "  " + this.assoc_rules_fname + "\n";
        Files.addToFile(this.fileHora, stringOut);
    }

    private void createRule(Gene g, PrintWriter w) {
        int attr = g.getAttr();
        ArrayList<Integer> value = g.getValue();
        w.print("<attribute name=\"" + Attributes.getAttribute(attr).getName() + "\" value=\"");
        if (g.getType() == 0) {
            for (int i = 0; i < value.size() - 1; ++i) {
                w.print(Attributes.getAttribute(attr).getNominalValue(value.get(i)));
            }
            w.print(Attributes.getAttribute(attr).getNominalValue(value.get(value.size() - 1)));
        } else {
            Intervals inter;
            for (int i = 0; i < value.size() - 1; ++i) {
                inter = this.dataBase.getInterval(attr, value.get(i));
                w.print("[" + inter.getLeft() + ", " + inter.getRight() + "]");
            }
            inter = this.dataBase.getInterval(attr, value.get(value.size() - 1));
            w.print("[" + inter.getLeft() + ", " + inter.getRight() + "]");
        }
        w.println("\" />");
    }
}

