/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.RE_SL_Methods.MamWM;

import keel.Algorithms.RE_SL_Methods.MamWM.Difuso;
import keel.Algorithms.RE_SL_Methods.MamWM.TipoIntervalo;

class BaseD {
    public Difuso[][] BaseDatos;
    public int n_variables;
    public int[] n_etiquetas;
    public TipoIntervalo[] extremos;
    public TipoIntervalo[][] intervalos;

    public BaseD(int MaxEtiquetas, int n_var) {
        int i;
        this.n_variables = n_var;
        this.intervalos = new TipoIntervalo[this.n_variables][MaxEtiquetas];
        this.BaseDatos = new Difuso[this.n_variables][MaxEtiquetas];
        for (i = 0; i < this.n_variables; ++i) {
            this.BaseDatos[i] = new Difuso[MaxEtiquetas];
            this.intervalos[i] = new TipoIntervalo[MaxEtiquetas];
            for (int j = 0; j < MaxEtiquetas; ++j) {
                this.BaseDatos[i][j] = new Difuso();
                this.intervalos[i][j] = new TipoIntervalo();
            }
        }
        this.n_etiquetas = new int[this.n_variables];
        this.extremos = new TipoIntervalo[this.n_variables];
        for (i = 0; i < this.n_variables; ++i) {
            this.extremos[i] = new TipoIntervalo();
        }
    }

    public double Asigna(double val, double tope) {
        if (val > -1.0E-4 && val < 1.0E-4) {
            return 0.0;
        }
        if (val > tope - 1.0E-4 && val < tope + 1.0E-4) {
            return tope;
        }
        return val;
    }

    public void Semantica() {
        double[] punto = new double[3];
        double[] punto_medio = new double[2];
        for (int var = 0; var < this.n_variables; ++var) {
            double marca = (this.extremos[var].max - this.extremos[var].min) / ((double)this.n_etiquetas[var] - 1.0);
            for (int etq = 0; etq < this.n_etiquetas[var]; ++etq) {
                double valor = this.extremos[var].min + marca * (double)(etq - 1);
                this.BaseDatos[var][etq].x0 = this.Asigna(valor, this.extremos[var].max);
                valor = this.extremos[var].min + marca * (double)etq;
                this.BaseDatos[var][etq].x2 = this.BaseDatos[var][etq].x1 = this.Asigna(valor, this.extremos[var].max);
                valor = this.extremos[var].min + marca * (double)(etq + 1);
                this.BaseDatos[var][etq].x3 = this.Asigna(valor, this.extremos[var].max);
                this.BaseDatos[var][etq].y = 1.0;
                this.BaseDatos[var][etq].Nombre = "V" + (var + 1);
                this.BaseDatos[var][etq].Etiqueta = "E" + (etq + 1);
            }
        }
    }
}

