/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jebl.evolution.align.AlignmentResult;
import jebl.evolution.align.ProfileCharacter;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.sequences.Sequence;

class Profile {
    ProfileCharacter[] profile;
    private final int alphabetSize;
    int sequenceCount;
    private boolean automaticallyCalculatedAlphabetSize = false;
    private Map<Integer, String> paddedSequences = new HashMap<Integer, String>();
    private boolean supportsFreeEndGaps = false;
    private boolean isImmutable = false;

    public String getSequence(int sequenceNumber) {
        return this.paddedSequences.get(sequenceNumber);
    }

    public Profile(int alphabetSize) {
        this.alphabetSize = alphabetSize;
        if (alphabetSize < 0) {
            throw new IllegalArgumentException("Nonnegative alphabet size expected, got " + alphabetSize);
        }
    }

    public Profile(int sequenceNumber, String sequence) {
        this(Profile.calculateAlphabetSize(new String[]{sequence}));
        this.addSequence(sequenceNumber, sequence);
        this.automaticallyCalculatedAlphabetSize = true;
    }

    public static Profile createImmutableProfile(int sequenceNumber, String sequence) {
        int alphabetSize = Profile.calculateAlphabetSize(new String[]{sequence});
        Profile profile = new Profile(alphabetSize);
        profile.isImmutable = true;
        profile.automaticallyCalculatedAlphabetSize = true;
        profile.sequenceCount = 1;
        sequence = sequence.toUpperCase();
        profile.paddedSequences.put(sequenceNumber, sequence);
        int length = sequence.length();
        profile.profile = new ProfileCharacter[length];
        for (int i = 0; i < length; ++i) {
            profile.profile[i] = ProfileCharacter.getImmutableProfileCharacter(sequence.charAt(i));
        }
        return profile;
    }

    private void assertMutable() {
        if (this.isImmutable) {
            throw new IllegalArgumentException("This profile is immutable");
        }
    }

    public Profile(Alignment alignment, int alphabetSize) {
        this(alignment, alphabetSize, 0);
    }

    public Profile(Alignment alignment, int alphabetSize, int offset) {
        this.alphabetSize = alphabetSize;
        List<Sequence> sequenceList = alignment.getSequenceList();
        for (int i = 0; i < sequenceList.size(); ++i) {
            this.addSequence(i + offset, sequenceList.get(i).getString());
        }
    }

    public int getNumberOfSequences() {
        return this.sequenceCount;
    }

    public int length() {
        return this.profile.length;
    }

    private static ProfileCharacter[] createProfile(String sequence, int alphabetSize) {
        int length = sequence.length();
        ProfileCharacter[] results = new ProfileCharacter[length];
        for (int i = 0; i < length; ++i) {
            ProfileCharacter profile = new ProfileCharacter(alphabetSize);
            profile.addCharacter(sequence.charAt(i), 1);
            results[i] = profile;
        }
        return results;
    }

    void addSequence(int sequenceNumber, String sequence) {
        this.assertMutable();
        sequence = sequence.toUpperCase();
        if (this.automaticallyCalculatedAlphabetSize) {
            throw new IllegalStateException("if the constructor 'public Profile(int sequenceNumber,String sequence)'  is used, it's not safe to add new sequences");
        }
        if (this.supportsFreeEndGaps) {
            sequence = Profile.supportFreeEndGaps(sequence);
        }
        ++this.sequenceCount;
        if (this.sequenceCount == 1) {
            this.profile = Profile.createProfile(sequence, this.alphabetSize);
        } else {
            assert (this.profile.length == sequence.length());
            for (int i = 0; i < this.profile.length; ++i) {
                ProfileCharacter character = this.profile[i];
                character.addCharacter(sequence.charAt(i), 1);
            }
        }
        this.paddedSequences.put(sequenceNumber, sequence);
    }

    public void remove(Profile remove) {
        this.assertMutable();
        int size = this.length();
        assert (size == remove.length());
        for (int i = 0; i < size; ++i) {
            this.profile[i].removeProfileCharacter(remove.profile[i]);
        }
        this.sequenceCount -= remove.sequenceCount;
        for (Integer sequenceNumber : remove.paddedSequences.keySet()) {
            this.paddedSequences.remove(sequenceNumber);
        }
        this.trim();
    }

    private void trim() {
        int i;
        this.assertMutable();
        int gapCount = 0;
        int count = 0;
        for (ProfileCharacter character : this.profile) {
            if (character.isAllGaps()) {
                ++gapCount;
                continue;
            }
            ++count;
        }
        if (gapCount == 0) {
            return;
        }
        ProfileCharacter[] characters = new ProfileCharacter[count];
        char[][] sequences = new char[this.sequenceCount][];
        char[][] newSequences = new char[this.sequenceCount][];
        int[] sequenceNumbers = new int[this.sequenceCount];
        for (i = 0; i < this.sequenceCount; ++i) {
            newSequences[i] = new char[count];
        }
        i = 0;
        for (Map.Entry<Integer, String> entry : this.paddedSequences.entrySet()) {
            sequenceNumbers[i] = entry.getKey();
            sequences[i++] = entry.getValue().toCharArray();
        }
        assert (i == this.sequenceCount);
        int index = 0;
        int sourceIndex = 0;
        for (ProfileCharacter character : this.profile) {
            if (character.isAllGaps()) {
                ++sourceIndex;
                continue;
            }
            characters[index] = character;
            for (int j = 0; j < this.sequenceCount; ++j) {
                newSequences[j][index] = sequences[j][sourceIndex];
            }
            ++sourceIndex;
            ++index;
        }
        for (int j = 0; j < this.sequenceCount; ++j) {
            String sequence = new String(newSequences[j]);
            assert (sequence.length() == count);
            this.paddedSequences.put(sequenceNumbers[j], sequence);
        }
        this.profile = characters;
    }

    public static Profile combine(Profile profile1, Profile profile2, AlignmentResult result1, AlignmentResult result2) {
        String sequence;
        int size = result1.size;
        int alphabetSize = Math.max(profile1.alphabetSize, profile2.alphabetSize);
        Profile result = new Profile(alphabetSize);
        result.profile = new ProfileCharacter[size];
        int index1 = 0;
        int index2 = 0;
        for (int i = 0; i < size; ++i) {
            ProfileCharacter character = new ProfileCharacter(alphabetSize);
            if (result1.values[i]) {
                character.addProfileCharacter(profile1.profile[index1++]);
            } else {
                character.addGaps(profile1.sequenceCount);
            }
            if (result2.values[i]) {
                character.addProfileCharacter(profile2.profile[index2++]);
            } else {
                character.addGaps(profile2.sequenceCount);
            }
            result.profile[i] = character;
        }
        for (Map.Entry<Integer, String> entry : profile1.paddedSequences.entrySet()) {
            sequence = entry.getValue();
            sequence = Profile.buildAlignmentString(sequence, result1);
            result.paddedSequences.put(entry.getKey(), sequence);
        }
        for (Map.Entry<Integer, String> entry : profile2.paddedSequences.entrySet()) {
            sequence = entry.getValue();
            sequence = Profile.buildAlignmentString(sequence, result2);
            result.paddedSequences.put(entry.getKey(), sequence);
        }
        result.sequenceCount = profile1.sequenceCount + profile2.sequenceCount;
        assert (result.sequenceCount == result.paddedSequences.size());
        return result;
    }

    public static int calculateAlphabetSize(String[] sequences) {
        int total = 0;
        boolean[] found = new boolean[127];
        for (String sequence : sequences) {
            for (char character : sequence.toCharArray()) {
                if (!found[character]) {
                    ++total;
                }
                found[character] = true;
            }
        }
        return total;
    }

    public static String buildAlignmentString(String sequence, AlignmentResult result) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (int i = 0; i < result.size; ++i) {
            if (result.values[i]) {
                builder.append(sequence.charAt(index++));
                continue;
            }
            builder.append('-');
        }
        assert (index == sequence.length());
        return builder.toString();
    }

    public void print(boolean displaySequences) {
        if (displaySequences) {
            int maximum = 0;
            for (int k = 0; k < this.paddedSequences.size(); ++k) {
                String sequence = this.paddedSequences.get(k);
                maximum = Math.max(maximum, sequence.length());
                System.out.println(sequence);
            }
            for (int i = 0; i < maximum; ++i) {
                System.out.print(i % 10);
            }
        }
        System.out.println();
        int count = 0;
        int index = 0;
        for (ProfileCharacter character : this.profile) {
            System.out.print(" " + index++ + ":");
            if ((count += character.print()) <= 800000) continue;
            count = 0;
            System.out.println();
        }
        System.out.println();
    }

    public String toString(int offset, int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            ProfileCharacter character = this.profile[offset + i];
            result.append(character.toString());
        }
        return result.toString();
    }

    static String supportFreeEndGaps(String sequence) {
        int i;
        char[] characters = sequence.toCharArray();
        int count = characters.length;
        int highestNonGapIndex = 0;
        int lowestNonGapIndex = count;
        for (i = 0; i < count; ++i) {
            if (characters[i] == '-') continue;
            lowestNonGapIndex = i;
            break;
        }
        for (i = count - 1; i >= 0; --i) {
            if (characters[i] == '-') continue;
            highestNonGapIndex = i;
            break;
        }
        StringBuilder result = new StringBuilder(count);
        for (int i2 = 0; i2 < count; ++i2) {
            if (i2 < lowestNonGapIndex || i2 > highestNonGapIndex) {
                result.append('_');
                continue;
            }
            result.append(characters[i2]);
        }
        return result.toString();
    }

    public Profile supportFreeEndGaps() {
        if (this.supportsFreeEndGaps) {
            return this;
        }
        if (this.sequenceCount < 2) {
            return this;
        }
        Profile result = new Profile(this.alphabetSize + 1);
        result.supportsFreeEndGaps = true;
        for (Map.Entry<Integer, String> entry : this.paddedSequences.entrySet()) {
            String sequence = entry.getValue();
            result.addSequence(entry.getKey(), sequence);
        }
        return result;
    }
}

