/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.Codons;
import dr.inference.model.Parameter;
import dr.oldevomodel.substmodel.AbstractCodonModel;
import dr.oldevomodel.substmodel.AbstractPCARateMatrix;
import dr.oldevomodel.substmodel.FrequencyModel;

public class PCACodonModel
extends AbstractCodonModel {
    protected AbstractPCARateMatrix rateMatrix;
    protected byte[] rateMap;
    private Parameter pcFactors;
    static String format1 = "%2.1e";
    static String format2 = "%2.4e";

    public PCACodonModel(Codons codons, AbstractPCARateMatrix abstractPCARateMatrix, Parameter parameter, FrequencyModel frequencyModel) {
        super("pcaCodonModel", codons, frequencyModel);
        int n;
        this.rateMatrix = abstractPCARateMatrix;
        this.pcFactors = parameter;
        double[] dArray = abstractPCARateMatrix.getStartFacs();
        double d = 0.0;
        for (n = 0; n < this.pcFactors.getDimension(); ++n) {
            d += dArray[n];
        }
        for (n = 0; n < this.pcFactors.getDimension(); ++n) {
            this.pcFactors.setParameterValueQuietly(n, dArray[n] / d);
        }
        this.addVariable(this.pcFactors);
        this.pcFactors.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, this.pcFactors.getDimension()));
    }

    @Override
    public void setupRelativeRates() {
        int n;
        double[] dArray = this.rateMatrix.getMeans();
        double[] dArray2 = this.rateMatrix.getScales();
        for (n = 0; n < this.rateCount; ++n) {
            this.relativeRates[n] = dArray[n];
        }
        for (n = 0; n < this.pcFactors.getDimension(); ++n) {
            double[] dArray3 = this.rateMatrix.getPCAt(n);
            double d = this.pcFactors.getParameterValue(n);
            for (int i = 0; i < this.rateCount; ++i) {
                int n2 = i;
                this.relativeRates[n2] = this.relativeRates[n2] + d * dArray3[i] * dArray2[i];
            }
        }
        for (n = 0; n < this.rateCount; ++n) {
            if (!(this.relativeRates[n] < 0.0)) continue;
            this.relativeRates[n] = 0.0;
        }
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void frequenciesChanged() {
    }

    public double getPcFactor(int n) {
        return this.pcFactors.getParameterValue(n);
    }

    public double[] getPcFactor() {
        return this.pcFactors.getParameterValues();
    }

    public void setPcFactor(int n, double d) {
        this.pcFactors.setParameterValue(n, d);
        this.updateMatrix = true;
    }

    public void setPcFactor(double[] dArray) {
        for (int i = 0; i < this.pcFactors.getDimension(); ++i) {
            this.pcFactors.setParameterValue(i, dArray[i]);
        }
        this.updateMatrix = true;
    }

    public String toXHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<em>PCA Codon Model</em>");
        return stringBuffer.toString();
    }

    public String printQ() {
        double[][] dArray = this.getQ();
        if (dArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    stringBuffer.append(String.format(format1, dArray[i][j]));
                    stringBuffer.append("\t");
                }
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
        return "No Q ready.";
    }

    public String printRelRates() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.relativeRates.length; ++i) {
            stringBuffer.append(String.format(format2, this.relativeRates[i]));
            stringBuffer.append("\t");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

