/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.speciation.SpeciationModel;
import dr.evomodel.speciation.SpeciationModelGradientProvider;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NewBirthDeathSerialSamplingModel
extends SpeciationModel
implements SpeciationModelGradientProvider,
Citable {
    Parameter samplingProbability;
    Parameter birthRate;
    Parameter deathRate;
    Parameter serialSamplingRate;
    Parameter treatmentProbability;
    Parameter originTime;
    int numIntervals;
    double gridEnd;
    double[] modelStartTimes = null;
    private final boolean conditionOnSurvival;
    double modelStartTime;
    double A;
    double B;
    double previousP;
    double lambda;
    double mu;
    double psi;
    double r;
    double rho;
    double logRho;
    private boolean[] gradientFlags;
    double savedLogQ;
    private double savedQ;
    private double[] partialQ;
    private boolean partialQKnown;
    private final double[] dQStart;
    private final double[] dQEnd;
    private double[] temp33;
    private final double[] temp44;
    private double eAt_Old;
    private double eAt_End;
    final double[] dA;
    final double[] dB;
    private final double[] dG2;
    boolean computedBCurrent;
    private final double[] dPIntervalEnd;
    protected final double[] dPModelEnd;
    private final double[] dPModelEnd_prev;
    private static final double log4 = Math.log(4.0);
    private static final boolean AOS = true;

    public NewBirthDeathSerialSamplingModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Parameter parameter6, boolean bl, int n, double d, Units.Type type) {
        this("NewBirthDeathSerialSamplingModel", parameter, parameter2, parameter3, parameter4, parameter5, parameter6, bl, n, d, type);
    }

    @Override
    public SpeciationModelGradientProvider getProvider() {
        return this;
    }

    public NewBirthDeathSerialSamplingModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Parameter parameter6, boolean bl, int n, double d, Units.Type type) {
        super(string, type);
        this.numIntervals = n;
        this.gridEnd = d;
        if (parameter.getSize() != 1 && parameter.getSize() != n) {
            throw new RuntimeException("Length of birthRate parameter should be one or equal to the size of time parameter (size = " + n + ")");
        }
        if (parameter2.getSize() != 1 && parameter2.getSize() != n) {
            throw new RuntimeException("Length of deathRate parameter should be one or equal to the size of time parameter (size = " + n + ")");
        }
        if (parameter3.getSize() != 1 && parameter3.getSize() != n) {
            throw new RuntimeException("Length of serialSamplingRate parameter should be one or equal to the size of time parameter (size = " + n + ")");
        }
        if (parameter4.getSize() != 1 && parameter4.getSize() != n) {
            throw new RuntimeException("Length of r parameter should be one or equal to the size of time parameter (size = " + n + ")");
        }
        if (parameter5.getSize() != 1 && parameter5.getSize() != n) {
            throw new RuntimeException("Length of samplingProbability parameter should be one or equal to the size of time parameter (size = " + n + ")");
        }
        this.birthRate = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getSize()));
        this.deathRate = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter2.getSize()));
        this.serialSamplingRate = parameter3;
        this.addVariable(parameter3);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter3.getSize()));
        this.treatmentProbability = parameter4;
        this.addVariable(parameter4);
        parameter5.addBounds(new Parameter.DefaultBounds(1.0, 0.0, parameter4.getSize()));
        this.samplingProbability = parameter5;
        this.addVariable(parameter5);
        parameter5.addBounds(new Parameter.DefaultBounds(1.0, 0.0, parameter5.getSize()));
        this.conditionOnSurvival = bl;
        this.originTime = parameter6;
        if (parameter6 != null) {
            this.addVariable(parameter6);
            parameter6.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        this.savedLogQ = Double.NaN;
        this.savedQ = Double.NaN;
        this.partialQ = new double[4 * n];
        this.partialQKnown = false;
        this.dA = new double[4];
        this.dG2 = new double[3];
        this.dB = new double[n * 4];
        this.dQStart = new double[n * 4];
        this.dQEnd = new double[n * 4];
        this.temp33 = new double[n * 4];
        this.temp44 = new double[n * 4];
        this.dPIntervalEnd = new double[n * 4];
        this.dPModelEnd = new double[n * 4];
        this.dPModelEnd_prev = new double[n * 4];
        this.gridEnd = d;
        this.numIntervals = n;
        this.gradientFlags = new boolean[5];
        Arrays.fill(this.gradientFlags, Boolean.TRUE);
    }

    public void setupGradientFlags(boolean[] blArray) {
        this.gradientFlags = blArray;
    }

    public void setupTimeline(double[] dArray) {
        if (this.modelStartTimes == null) {
            this.modelStartTimes = new double[this.numIntervals];
        } else {
            Arrays.fill(this.modelStartTimes, 0.0);
        }
        if (dArray != null) {
            if (dArray.length != this.numIntervals) {
                throw new IllegalArgumentException("grids has the wrong dimension " + dArray.length + ", not matching number of intervals " + this.numIntervals + "!");
            }
            this.modelStartTimes = dArray;
        } else {
            for (int i = 1; i <= this.numIntervals - 1; ++i) {
                this.modelStartTimes[i] = (double)i * (this.gridEnd / (double)this.numIntervals);
            }
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    final double p(int n, double d) {
        double d2 = Math.exp(this.A * (d - this.modelStartTimes[n]));
        return this.p(d2);
    }

    private double p(double d) {
        double d2 = d * (1.0 + this.B);
        return (this.lambda + this.mu + this.psi - this.A * ((d2 - (1.0 - this.B)) / (d2 + (1.0 - this.B)))) / (2.0 * this.lambda);
    }

    double logQ(int n, double d) {
        double d2 = this.A * (d - this.modelStartTimes[n]);
        double d3 = Math.exp(d2);
        double d4 = this.g1(d3);
        return d2 + log4 - 2.0 * Math.log(d4);
    }

    private static double computeA(double d, double d2, double d3) {
        return Math.abs(Math.sqrt(Math.pow(d - d2 - d3, 2.0) + 4.0 * d * d3));
    }

    private static double computeB(double d, double d2, double d3, double d4, double d5, double d6) {
        return ((1.0 - 2.0 * (1.0 - d4) * d6) * d + d2 + d3) / d5;
    }

    @Override
    public double logConditioningProbability(int n) {
        double d = 0.0;
        if (this.conditionOnSurvival) {
            double d2 = this.originTime.getParameterValue(0);
            double[] dArray = this.getBreakPoints();
            double d3 = dArray[n];
            while (d2 >= d3) {
                this.updateLikelihoodModelValues(++n);
                d3 = dArray[n];
            }
            d -= Math.log(1.0 - this.p(n, d2));
        }
        return d;
    }

    @Override
    public final double calculateTreeLogLikelihood(Tree tree) {
        throw new RuntimeException("To be removed");
    }

    @Override
    public double[] getBreakPoints() {
        double[] dArray = new double[this.numIntervals];
        System.arraycopy(this.modelStartTimes, 1, dArray, 0, this.numIntervals - 1);
        dArray[this.numIntervals - 1] = Double.POSITIVE_INFINITY;
        return dArray;
    }

    @Override
    public double processModelSegmentBreakPoint(int n, double d, double d2, int n2) {
        double d3 = (double)n2 * (this.logQ(n, d2) - this.logQ(n, d));
        if ((Double)this.samplingProbability.getValue(n + 1) > 0.0 && (Double)this.samplingProbability.getValue(n + 1) < 1.0) {
            d3 += (double)n2 * Math.log(1.0 - (Double)this.samplingProbability.getValue(n + 1));
        }
        this.savedLogQ = Double.NaN;
        return d3;
    }

    private void updateParameterValues(int n) {
        this.lambda = this.birthRate.getParameterValue(n);
        this.mu = this.deathRate.getParameterValue(n);
        this.psi = this.serialSamplingRate.getParameterValue(n);
        this.r = this.treatmentProbability.getParameterValue(n);
        this.rho = this.samplingProbability.getParameterValue(n);
        this.savedLogQ = Double.NaN;
    }

    @Override
    public void updateLikelihoodModelValues(int n) {
        this.modelStartTime = this.modelStartTimes[n];
        this.previousP = n == 0 ? 1.0 : this.p(n - 1, this.modelStartTime);
        this.updateParameterValues(n);
        this.A = NewBirthDeathSerialSamplingModel.computeA(this.lambda, this.mu, this.psi);
        this.B = NewBirthDeathSerialSamplingModel.computeB(this.lambda, this.mu, this.psi, this.rho, this.A, this.previousP);
    }

    @Override
    public void updateGradientModelValues(int n) {
        this.modelStartTime = this.modelStartTimes[n];
        this.previousP = n == 0 ? 1.0 : this.p(this.eAt_End);
        this.updateParameterValues(n);
        this.A = NewBirthDeathSerialSamplingModel.computeA(this.lambda, this.mu, this.psi);
        this.B = NewBirthDeathSerialSamplingModel.computeB(this.lambda, this.mu, this.psi, this.rho, this.A, this.previousP);
        this.savedQ = Double.NaN;
        this.partialQKnown = false;
        this.dACompute(this.dA);
        this.dBCompute(n, this.dB);
        System.arraycopy(this.dPModelEnd, 0, this.dPModelEnd_prev, 0, this.numIntervals * 4);
        if (this.numIntervals > 1 && n < this.numIntervals - 1) {
            double d = this.modelStartTimes[n + 1];
            double d2 = this.modelStartTimes[n];
            this.eAt_End = Math.exp(this.A * (d - d2));
            this.dPCompute(n, d, d2, this.eAt_End, this.dPModelEnd, this.dG2);
        }
        this.computedBCurrent = true;
    }

    @Override
    public double processInterval(int n, double d, double d2, int n2) {
        double d3 = this.logQ(n, d2);
        double d4 = !Double.isNaN(this.savedLogQ) ? this.savedLogQ : this.logQ(n, d);
        this.savedLogQ = d3;
        return (double)n2 * (d3 - d4);
    }

    @Override
    public double processCoalescence(int n, double d) {
        return Math.log(this.lambda);
    }

    @Override
    public double processSampling(int n, double d) {
        double d2;
        boolean bl;
        boolean bl2 = d == this.modelStartTimes[n];
        boolean bl3 = bl = this.rho > 0.0;
        if (bl2 && bl) {
            d2 = Math.log(this.rho);
            if (n > 0) {
                d2 = Math.log(this.rho) + Math.log(this.r + (1.0 - this.r) * this.previousP);
            }
        } else {
            double d3 = Math.log(this.psi);
            d2 = d3 + Math.log(this.r + (1.0 - this.r) * this.p(n, d));
        }
        return d2;
    }

    @Override
    public double processOrigin(int n, double d) {
        if ((Double)this.originTime.getValue(0) < d) {
            return Double.NaN;
        }
        double[] dArray = this.getBreakPoints();
        double d2 = 0.0;
        double d3 = (Double)this.originTime.getValue(0);
        double d4 = d;
        double d5 = dArray[n];
        while (d3 >= d5) {
            d2 += this.processModelSegmentBreakPoint(n, d4, d5, 1);
            d4 = d5;
            this.updateLikelihoodModelValues(++n);
            d5 = dArray[n];
        }
        if (d4 < d3) {
            d2 += this.logQ(n, d3) - this.logQ(n, d4);
        }
        return d2;
    }

    @Override
    public double calculateTreeLogLikelihood(Tree tree, Set<Taxon> set) {
        if (set.size() == 0) {
            return this.calculateTreeLogLikelihood(tree);
        }
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "A (possibly episodic) serially-sampled birth-death model with the possibility of treatment (death when sampled) and intensive sampling.";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(new Citation(new Author[]{new Author("A", "Gavryushkina")}, "Bayesian Inference of Sampled Ancestor Trees", 2014, "PLoS Computational Biology", 10, 1, 15, "10.1371/journal.pcbi.1003919"));
    }

    final double g1(double d) {
        return (1.0 + this.B) * d + (1.0 - this.B);
    }

    final double g2(double d) {
        return this.A * (1.0 - 2.0 * (1.0 - this.B) / d);
    }

    public final double q(int n, double d) {
        double d2 = Math.exp(this.A * (d - this.modelStartTimes[n]));
        return this.q(d2);
    }

    public final double q(double d) {
        double d2 = this.g1(d);
        return 4.0 * d / (d2 * d2);
    }

    @Override
    public Parameter getSamplingProbabilityParameter() {
        return this.samplingProbability;
    }

    @Override
    public Parameter getDeathRateParameter() {
        return this.deathRate;
    }

    @Override
    public Parameter getBirthRateParameter() {
        return this.birthRate;
    }

    @Override
    public Parameter getSamplingRateParameter() {
        return this.serialSamplingRate;
    }

    @Override
    public Parameter getTreatmentProbabilityParameter() {
        return this.treatmentProbability;
    }

    private void dACompute(double[] dArray) {
        if (this.gradientFlags[0]) {
            dArray[0] = (this.lambda - this.mu + this.psi) / this.A;
        }
        if (this.gradientFlags[1]) {
            dArray[1] = (-this.lambda + this.mu + this.psi) / this.A;
        }
        if (this.gradientFlags[2]) {
            dArray[2] = (this.lambda + this.mu + this.psi) / this.A;
        }
    }

    void dBCompute(int n, double[] dArray) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray[i * 4 + j] = -2.0 * (1.0 - this.rho) * this.lambda / this.A * this.dPModelEnd[i * 4 + j];
            }
        }
        double d = 1.0 - 2.0 * (1.0 - this.rho) * this.previousP;
        dArray[n * 4 + 0] = (this.A * d - this.dA[0] * (d * this.lambda + this.mu + this.psi)) / (this.A * this.A);
        dArray[n * 4 + 1] = (this.A - this.dA[1] * (d * this.lambda + this.mu + this.psi)) / (this.A * this.A);
        dArray[n * 4 + 2] = (this.A - this.dA[2] * (d * this.lambda + this.mu + this.psi)) / (this.A * this.A);
        dArray[n * 4 + 3] = 2.0 * this.lambda * this.previousP / this.A;
    }

    void dPCompute(int n, double d, double d2, double d3, double[] dArray, double[] dArray2) {
        int n2;
        double d4 = this.g1(d3);
        double d5 = -this.A / this.lambda * ((1.0 - this.B) * (d3 - 1.0) + d4) / (d4 * d4);
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 0; i < 4; ++i) {
                dArray[n2 * 4 + i] = d5 * this.dB[n2 * 4 + i];
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            double d6 = d3 * (1.0 + this.B) * this.dA[n2] * (d - d2) + (d3 - 1.0) * this.dB[n * 4 + n2];
            dArray2[n2] = this.dA[n2] - 2.0 * (d4 * (this.dA[n2] * (1.0 - this.B) - this.dB[n * 4 + n2] * this.A) - (1.0 - this.B) * d6 * this.A) / (d4 * d4);
        }
        double d7 = this.g2(d4);
        dArray[n * 4 + 0] = (-this.mu - this.psi - this.lambda * dArray2[0] + d7) / (2.0 * this.lambda * this.lambda);
        dArray[n * 4 + 1] = (1.0 - dArray2[1]) / (2.0 * this.lambda);
        dArray[n * 4 + 2] = (1.0 - dArray2[2]) / (2.0 * this.lambda);
        dArray[n * 4 + 3] = -this.A / this.lambda * ((1.0 - this.B) * (d3 - 1.0) + d4) * this.dB[n * 4 + 3] / (d4 * d4);
    }

    private void dQCompute(int n, double d, double[] dArray) {
        double d2 = Math.exp(this.A * (d - this.modelStartTimes[n]));
        this.dQCompute(n, d, dArray, d2);
    }

    void dQCompute(int n, double d, double[] dArray, double d2) {
        double d3 = d - this.modelStartTimes[n];
        double d4 = this.g1(d2);
        double d5 = 8.0 * d2;
        double d6 = d4 / 2.0 - d2 * (1.0 + this.B);
        double d7 = d2 - 1.0;
        double d8 = d4 * d4 * d4;
        double d9 = -d5 * d7 / d8;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray[i * 4 + j] = d9 * this.dB[i * 4 + j];
            }
        }
        double d10 = d5 / d8;
        double d11 = d3 * d6;
        dArray[n * 4 + 0] = d10 * (this.dA[0] * d11 - this.dB[n * 4 + 0] * d7);
        dArray[n * 4 + 1] = d10 * (this.dA[1] * d11 - this.dB[n * 4 + 1] * d7);
        dArray[n * 4 + 2] = d10 * (this.dA[2] * d11 - this.dB[n * 4 + 2] * d7);
        dArray[n * 4 + 3] = d9 * this.dB[n * 4 + 3];
    }

    @Override
    public void precomputeGradientConstants() {
        this.savedQ = Double.NaN;
        this.partialQKnown = false;
    }

    @Override
    public void processGradientModelSegmentBreakPoint(double[] dArray, int n, double d, double d2, int n2) {
        double d3 = this.eAt_Old == 0.0 ? this.q(n, d) : this.q(this.eAt_Old);
        double d4 = this.q(n, d2);
        this.dQCompute(n, d, this.dQStart);
        this.dQCompute(n, d2, this.dQEnd, this.eAt_End);
        for (int i = 0; i < 4; ++i) {
            if (!this.gradientFlags[i]) continue;
            for (int j = 0; j <= n; ++j) {
                int n3 = NewBirthDeathSerialSamplingModel.genericIndex(j, i, this.numIntervals);
                dArray[n3] = dArray[n3] + (double)n2 * (this.dQEnd[j * 4 + i] / d4 - this.dQStart[j * 4 + i] / d3);
            }
        }
        if ((Double)this.samplingProbability.getValue(n + 1) > 0.0 && (Double)this.samplingProbability.getValue(n + 1) < 1.0) {
            int n4 = NewBirthDeathSerialSamplingModel.fractionIndex(n + 1, this.numIntervals);
            dArray[n4] = dArray[n4] - (double)n2 / (1.0 - (Double)this.samplingProbability.getValue(n + 1));
        }
    }

    @Override
    public void processGradientInterval(double[] dArray, int n, double d, double d2, int n2) {
        double[] dArray2;
        double[] dArray3 = this.temp44;
        this.eAt_Old = Math.exp(this.A * (d2 - this.modelStartTimes[n]));
        this.dQCompute(n, d2, dArray3, this.eAt_Old);
        double d3 = this.q(this.eAt_Old);
        double d4 = !Double.isNaN(this.savedQ) ? this.savedQ : this.q(n, d);
        this.savedQ = d3;
        if (this.partialQKnown) {
            double[] dArray4 = this.partialQ;
            this.partialQ = this.temp33;
            dArray2 = this.temp33 = dArray4;
        } else {
            dArray2 = this.temp33;
            this.dQCompute(n, d, dArray2);
            this.partialQKnown = true;
        }
        System.arraycopy(dArray3, 0, this.partialQ, 0, 4 * (n + 1));
        this.accumulateGradientForInterval(dArray, n, n2, dArray3, d3, dArray2, d4);
    }

    void accumulateGradientForInterval(double[] dArray, int n, int n2, double[] dArray2, double d, double[] dArray3, double d2) {
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n3 = i * 5 + j;
                dArray[n3] = dArray[n3] + (double)n2 * (dArray2[i * 4 + j] / d - dArray3[i * 4 + j] / d2);
            }
        }
    }

    void accumulateGradientForSerialSampling(double[] dArray, int n, double d, double[] dArray2) {
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n2 = i * 5 + j;
                dArray[n2] = dArray[n2] + d * dArray2[i * 4 + j];
            }
        }
    }

    void accumulateGradientForIntensiveSampling(double[] dArray, int n, double d, double[] dArray2) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n2 = i * 5 + j;
                dArray[n2] = dArray[n2] + d * dArray2[i * 4 + j];
            }
        }
    }

    void accumulateGradientForOrigin(double[] dArray, int n, double[] dArray2, double d, double[] dArray3, double d2) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j <= n; ++j) {
                int n2 = NewBirthDeathSerialSamplingModel.genericIndex(j, i, this.numIntervals);
                dArray[n2] = dArray[n2] + (dArray2[j * 4 + i] / d - dArray3[j * 4 + i] / d2);
            }
        }
    }

    @Override
    public void processGradientSampling(double[] dArray, int n, double d) {
        double d2;
        boolean bl;
        boolean bl2 = d == this.modelStartTimes[n];
        boolean bl3 = bl = this.rho > 0.0;
        if (bl2 && bl) {
            int n2 = NewBirthDeathSerialSamplingModel.fractionIndex(n, this.numIntervals);
            dArray[n2] = dArray[n2] + 1.0 / this.rho;
        } else {
            int n3 = NewBirthDeathSerialSamplingModel.samplingIndex(n, this.numIntervals);
            dArray[n3] = dArray[n3] + 1.0 / this.psi;
        }
        if (!bl2) {
            if (d == this.modelStartTimes[n]) {
                this.eAt_Old = Math.exp(this.A * (d - this.modelStartTimes[n]));
            }
            d2 = this.p(this.eAt_Old);
            int n4 = NewBirthDeathSerialSamplingModel.treatmentIndex(n, this.numIntervals);
            dArray[n4] = dArray[n4] + (1.0 - d2) / ((1.0 - this.r) * d2 + this.r);
            this.dPCompute(n, d, this.modelStartTimes[n], this.eAt_Old, this.dPIntervalEnd, this.dG2);
            double d3 = (1.0 - this.r) / ((1.0 - this.r) * d2 + this.r);
            this.accumulateGradientForSerialSampling(dArray, n, d3, this.dPIntervalEnd);
        }
        if (bl2 && n > 0) {
            int n5 = NewBirthDeathSerialSamplingModel.treatmentIndex(n, this.numIntervals);
            dArray[n5] = dArray[n5] + (1.0 - this.previousP) / ((1.0 - this.r) * this.previousP + this.r);
            d2 = (1.0 - this.r) / ((1.0 - this.r) * this.previousP + this.r);
            this.accumulateGradientForIntensiveSampling(dArray, n, d2, this.dPModelEnd_prev);
        }
    }

    @Override
    public void processGradientCoalescence(double[] dArray, int n, double d) {
        int n2 = NewBirthDeathSerialSamplingModel.birthIndex(n, this.numIntervals);
        dArray[n2] = dArray[n2] + 1.0 / this.lambda;
    }

    @Override
    public void processGradientOrigin(double[] dArray, int n, double d) {
        double d2;
        double d3 = (Double)this.originTime.getValue(0);
        double[] dArray2 = this.getBreakPoints();
        double d4 = d;
        while (d3 >= dArray2[n]) {
            d2 = dArray2[n];
            this.processGradientModelSegmentBreakPoint(dArray, n, d4, d2, 1);
            d4 = d2;
            this.updateGradientModelValues(++n);
        }
        if (d4 < d3) {
            d2 = this.q(n, d3);
            double d5 = this.q(n, d4);
            this.dQCompute(n, d3, this.dQEnd);
            this.dQCompute(n, d4, this.dQStart);
            this.accumulateGradientForOrigin(dArray, n, this.dQEnd, d2, this.dQStart, d5);
        }
    }

    @Override
    public void logConditioningProbability(int n, double[] dArray) {
        double d = 0.0;
        double[] dArray2 = new double[this.numIntervals * 4];
        if (this.conditionOnSurvival) {
            double d2 = this.originTime.getParameterValue(0);
            double[] dArray3 = this.getBreakPoints();
            double d3 = n > 0 ? dArray3[n - 1] : 0.0;
            double d4 = dArray3[n];
            while (d2 >= d4) {
                d3 = d4;
                this.updateGradientModelValues(++n);
                d4 = dArray3[n];
            }
            double d5 = Math.exp(this.A * (d2 - d3));
            d += 1.0 / (1.0 - this.p(d5));
            this.dPCompute(n, d2, d3, d5, dArray2, this.dG2);
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j <= n; ++j) {
                    int n2 = NewBirthDeathSerialSamplingModel.genericIndex(j, i, this.numIntervals);
                    dArray[n2] = dArray[n2] + d * dArray2[j * 4 + i];
                }
            }
        }
    }

    @Override
    public int getGradientLength() {
        return 5 * this.numIntervals;
    }

    private static int genericIndex(int n, int n2, int n3) {
        return n * 5 + n2;
    }

    private static int birthIndex(int n, int n2) {
        return n * 5;
    }

    private static int deathIndex(int n, int n2) {
        return n * 5 + 1;
    }

    private static int samplingIndex(int n, int n2) {
        return n * 5 + 2;
    }

    private static int fractionIndex(int n, int n2) {
        return n * 5 + 3;
    }

    private static int treatmentIndex(int n, int n2) {
        return n * 5 + 4;
    }

    private static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    private static void transpose(double[] dArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n2; ++j) {
                int n4 = j * n2 + n;
                NewBirthDeathSerialSamplingModel.swap(dArray, n4, n3);
                ++n3;
            }
        }
    }

    public abstract class ParameterPack
    implements Iterable<Parameter> {
        final Parameter birthRate;
        final Parameter deathRate;
        final Parameter samplingRate;
        final Parameter samplingProbability;
        final Parameter treatmentProbability;
        final Parameter originTime;
        final Parameter grid;
        final int dim;
        final List<Parameter> parameterList = new ArrayList<Parameter>();

        private ParameterPack(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Parameter parameter6, Parameter parameter7) {
            this.birthRate = parameter;
            this.deathRate = parameter2;
            this.samplingRate = parameter3;
            this.samplingProbability = parameter4;
            this.treatmentProbability = parameter5;
            this.originTime = parameter6;
            this.grid = parameter7;
            this.dim = parameter7 == null ? 1 : parameter7.getDimension() + 1;
            this.addIfNotNull(parameter, Double.POSITIVE_INFINITY, 0.0, this.dim);
            this.addIfNotNull(parameter2, Double.POSITIVE_INFINITY, 0.0, this.dim);
            this.addIfNotNull(parameter3, Double.POSITIVE_INFINITY, 0.0, this.dim);
            this.addIfNotNull(parameter4, 1.0, 0.0, this.dim);
            this.addIfNotNull(parameter5, 1.0, 0.0, this.dim);
            this.addIfNotNull(parameter6, Double.POSITIVE_INFINITY, 0.0, 1);
        }

        public abstract double getBirthRate(int var1);

        public abstract double getDeathRate(int var1);

        public abstract double getSamplingRate(int var1);

        public abstract double getSamplingProbability(int var1);

        public abstract double getTreatmentProbability(int var1);

        public double getOriginTime() {
            return this.originTime.getParameterValue(0);
        }

        public double[] getGrid() {
            double[] dArray = new double[this.dim + 1];
            dArray[0] = 0.0;
            for (int i = 1; i < this.dim; ++i) {
                dArray[i] = this.grid.getParameterValue(i - 1);
            }
            dArray[this.dim] = Double.POSITIVE_INFINITY;
            return dArray;
        }

        private void addIfNotNull(Parameter parameter, double d, double d2, int n) {
            if (parameter != null) {
                if (parameter.getDimension() != n) {
                    throw new IllegalArgumentException("Parameter '" + parameter.getId() + "' has the wrong dimension");
                }
                this.parameterList.add(parameter);
                parameter.addBounds(new Parameter.DefaultBounds(d, d2, n));
            }
        }

        public boolean contains(Variable variable) {
            return this.parameterList.contains((Parameter)variable);
        }

        @Override
        public Iterator<Parameter> iterator() {
            return this.parameterList.iterator();
        }

        public class Episodic
        extends ParameterPack {
            public Episodic(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Parameter parameter6, Parameter parameter7) {
                super(parameter, parameter2, parameter3, parameter4, parameter5, parameter6, parameter7);
            }

            @Override
            public double getBirthRate(int n) {
                return this.birthRate.getParameterValue(n);
            }

            @Override
            public double getDeathRate(int n) {
                return this.deathRate.getParameterValue(n);
            }

            @Override
            public double getSamplingRate(int n) {
                return this.samplingRate.getParameterValue(n);
            }

            @Override
            public double getSamplingProbability(int n) {
                return this.samplingProbability.getParameterValue(n);
            }

            @Override
            public double getTreatmentProbability(int n) {
                return this.treatmentProbability.getParameterValue(n);
            }
        }

        public class Constant
        extends ParameterPack {
            public Constant(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Parameter parameter6) {
                super(parameter, parameter2, parameter3, parameter4, parameter5, parameter6, null);
            }

            @Override
            public double getBirthRate(int n) {
                return this.birthRate.getParameterValue(0);
            }

            @Override
            public double getDeathRate(int n) {
                return this.deathRate.getParameterValue(0);
            }

            @Override
            public double getSamplingRate(int n) {
                return this.samplingRate.getParameterValue(0);
            }

            @Override
            public double getSamplingProbability(int n) {
                return this.samplingProbability.getParameterValue(0);
            }

            @Override
            public double getTreatmentProbability(int n) {
                return this.treatmentProbability.getParameterValue(0);
            }
        }
    }
}

