/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.DataType;
import java.util.ArrayList;

public class Microsatellite
extends DataType {
    public static final String DESCRIPTION = "microsatellite";
    public static int UNKNOWN_STATE_LENGTH = -1;
    private int min;
    private int max;
    private int unitLength;
    private String name;
    public static final Microsatellite INSTANCE = new Microsatellite();

    public Microsatellite() {
    }

    public Microsatellite(String string, int n, int n2) {
        this(string, n, n2, 1);
    }

    public Microsatellite(int n, int n2) {
        this("microsat", n, n2, 1);
    }

    public Microsatellite(String string, int n, int n2, int n3) {
        this.min = n;
        this.max = n2;
        this.name = string;
        this.unitLength = n3;
        this.stateCount = (n2 - n) / n3 + 1;
        this.ambiguousStateCount = this.stateCount + 1;
    }

    public Microsatellite(int[] nArray, int n, int n2) {
        this.unitLength = n2;
        this.min = nArray[0];
        this.max = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (this.min > nArray[i] && nArray[i] > 0) {
                this.min = nArray[i];
            }
            if (this.max >= nArray[i] || nArray[i] <= 0) continue;
            this.max = nArray[i];
        }
        this.max += n * this.unitLength;
        this.min -= n * this.unitLength;
        if ((this.max - this.min) % this.unitLength != 0) {
            throw new IllegalArgumentException("Incorrect microsatellite unit length.");
        }
        this.stateCount = (this.max - this.min) / this.unitLength + 1;
        this.ambiguousStateCount = this.stateCount + 1;
    }

    @Override
    public int getState(String string) {
        char c = string.charAt(0);
        try {
            if (c == '?') {
                return this.getState(UNKNOWN_STATE_LENGTH);
            }
            return this.getState(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(string + " can not be converted. State needs to be an integer or unknown (?).");
        }
    }

    public int getState(int n) {
        if (n != UNKNOWN_STATE_LENGTH) {
            if (n < this.min) {
                throw new IllegalArgumentException("Microsatellite length value is less, (" + n + ") than the specified minimum (" + this.min + ").");
            }
            return (int)Math.ceil(((double)n - (double)this.min) / (double)this.unitLength);
        }
        return this.stateCount;
    }

    public static int[] convertToLengths(ArrayList<String> arrayList) {
        return Microsatellite.convertToLengths(arrayList.toArray(new String[arrayList.size()]));
    }

    public static int[] convertToLengths(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            char c = stringArray[i].charAt(0);
            try {
                if (c == '?') {
                    nArray[i] = UNKNOWN_STATE_LENGTH;
                    continue;
                }
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(stringArray[i] + " can not be converted. State needs to be an integer or unknown (?).");
            }
        }
        return nArray;
    }

    public int getActualLength(int n) {
        if (n < this.stateCount) {
            return n + this.min;
        }
        if (n == this.stateCount) {
            return UNKNOWN_STATE_LENGTH;
        }
        throw new RuntimeException("The given state must be an integer greater or equal to -1");
    }

    public boolean isWithinRange(int n) {
        return n >= this.min && n <= this.max;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public void setMin(int n) {
        this.min = n;
    }

    @Override
    public boolean isUnknownState(int n) {
        return n == this.stateCount;
    }

    @Override
    public char[] getValidChars() {
        return null;
    }

    @Override
    public int getStateCount() {
        return this.stateCount;
    }

    @Override
    public int getAmbiguousStateCount() {
        return this.ambiguousStateCount;
    }

    public int getUnitLength() {
        return this.unitLength;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getType() {
        return 6;
    }
}

