/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo.internal;

import java.util.ArrayList;
import java.util.Collections;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarmaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.FastKalmanFilter;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.HannanRissanen;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ArmaModelSelector {
    private FastBIC[] hrModels;
    private final int nmodels;
    private static final int NMOD = 5;
    private final boolean acceptwn;
    private final int maxP;
    private final int maxBp;
    private final int maxQ;
    private final int maxBq;

    public static Builder builder() {
        return new Builder();
    }

    private ArmaModelSelector(int nmod, boolean acceptwn, int maxP, int maxQ, int maxBp, int maxBq) {
        this.nmodels = nmod;
        this.acceptwn = acceptwn;
        this.maxP = maxP;
        this.maxQ = maxQ;
        this.maxBp = maxBp;
        this.maxBq = maxBq;
    }

    public FastBIC[] gePreferredModels() {
        return this.hrModels;
    }

    private void clear() {
        this.hrModels = null;
    }

    public SarimaModel Arma(int idx) {
        return this.hrModels[idx].getArma();
    }

    private SarmaOrders select(int d, int bd) {
        int idmax;
        for (idmax = this.nmodels; this.hrModels[idmax - 1] == null || this.hrModels[idmax - 1].getArma() == null && idmax > 0; --idmax) {
        }
        if (idmax == 0) {
            return null;
        }
        if (idmax == 1) {
            return this.hrModels[0].getSpecification();
        }
        SarmaOrders spec = this.hrModels[0].getSpecification();
        int nr1 = spec.getP() + spec.getQ();
        int ns1 = spec.getBp() + spec.getBq();
        int nrr1 = Math.abs(spec.getP() + d - spec.getQ());
        int nss1 = Math.abs(spec.getBp() + bd - spec.getBq());
        double bmax = this.hrModels[idmax - 1].getBIC() - this.hrModels[0].getBIC();
        bmax = bmax < 0.003 ? 0.0625 : (bmax < 0.03 ? 0.25 : 1.0);
        double vc11 = 0.01 * bmax;
        double vc2 = 0.0025 * bmax;
        double vc22 = 0.0075 * bmax;
        int idpref = 0;
        for (int i = 1; i < idmax; ++i) {
            SarmaOrders cur = this.hrModels[i].getSpecification();
            int nr2 = cur.getP() + cur.getQ();
            int ns2 = cur.getBp() + cur.getBq();
            int nrr2 = Math.abs(cur.getP() + d - cur.getQ());
            int nss2 = Math.abs(cur.getBp() + bd - cur.getBq());
            double dbic = this.hrModels[i].getBIC() - this.hrModels[idpref].getBIC();
            if (!((nrr2 < nrr1 || nss2 < nss1) && nr1 == nr2 && ns1 == ns2 && dbic <= vc11 || nrr2 < nrr1 && nr2 <= nr1 && ns2 == ns1 && dbic <= vc2 && cur.getP() > 0 && cur.getQ() > 0 || (nrr2 == 0 && nrr2 < nrr1 && d > 0 || nss2 == 0 && nss2 < nss1 && bd > 0) && nr1 == nr2 && ns1 == ns2 && dbic <= vc11 || nrr2 == 0 && nss2 == 0 && dbic < vc2 || nr2 > nr1 && nrr2 == 0 && ns2 == ns1 && dbic < vc2 || i == 1 && nr1 == 0 && nr2 == 1 && ns2 == ns1 && dbic < vc2 || ns2 > ns1 && nss2 == 0 && nr2 == nr1 && dbic < vc2 || nr2 < nr1 && nr2 > 0 && ns2 == ns1 && dbic < vc2 || cur.getP() < spec.getP() && cur.getQ() == spec.getQ() && nr2 > 0 && ns2 == ns1 && dbic < vc22 || ns2 < ns1 && ns2 > 0 && nr2 == nr1 && nss2 == 0 && dbic < vc2) && (ns2 >= ns1 || ns2 <= 0 || nr2 != nr1 || !(dbic < vc2))) continue;
            double dc = this.hrModels[i].getBIC() - this.hrModels[0].getBIC();
            vc11 -= dc;
            vc2 -= dc;
            vc22 -= dc;
            nr1 = nr2;
            ns1 = ns2;
            nrr1 = nrr2;
            nss1 = nss2;
            idpref = i;
            spec = cur.clone();
        }
        if (spec.getParametersCount() == 0 && idpref < this.nmodels - 1) {
            return this.hrModels[idpref + 1].getSpecification();
        }
        return this.hrModels[idpref].getSpecification();
    }

    static FastBIC[] sort(DoubleSeq data, SarmaOrders[] specs) {
        ArrayList<FastBIC> hrs = new ArrayList<FastBIC>();
        for (int i = 0; i < specs.length; ++i) {
            SarimaModel m;
            HannanRissanen hr = HannanRissanen.builder().build();
            if (!hr.process(data, specs[i]) || !(m = hr.getModel()).isStable(true)) continue;
            FastBIC hrbic = new FastBIC(data, m);
            hrs.add(hrbic);
        }
        Collections.sort(hrs);
        return hrs.toArray(new FastBIC[hrs.size()]);
    }

    static SarmaOrders getPreferredSpecification(FastBIC[] hrs, boolean acceptwn) {
        int idx;
        if (hrs.length == 0) {
            return null;
        }
        if (hrs.length == 1 || acceptwn) {
            return hrs[0].arma.orders().doStationary();
        }
        for (idx = 0; idx < hrs.length && hrs[idx].arma.orders().getParametersCount() == 0; ++idx) {
        }
        return hrs[idx].arma.orders().doStationary();
    }

    static void mergeInto(FastBIC[] candidates, FastBIC[] models) {
        int nmax = candidates.length;
        int gmod = models.length;
        if (nmax > gmod) {
            nmax = gmod;
        }
        int icur = 0;
        block0: for (int i = 0; i < nmax && icur < gmod; ++i) {
            SarimaModel cur = candidates[i].getArma();
            SarimaOrders curSpec = cur.orders();
            double bic = candidates[i].getBIC();
            for (int j = icur; j < gmod; ++j) {
                if (models[j] == null) {
                    models[j] = candidates[i];
                    icur = j + 1;
                    continue block0;
                }
                if (models[j].getArma().orders().equals((Object)curSpec)) {
                    icur = j + 1;
                    continue block0;
                }
                if (!(models[j].getBIC() > bic)) continue;
                for (int k = gmod - 1; k > j; --k) {
                    models[k] = models[k - 1];
                }
                models[j] = candidates[i];
                icur = j + 1;
                continue block0;
            }
        }
    }

    public SarmaOrders process(DoubleSeq data, int period, int d, int bd, boolean seas) {
        SarmaOrders cur;
        int i;
        this.clear();
        SarmaOrders[] specs = new SarmaOrders[(this.maxBp + 1) * (this.maxBq + 1)];
        SarmaOrders spec = new SarmaOrders(period);
        this.hrModels = new FastBIC[this.nmodels];
        spec.setP(3);
        spec.setQ(0);
        if (seas) {
            i = 0;
            for (int bp = 0; bp <= this.maxBp; ++bp) {
                for (int bq = 0; bq <= this.maxBq; ++bq) {
                    spec.setBp(bp);
                    spec.setBq(bq);
                    specs[i++] = spec.clone();
                }
            }
            FastBIC[] hrs0 = ArmaModelSelector.sort(data, specs);
            if (0 == hrs0.length) {
                for (i = 0; i < specs.length; ++i) {
                    specs[i].setP(1);
                }
                hrs0 = ArmaModelSelector.sort(data, specs);
                if (0 == hrs0.length) {
                    return null;
                }
            }
            cur = ArmaModelSelector.getPreferredSpecification(hrs0, this.acceptwn);
            if (spec.getP() <= this.maxP) {
                ArmaModelSelector.mergeInto(hrs0, this.hrModels);
            }
        } else {
            cur = spec.clone();
        }
        specs = new SarmaOrders[(this.maxP + 1) * (this.maxQ + 1)];
        i = 0;
        for (int p = 0; p <= this.maxP; ++p) {
            for (int q = 0; q <= this.maxQ; ++q) {
                cur.setP(p);
                cur.setQ(q);
                specs[i++] = cur.clone();
            }
        }
        FastBIC[] hrs1 = ArmaModelSelector.sort(data, specs);
        if (0 == hrs1.length) {
            return null;
        }
        cur = ArmaModelSelector.getPreferredSpecification(hrs1, this.acceptwn);
        ArmaModelSelector.mergeInto(hrs1, this.hrModels);
        if (seas) {
            specs = new SarmaOrders[(this.maxBp + 1) * (this.maxBq + 1)];
            int i2 = 0;
            for (int bp = 0; bp <= this.maxBp; ++bp) {
                for (int bq = 0; bq <= this.maxBq; ++bq) {
                    cur.setBp(bp);
                    cur.setBq(bq);
                    specs[i2++] = cur.clone();
                }
            }
            FastBIC[] hrs2 = ArmaModelSelector.sort(data, specs);
            if (0 == hrs2.length) {
                return null;
            }
            ArmaModelSelector.mergeInto(hrs2, this.hrModels);
        }
        if (!seas) {
            if (this.hrModels[1] != null && this.hrModels[0].arma.getParametersCount() == 0 && !this.acceptwn) {
                return this.hrModels[1].getSpecification();
            }
            return this.hrModels[0].getSpecification();
        }
        return this.select(d, bd);
    }

    public static class Builder {
        private int modelsCount = 5;
        private boolean wn = false;
        private int maxP = 3;
        private int maxBp = 1;
        private int maxQ = 3;
        private int maxBq = 1;

        private Builder() {
        }

        public Builder modelsCount(int n) {
            this.modelsCount = n;
            return this;
        }

        public Builder maxP(int p) {
            this.maxP = p;
            return this;
        }

        public Builder maxBp(int bp) {
            this.maxBp = bp;
            return this;
        }

        public Builder maxQ(int q) {
            this.maxQ = q;
            return this;
        }

        public Builder maxBq(int bq) {
            this.maxBq = bq;
            return this;
        }

        public Builder acceptWhiteNoise(boolean ok) {
            this.wn = ok;
            return this;
        }

        public ArmaModelSelector build() {
            return new ArmaModelSelector(this.modelsCount, this.wn, this.maxP, this.maxQ, this.maxBp, this.maxBq);
        }
    }

    public static final class FastBIC
    implements Comparable<FastBIC> {
        private final SarimaModel arma;
        private final double BIC;

        FastBIC(DoubleSeq data, SarimaModel arma) {
            this.arma = arma;
            FastKalmanFilter fkf = new FastKalmanFilter((IArimaModel)arma);
            this.BIC = fkf.fastProcessing(data, arma.getParametersCount());
        }

        @Override
        public int compareTo(FastBIC o) {
            return Double.compare(this.BIC, o.BIC);
        }

        public SarmaOrders getSpecification() {
            return this.arma == null ? null : this.arma.orders().doStationary();
        }

        @Generated
        public SarimaModel getArma() {
            return this.arma;
        }

        @Generated
        public double getBIC() {
            return this.BIC;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FastBIC)) {
                return false;
            }
            FastBIC other = (FastBIC)o;
            if (Double.compare(this.getBIC(), other.getBIC()) != 0) {
                return false;
            }
            SarimaModel this$arma = this.getArma();
            SarimaModel other$arma = other.getArma();
            return !(this$arma == null ? other$arma != null : !this$arma.equals(other$arma));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $BIC = Double.doubleToLongBits(this.getBIC());
            result = result * 59 + (int)($BIC >>> 32 ^ $BIC);
            SarimaModel $arma = this.getArma();
            result = result * 59 + ($arma == null ? 43 : $arma.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "ArmaModelSelector.FastBIC(arma=" + String.valueOf(this.getArma()) + ", BIC=" + this.getBIC() + ")";
        }
    }
}

