/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.sa.base.core.tests.SeasonalityTests;
import jdplus.sa.base.core.tests.SpectralPeaks;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.regsarima.regular.SeasonalFTest;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihood;
import jdplus.tramoseats.base.core.tramo.ModelComparator;
import jdplus.tramoseats.base.core.tramo.ModelController;
import jdplus.tramoseats.base.core.tramo.ModelStatistics;
import jdplus.tramoseats.base.core.tramo.SeasonalOverDifferencingTest;
import jdplus.tramoseats.base.core.tramo.TramoContext;

class SeasonalityController
extends ModelController {
    public static final String SEAS = "seasonality detected";
    private StatisticalTest ftest;
    private SeasonalityTests stests;
    private ModelStatistics mstats;

    @Override
    ProcessingResult process(RegSarimaModelling modelling, TramoContext context) {
        if (modelling.getDescription().getAnnualFrequency() == 1) {
            return ProcessingResult.Unprocessed;
        }
        ProcessingResult result = this.getReferenceModel() == null ? this.computeReferenceModel(modelling, context) : this.compareReferenceModels(modelling);
        return result;
    }

    private void computeSTests() {
        RegSarimaModelling refestimation = this.getReferenceModel();
        DoubleSeq lin = refestimation.getEstimation().linearizedSeries();
        int del = 1;
        this.stests = new SeasonalityTests();
        this.stests.test(lin, refestimation.getDescription().getAnnualFrequency(), del, true);
        this.mstats = ModelStatistics.of(refestimation.getDescription(), (ConcentratedLikelihood)refestimation.getEstimation().getConcentratedLikelihood());
    }

    private boolean hasSeasonality(RegSarimaModelling modelling, TramoContext context) {
        boolean fs;
        int n;
        StatisticalTest np;
        int period = modelling.getDescription().getAnnualFrequency();
        if (this.stests == null) {
            return false;
        }
        int score = 0;
        int nscore = 0;
        if (this.mstats.getSeasonalLjungBoxPvalue() < 0.01) {
            ++score;
            ++nscore;
        }
        if ((np = this.stests.getNonParametricTest()) != null && np.isSignificant(0.01)) {
            ++score;
        }
        if (((n = this.stests.getDifferencing().getDifferenced().length()) >= 80 || period != 12 && n >= 60) && SpectralPeaks.hasSeasonalPeaks((SpectralPeaks[])this.stests.getSpectralPeaks())) {
            ++score;
        }
        SeasonalFTest f = new SeasonalFTest();
        f.test(this.getReferenceModel().getDescription());
        this.ftest = f.getFTest();
        boolean bl = fs = this.ftest.getPvalue() < 0.01;
        if (fs) {
            ++score;
            ++nscore;
        }
        context.originalSeasonalityTest = score;
        if (score > 1 || nscore > 0) {
            return true;
        }
        return fs || this.mstats.getSeasonalLjungBoxPvalue() < 0.01;
    }

    private ProcessingResult computeReferenceModel(RegSarimaModelling modelling, TramoContext context) {
        this.setReferenceModel(modelling);
        this.computeSTests();
        boolean seas = this.hasSeasonality(modelling, context);
        SarimaOrders spec = modelling.getDescription().specification();
        SarimaOrders nspec = null;
        if (!seas && spec.isSeasonal()) {
            nspec = SarimaOrders.m011((int)spec.getPeriod());
            nspec.setBq(1);
        } else if (!context.seasonal && seas) {
            context.seasonal = true;
            return ProcessingResult.Changed;
        }
        if (!context.seasonal && (this.mstats.getSeasonalLjungBoxPvalue() < 0.05 || this.mstats.getLjungBoxPvalue() < 0.05)) {
            context.seasonal = true;
            nspec = SarimaOrders.m011((int)spec.getPeriod());
            nspec.setBq(1);
        }
        if (nspec != null) {
            ModelDescription desc = ModelDescription.copyOf((ModelDescription)modelling.getDescription());
            desc.setSpecification(nspec);
            RegSarimaModelling ncontext = RegSarimaModelling.of((ModelDescription)desc);
            if (this.estimate(ncontext, false)) {
                this.transferInformation(ncontext, modelling);
                this.setReferenceModel(modelling);
                return ProcessingResult.Changed;
            }
        }
        return ProcessingResult.Unchanged;
    }

    private ProcessingResult compareReferenceModels(RegSarimaModelling context) {
        ModelComparator cmp;
        int icmp;
        RegSarimaModelling referenceModel = this.getReferenceModel();
        ModelComparator.Preference pref = ModelComparator.Preference.BIC;
        if (!referenceModel.getDescription().specification().equals((Object)context.getDescription().specification())) {
            SeasonalOverDifferencingTest overseas = new SeasonalOverDifferencingTest();
            switch (overseas.test(context)) {
                case 1: {
                    pref = ModelComparator.Preference.First;
                    break;
                }
                case 2: {
                    pref = ModelComparator.Preference.Second;
                }
            }
        }
        if ((icmp = (cmp = ModelComparator.builder().preference(pref).build()).compare(context, referenceModel)) <= 0) {
            this.setReferenceModel(context);
            return ProcessingResult.Unchanged;
        }
        this.transferInformation(referenceModel, context);
        return ProcessingResult.Changed;
    }
}

